/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.channel.DMRLsn;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPMessageType;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusOTAAnnouncement
extends CSBKMessage
implements ITimeslotFrequencyReceiver {
    private static final int[] MESSAGE_TYPE = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] VERSION = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] UNKNOWN = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62};
    private static final int[] LOGICAL_SLOT_NUMBER = new int[]{63, 64, 65, 66, 67};
    private DMRLsn mDataChannel;
    private List<Identifier> mIdentifiers;

    public ConnectPlusOTAAnnouncement(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CON+ ANNOUNCE OTA ").append((Object)this.getMessageType());
        sb.append(" VER:").append(this.getMessageVersion());
        sb.append(" AVAILABLE ON ").append(this.getDataChannel());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public XCMPMessageType getMessageType() {
        return XCMPMessageType.fromValue(this.getMessage().getInt(MESSAGE_TYPE));
    }

    public int getMessageVersion() {
        return this.getMessage().getInt(VERSION);
    }

    public int getDataLsn() {
        return this.getMessage().getInt(LOGICAL_SLOT_NUMBER) - 1;
    }

    public DMRLsn getDataChannel() {
        if (this.mDataChannel == null) {
            this.mDataChannel = new DMRLsn(this.getDataLsn());
        }
        return this.mDataChannel;
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return this.getDataChannel().getLogicalChannelNumbers();
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        this.getDataChannel().apply(timeslotFrequencies);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getDataChannel());
        }
        return this.mIdentifiers;
    }
}

