/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.List;

public class ConnectPlusDataRevertWindowAnnouncement
extends CSBKMessage {
    private static final int[] WINDOW = new int[]{16, 17, 18, 19, 20, 21, 22};
    private static final int[] SUPERFRAME = new int[]{24, 25, 26, 27};
    private static final int[] REPEATER = new int[]{28, 29, 30, 31};
    private static final int[] TARGET_RADIO = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private List<Identifier> mIdentifiers;
    private RadioIdentifier mTargetRadio;

    public ConnectPlusDataRevertWindowAnnouncement(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" CSBK CON+ ENHANCED DATA REVERT CHANNEL ANNOUNCE WINDOW:");
        sb.append(this.getSuperFrame()).append(".").append(this.getWindow());
        if (this.hasTargetRadio()) {
            sb.append(" RESERVED FOR:").append(this.getTargetRadio());
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public RadioIdentifier getTargetRadio() {
        if (this.mTargetRadio == null) {
            this.mTargetRadio = DMRRadio.createTo(this.getMessage().getInt(TARGET_RADIO));
        }
        return this.mTargetRadio;
    }

    public boolean hasTargetRadio() {
        return this.getMessage().getInt(TARGET_RADIO) > 0;
    }

    public int getSuperFrame() {
        return this.getMessage().getInt(SUPERFRAME);
    }

    public int getWindow() {
        return this.getMessage().getInt(WINDOW);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasTargetRadio()) {
                this.mIdentifiers.add(this.getTargetRadio());
            }
        }
        return this.mIdentifiers;
    }
}

