/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Preamble;
import java.util.ArrayList;
import java.util.List;

public class HyteraXPTPreamble
extends Preamble {
    private static final int[] FREE_REPEATER = new int[]{32, 33, 34, 35};
    private static final int[] PRIORITY_REPEATER = new int[]{36, 37, 38, 39};
    private static final int[] TARGET_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] PRIORITY_CALL_HASHED_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SOURCE_ADDRESS = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private IntegerIdentifier mTargetAddress;
    private RadioIdentifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public HyteraXPTPreamble(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        sb.append(" CSBK PREAMBLE FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(this.isCSBKPreamble() ? " CSBK" : " DATA");
        sb.append(" BLOCKS TO FOLLOW:").append(this.getBlocksToFollow());
        if (this.isAllChannelsBusy()) {
            sb.append(" ALL REPEATERS BUSY");
        } else {
            sb.append(" FREE REPEATER:").append(this.getFreeRepeater());
        }
        if (this.hasPriorityCall()) {
            sb.append(" PRIORITY CALL FOR:").append(this.getPriorityCallHashedAddress());
            sb.append(" ON REPEATER:").append(this.getPriorityCallRepeater());
        }
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public boolean isAllChannelsBusy() {
        return this.getFreeRepeater() == 0;
    }

    public int getFreeRepeater() {
        return this.getMessage().getInt(FREE_REPEATER);
    }

    public boolean hasPriorityCall() {
        return this.getPriorityCallRepeater() > 0;
    }

    public int getPriorityCallRepeater() {
        return this.getMessage().getInt(PRIORITY_REPEATER);
    }

    public String getPriorityCallHashedAddress() {
        return String.format("%02X", this.getMessage().getInt(PRIORITY_CALL_HASHED_ADDRESS)).toUpperCase();
    }

    @Override
    public IntegerIdentifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = this.isTalkgroupTargetAddress() ? DMRTalkgroup.create(this.getMessage().getInt(TARGET_ADDRESS)) : DmrTier3Radio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public RadioIdentifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = DmrTier3Radio.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceAddress());
        }
        return this.mIdentifiers;
    }
}

