/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.identifier.DmrTier3Radio;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.type.AcknowledgeType;
import io.github.dsheirer.module.decode.dmr.message.type.Reason;
import java.util.ArrayList;
import java.util.List;

public class Hytera68Acknowledge
extends CSBKMessage {
    private static final int TARGET_GROUP_INDIVIDUAL_FLAG = 16;
    protected static final int[] RESPONSE_INFO = new int[]{16, 17, 18, 19, 20, 21, 22};
    private static final int[] ACKNOWLEDGE_TYPE = new int[]{23, 24};
    private static final int[] REASON_CODE = new int[]{23, 24, 25, 26, 27, 28, 29, 30};
    private static final int RESERVED = 31;
    private static final int[] TARGET_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] ADDITIONAL_INFO_SOURCE_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    protected List<Identifier> mIdentifiers;
    private IntegerIdentifier mTargetAddress;
    private RadioIdentifier mSourceRadio;

    public Hytera68Acknowledge(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC-ERROR] ");
        }
        sb.append("CC:").append(this.getSlotType().getColorCode());
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" HYTERA 68 ").append((Object)this.getAcknowledgeType());
        sb.append(" REASON:");
        if (this.getReason() == Reason.UNKNOWN) {
            sb.append("UNKNOWN REASON CODE:").append(this.getMessage().getInt(REASON_CODE));
        } else {
            sb.append((Object)this.getReason());
        }
        sb.append(" FM:").append(this.getSourceRadio());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public boolean isTargetAddressTalkgroup() {
        return this.getMessage().get(16);
    }

    public AcknowledgeType getAcknowledgeType() {
        return AcknowledgeType.fromValue(this.getMessage().getInt(ACKNOWLEDGE_TYPE));
    }

    public Reason getReason() {
        return Hytera68Acknowledge.getReason(this.getMessage());
    }

    public static Reason getReason(CorrectedBinaryMessage message) {
        return Reason.fromValue(message.getInt(REASON_CODE));
    }

    public IntegerIdentifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = this.isTargetAddressTalkgroup() ? DMRTalkgroup.create(this.getMessage().getInt(TARGET_ADDRESS)) : DmrTier3Radio.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public boolean hasSourceRadio() {
        return true;
    }

    public RadioIdentifier getSourceRadio() {
        if (this.mSourceRadio == null) {
            this.mSourceRadio = DmrTier3Radio.createFrom(this.getMessage().getInt(ADDITIONAL_INFO_SOURCE_ADDRESS));
        }
        return this.mSourceRadio;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            if (this.hasSourceRadio()) {
                this.mIdentifiers.add(this.getSourceRadio());
            }
        }
        return this.mIdentifiers;
    }
}

