/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data.block;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.DataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import java.util.Collections;
import java.util.List;

public abstract class DataBlock
extends DataMessage {
    private static final int[] DATA_BLOCK_SERIAL_NUMBER = new int[]{0, 1, 2, 3, 4, 5, 6};

    public DataBlock(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, SlotType slotType, long timestamp, int timeslot) {
        super(syncPattern, message, cach, slotType, timestamp, timeslot);
    }

    public abstract CorrectedBinaryMessage getConfirmedPayload();

    public abstract CorrectedBinaryMessage getUnConfirmedPayload();

    public int getDataBlockSerialNumber() {
        return this.getMessage().getInt(DATA_BLOCK_SERIAL_NUMBER);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasRAS()) {
            sb.append(" RAS:").append(this.getBPTCReservedBits());
        }
        sb.append(" ").append(this.getSlotType());
        sb.append(" ").append(this.getMessage().toHexString());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

