/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.data;

import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.BPTC_196_96;
import io.github.dsheirer.edac.CRCDMR;
import io.github.dsheirer.edac.trellis.ViterbiDecoder_3_4_DMR;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.data.DataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.IDLEMessage;
import io.github.dsheirer.module.decode.dmr.message.data.SlotType;
import io.github.dsheirer.module.decode.dmr.message.data.UnknownDataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock1Rate;
import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock1_2Rate;
import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock3_4Rate;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessageFactory;
import io.github.dsheirer.module.decode.dmr.message.data.header.ConfirmedDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.DataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.DefinedShortDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.MBCHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.PiHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.RawShortDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.ResponseDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.ShortDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.StatusDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.UDTHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.UnconfirmedDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.VoiceHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.hytera.HyteraDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.motorola.MNISProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.motorola.MotorolaDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.data.terminator.Terminator;
import io.github.dsheirer.module.decode.dmr.message.data.usb.USBData;
import io.github.dsheirer.module.decode.dmr.message.type.DataPacketFormat;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceAccessPoint;
import io.github.dsheirer.module.decode.dmr.message.type.Vendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRDataMessageFactory {
    private static final Logger mLog = LoggerFactory.getLogger(DMRDataMessageFactory.class);
    private static final ViterbiDecoder_3_4_DMR VITERBI_DECODER = new ViterbiDecoder_3_4_DMR();

    public static DataMessage create(DMRSyncPattern pattern, CorrectedBinaryMessage message, CACH cach, long timestamp, int timeslot) {
        SlotType slotType = SlotType.getSlotType(message);
        if (slotType.isValid()) {
            switch (slotType.getDataType()) {
                case SLOT_IDLE: {
                    return new IDLEMessage(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case CSBK: {
                    return CSBKMessageFactory.create(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case USB_DATA: {
                    CorrectedBinaryMessage usbdPayload = DMRDataMessageFactory.getPayload(message);
                    switch (USBData.getServiceType(usbdPayload)) {
                        default: 
                    }
                    return new USBData(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case MBC_ENC_HEADER: 
                case MBC_HEADER: {
                    return new MBCHeader(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case CHANNEL_CONTROL_ENC_HEADER: 
                case PI_HEADER: {
                    return new PiHeader(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case VOICE_HEADER: {
                    return new VoiceHeader(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case DATA_ENC_HEADER: 
                case DATA_HEADER: {
                    CorrectedBinaryMessage payload = DMRDataMessageFactory.getPayload(message);
                    int crcBitCount = CRCDMR.correctCCITT80(payload, 0, 80, 52428);
                    boolean valid = crcBitCount < 2;
                    DataPacketFormat dpf = DataHeader.getDataPacketFormat(payload);
                    switch (dpf) {
                        case CONFIRMED_DATA_PACKET: {
                            ConfirmedDataHeader cdh = new ConfirmedDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                            cdh.setValid(valid);
                            return cdh;
                        }
                        case PROPRIETARY_DATA_PACKET: {
                            Vendor vendor = ProprietaryDataHeader.getVendor(payload);
                            switch (vendor) {
                                case MOTOROLA_CAPACITY_PLUS: 
                                case MOTOROLA_CONNECT_PLUS: {
                                    ServiceAccessPoint sap = ProprietaryDataHeader.getServiceAccessPoint(payload);
                                    if (sap == ServiceAccessPoint.SAP_1) {
                                        MNISProprietaryDataHeader mpdh = new MNISProprietaryDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                                        mpdh.setValid(valid);
                                        return mpdh;
                                    }
                                    MotorolaDataEncryptionHeader mprdh = new MotorolaDataEncryptionHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                                    mprdh.setValid(valid);
                                    return mprdh;
                                }
                                case HYTERA_68: {
                                    HyteraDataEncryptionHeader hsdh = new HyteraDataEncryptionHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                                    hsdh.setValid(valid);
                                    return hsdh;
                                }
                            }
                            ProprietaryDataHeader pdh = new ProprietaryDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                            pdh.setValid(valid);
                            return pdh;
                        }
                        case RAW_OR_STATUS_SHORT_DATA: {
                            int appendedBlockCount = ShortDataHeader.getAppendedBlocks(payload);
                            if (appendedBlockCount == 0) {
                                StatusDataHeader sdh = new StatusDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                                sdh.setValid(valid);
                                return sdh;
                            }
                            RawShortDataHeader rsdh = new RawShortDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                            rsdh.setValid(valid);
                            return rsdh;
                        }
                        case RESPONSE_PACKET: {
                            ResponseDataHeader rdh = new ResponseDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                            rdh.setValid(valid);
                            return rdh;
                        }
                        case DEFINED_SHORT_DATA: {
                            DefinedShortDataHeader dsdh = new DefinedShortDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                            dsdh.setValid(valid);
                            return dsdh;
                        }
                        case UNCONFIRMED_DATA_PACKET: {
                            UnconfirmedDataHeader udh = new UnconfirmedDataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                            udh.setValid(valid);
                            return udh;
                        }
                        case UNIFIED_DATA_TRANSPORT: {
                            UDTHeader uh = new UDTHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                            uh.setValid(valid);
                            return uh;
                        }
                    }
                    DataHeader dh = new DataHeader(pattern, payload, cach, slotType, timestamp, timeslot);
                    dh.setValid(valid);
                    return dh;
                }
                case TLC: {
                    return new Terminator(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case RATE_1_OF_2_DATA: {
                    return new DataBlock1_2Rate(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case RATE_3_OF_4_DATA: {
                    return new DataBlock3_4Rate(pattern, DMRDataMessageFactory.getTrellisPayload(message), cach, slotType, timestamp, timeslot);
                }
                case RATE_1_DATA: {
                    return new DataBlock1Rate(pattern, message, cach, slotType, timestamp, timeslot);
                }
                case MBC_BLOCK: {
                    return new MBCContinuationBlock(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
                case RESERVED_15: 
                case UNKNOWN: {
                    return new UnknownDataMessage(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
                }
            }
        }
        return new UnknownDataMessage(pattern, DMRDataMessageFactory.getPayload(message), cach, slotType, timestamp, timeslot);
    }

    private static CorrectedBinaryMessage getTrellisPayload(CorrectedBinaryMessage message) {
        CorrectedBinaryMessage descrambled = DMRDataMessageFactory.extract(message);
        return VITERBI_DECODER.decode(descrambled);
    }

    private static CorrectedBinaryMessage getPayload(CorrectedBinaryMessage message) {
        CorrectedBinaryMessage descrambled = DMRDataMessageFactory.extract(message);
        return BPTC_196_96.extract(descrambled);
    }

    private static CorrectedBinaryMessage extract(CorrectedBinaryMessage message) {
        CorrectedBinaryMessage extracted = new CorrectedBinaryMessage(196);
        try {
            int i;
            for (i = 24; i < 122; ++i) {
                extracted.add(message.get(i));
            }
            for (i = 190; i < 288; ++i) {
                extracted.add(message.get(i));
            }
        }
        catch (BitSetFullException ex) {
            mLog.error("Error extracting DMR burst payload bits");
        }
        return extracted;
    }
}

