/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.channel;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.protocol.Protocol;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public abstract class DMRChannel
extends IntegerIdentifier
implements IChannelDescriptor,
ITimeslotFrequencyReceiver {
    private TimeslotFrequency mTimeslotFrequency;
    private int mTimeslot;

    public DMRChannel(int channel, int timeslot) {
        super(channel, IdentifierClass.NETWORK, Form.CHANNEL, Role.BROADCAST);
        Validate.inclusiveBetween((long)0L, (long)2L, (long)timeslot, (String)"Timeslot must be between 1 and 2");
        this.mTimeslot = timeslot;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.DMR;
    }

    public int getChannelNumber() {
        return (Integer)this.getValue();
    }

    @Override
    public int[] getLogicalChannelNumbers() {
        return new int[]{this.getChannelNumber()};
    }

    public int getTimeslot() {
        return this.mTimeslot;
    }

    @Override
    public int getTimeslotCount() {
        return 2;
    }

    @Override
    public boolean isTDMAChannel() {
        return true;
    }

    @Override
    public String toString() {
        return "CHAN:" + this.getChannelNumber() + ":" + this.getTimeslot();
    }

    @Override
    public int[] getFrequencyBandIdentifiers() {
        return new int[0];
    }

    @Override
    public void setFrequencyBand(IFrequencyBand bandIdentifier) {
        throw new IllegalArgumentException("This method is not supported");
    }

    @Override
    public long getDownlinkFrequency() {
        if (this.mTimeslotFrequency != null) {
            return this.mTimeslotFrequency.getDownlinkFrequency();
        }
        return 0L;
    }

    @Override
    public long getUplinkFrequency() {
        if (this.mTimeslotFrequency != null) {
            return this.mTimeslotFrequency.getUplinkFrequency();
        }
        return 0L;
    }

    public void setTimeslotFrequency(TimeslotFrequency timeslotFrequency) {
        this.mTimeslotFrequency = timeslotFrequency;
    }

    @Override
    public void apply(List<TimeslotFrequency> timeslotFrequencies) {
        for (TimeslotFrequency timeslotFrequency : timeslotFrequencies) {
            if (timeslotFrequency.getChannelNumber() != this.getChannelNumber()) continue;
            this.setTimeslotFrequency(timeslotFrequency);
            return;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DMRChannel)) {
            return false;
        }
        DMRChannel that = (DMRChannel)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.getTimeslot() == that.getTimeslot();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTimeslot());
    }
}

