/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.channel;

import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;

public class DMRAbsoluteChannel
extends DMRChannel {
    private long mDownlinkFrequency;
    private long mUplinkFrequency;

    public DMRAbsoluteChannel(int lcn, int timeslot, long downlinkFrequency, long uplinkFrequency) {
        super(lcn, timeslot);
        this.mDownlinkFrequency = downlinkFrequency;
        this.mUplinkFrequency = uplinkFrequency;
    }

    @Override
    public long getDownlinkFrequency() {
        return this.mDownlinkFrequency;
    }

    @Override
    public long getUplinkFrequency() {
        return this.mUplinkFrequency;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getValue());
        sb.append(" TS:").append(this.getTimeslot());
        sb.append(" ").append((double)this.getDownlinkFrequency() / 1000000.0);
        return sb.toString();
    }
}

