/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeslotAlignmentTracker {
    private static final Logger mLog = LoggerFactory.getLogger(TimeslotAlignmentTracker.class);
    private int mBurst1Ts1 = 0;
    private int mBurst1Ts2 = 0;
    private int mBurst2Ts1 = 0;
    private int mBurst2Ts2 = 0;

    public boolean hasSufficientData() {
        return this.mBurst1Ts1 > this.mBurst1Ts2 && this.mBurst2Ts2 > this.mBurst2Ts1 || this.mBurst1Ts1 < this.mBurst1Ts2 && this.mBurst2Ts2 < this.mBurst2Ts1 || this.mBurst1Ts1 == 0 && this.mBurst1Ts2 == 0 && this.mBurst2Ts1 != this.mBurst2Ts2 || this.mBurst1Ts1 != this.mBurst1Ts2 && this.mBurst2Ts1 == 0 && this.mBurst1Ts2 == 0;
    }

    public boolean isAligned() {
        return this.mBurst1Ts1 > this.mBurst1Ts2 && this.mBurst2Ts2 > this.mBurst2Ts1 || this.mBurst1Ts1 == 0 && this.mBurst1Ts2 == 0 && this.mBurst2Ts2 > this.mBurst2Ts1 || this.mBurst1Ts1 > this.mBurst1Ts2 && this.mBurst2Ts1 == 0 && this.mBurst2Ts2 == 0;
    }

    public void update(CACH cach1, CACH cach2, DMRSyncPattern pattern1, DMRSyncPattern pattern2) {
        if (cach1 != null && cach1.isValid()) {
            if (cach1.isTimeslot0()) {
                ++this.mBurst1Ts1;
            } else {
                ++this.mBurst1Ts2;
            }
        }
        if (cach2 != null && cach2.isValid()) {
            if (cach2.isTimeslot0()) {
                ++this.mBurst2Ts1;
            } else {
                ++this.mBurst2Ts2;
            }
        }
        if (pattern1.isDirectMode()) {
            switch (pattern1) {
                case DIRECT_MODE_DATA_TIMESLOT_1: 
                case DIRECT_MODE_VOICE_TIMESLOT_1: {
                    ++this.mBurst1Ts1;
                    break;
                }
                case DIRECT_MODE_DATA_TIMESLOT_2: 
                case DIRECT_MODE_VOICE_TIMESLOT_2: {
                    ++this.mBurst1Ts2;
                }
            }
        }
        if (pattern2.isDirectMode()) {
            switch (pattern2) {
                case DIRECT_MODE_DATA_TIMESLOT_1: 
                case DIRECT_MODE_VOICE_TIMESLOT_1: {
                    ++this.mBurst2Ts1;
                    break;
                }
                case DIRECT_MODE_DATA_TIMESLOT_2: 
                case DIRECT_MODE_VOICE_TIMESLOT_2: {
                    ++this.mBurst2Ts2;
                }
            }
        }
    }

    public void reset() {
        this.mBurst1Ts1 = 0;
        this.mBurst1Ts2 = 0;
        this.mBurst2Ts1 = 0;
        this.mBurst2Ts2 = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BURST 1: ").append(this.mBurst1Ts1).append("/").append(this.mBurst1Ts2);
        sb.append(" BURST 2:").append(this.mBurst2Ts1).append("/").append(this.mBurst2Ts2);
        if (this.hasSufficientData()) {
            if (this.isAligned()) {
                sb.append(" **ALIGNED**");
            } else {
                sb.append(" >>MIS-ALIGNED<<");
            }
        }
        return sb.toString();
    }
}

