/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.edac.CRCDMR;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmrCrcMaskManager {
    private Logger LOGGER = LoggerFactory.getLogger(DmrCrcMaskManager.class);
    private Map<Integer, ResidualCrcMaskTracker> mCsbkResidualTrackerMap = new TreeMap<Integer, ResidualCrcMaskTracker>();
    private int mDominantMask = 0;

    public List<ResidualCrcMaskTracker> cloneTrackers() {
        ArrayList<ResidualCrcMaskTracker> trackers = new ArrayList<ResidualCrcMaskTracker>();
        for (ResidualCrcMaskTracker tracker : this.mCsbkResidualTrackerMap.values()) {
            trackers.add(tracker.clone());
        }
        return trackers;
    }

    public void log() {
        ArrayList<ResidualCrcMaskTracker> trackers = new ArrayList<ResidualCrcMaskTracker>(this.mCsbkResidualTrackerMap.values());
        Collections.sort(trackers);
        StringBuilder sb = new StringBuilder();
        sb.append("DMR CRC Mask Manager - Current Tracked Values\n");
        for (ResidualCrcMaskTracker tracker : trackers) {
            sb.append("\tTracked Value: ").append(String.format("0x%04X", tracker.getTrackedValue()));
            sb.append(" Count:").append(tracker.getCount());
            sb.append(" Last Observed: " + String.valueOf(new Date(tracker.getLastUpdated()))).append("\n");
        }
        this.LOGGER.info(sb.toString());
    }

    public void check(CSBKMessage csbk) {
        if (!csbk.isValid()) {
            ResidualCrcMaskTracker dominant;
            int residual = CRCDMR.calculateResidual(csbk.getMessage(), 0, 80);
            if (this.mCsbkResidualTrackerMap.containsKey(residual)) {
                this.mCsbkResidualTrackerMap.get(residual).increment();
            } else {
                this.mCsbkResidualTrackerMap.put(residual, new ResidualCrcMaskTracker(residual));
            }
            ArrayList<ResidualCrcMaskTracker> trackers = new ArrayList<ResidualCrcMaskTracker>(this.mCsbkResidualTrackerMap.values());
            Collections.sort(trackers);
            if (trackers.size() > 5) {
                this.mCsbkResidualTrackerMap.remove(((ResidualCrcMaskTracker)trackers.get(0)).getTrackedValue());
            }
            if (trackers.size() > 0 && (dominant = (ResidualCrcMaskTracker)trackers.get(trackers.size() - 1)).isValid()) {
                this.mDominantMask = dominant.getTrackedValue();
            }
            if (this.mDominantMask != 0) {
                csbk.checkCRC(this.mDominantMask);
            }
        }
    }

    public class ResidualCrcMaskTracker
    implements Comparable<ResidualCrcMaskTracker> {
        private int mTrackedValue;
        private int mCount;
        private long mLastUpdated;

        public ResidualCrcMaskTracker(int residual) {
            this.mTrackedValue = residual;
            this.mCount = 1;
            this.mLastUpdated = System.currentTimeMillis();
        }

        public ResidualCrcMaskTracker clone() {
            ResidualCrcMaskTracker clone = new ResidualCrcMaskTracker(this.getTrackedValue());
            clone.mCount = this.mCount;
            clone.mLastUpdated = this.mLastUpdated;
            return clone;
        }

        public int getCount() {
            return this.mCount;
        }

        public boolean isValid() {
            return this.mCount >= 3;
        }

        public long getLastUpdated() {
            return this.mLastUpdated;
        }

        public int getTrackedValue() {
            return this.mTrackedValue;
        }

        public void increment() {
            ++this.mCount;
            if (this.mCount < 0) {
                this.mCount = Integer.MAX_VALUE;
            }
            this.mLastUpdated = System.currentTimeMillis();
        }

        @Override
        public int compareTo(ResidualCrcMaskTracker o) {
            int comparison = Integer.compare(this.getCount(), o.getCount());
            if (comparison == 0) {
                comparison = Long.compare(this.getLastUpdated(), o.getLastUpdated());
            }
            return comparison;
        }
    }
}

