/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.gain.complex.ComplexGainFactory;
import io.github.dsheirer.dsp.gain.complex.IComplexGainControl;
import io.github.dsheirer.dsp.psk.DQPSKDecisionDirectedDemodulator;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.pll.CostasLoop;
import io.github.dsheirer.dsp.psk.pll.FrequencyCorrectionSyncMonitor;
import io.github.dsheirer.dsp.psk.pll.PLLBandwidth;
import io.github.dsheirer.dsp.squelch.PowerMonitor;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.DibitToByteBufferAssembler;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.FeedbackDecoder;
import io.github.dsheirer.module.decode.dmr.DMRMessageFramer;
import io.github.dsheirer.module.decode.dmr.DMRMessageProcessor;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.buffer.IByteBufferProvider;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.IComplexSamplesListener;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.ISourceEventProvider;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.wave.ComplexWaveSource;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRDecoder
extends FeedbackDecoder
implements ISourceEventListener,
ISourceEventProvider,
IComplexSamplesListener,
Listener<ComplexSamples>,
IByteBufferProvider {
    private static final Logger mLog = LoggerFactory.getLogger(DMRDecoder.class);
    protected static final float SAMPLE_COUNTER_GAIN = 0.4f;
    private static final double SYMBOL_RATE = 4800.0;
    private double mSampleRate;
    private Broadcaster<Dibit> mDibitBroadcaster = new Broadcaster();
    private DibitToByteBufferAssembler mByteBufferAssembler = new DibitToByteBufferAssembler(300);
    private DMRMessageProcessor mMessageProcessor;
    protected IComplexGainControl mAGC = ComplexGainFactory.getComplexGainControl();
    private Map<Double, float[]> mBasebandFilters = new HashMap<Double, float[]>();
    protected IRealFilter mIBasebandFilter;
    protected IRealFilter mQBasebandFilter;
    protected InterpolatingSampleBuffer mInterpolatingSampleBuffer;
    protected DQPSKDecisionDirectedDemodulator mQPSKDemodulator;
    protected CostasLoop mCostasLoop;
    protected FrequencyCorrectionSyncMonitor mFrequencyCorrectionSyncMonitor;
    protected DMRMessageFramer mMessageFramer;
    protected PowerMonitor mPowerMonitor = new PowerMonitor();

    public DMRDecoder(DecodeConfigDMR config) {
        this.mMessageProcessor = new DMRMessageProcessor(config);
        this.mMessageProcessor.setMessageListener(this.getMessageListener());
        this.getDibitBroadcaster().addListener(this.mByteBufferAssembler);
        this.setSampleRate(25000.0);
    }

    @Override
    public void start() {
        super.start();
        this.mQPSKDemodulator.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.mQPSKDemodulator.stop();
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.DMR;
    }

    protected DMRMessageProcessor getMessageProcessor() {
        return this.mMessageProcessor;
    }

    public void setSampleRate(double sampleRate) {
        if (sampleRate <= this.getSymbolRate() * 2.0) {
            throw new IllegalArgumentException("Sample rate [" + sampleRate + "] must be >9600 (2 * " + this.getSymbolRate() + " symbol rate)");
        }
        this.mPowerMonitor.setSampleRate((int)sampleRate);
        this.mSampleRate = sampleRate;
        this.mIBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mQBasebandFilter = FilterFactory.getRealFilter(this.getBasebandFilter());
        this.mCostasLoop = new CostasLoop(this.getSampleRate(), this.getSymbolRate());
        this.mCostasLoop.setPLLBandwidth(PLLBandwidth.BW_300);
        this.mFrequencyCorrectionSyncMonitor = new FrequencyCorrectionSyncMonitor(this.mCostasLoop, this);
        this.mInterpolatingSampleBuffer = new InterpolatingSampleBuffer(this.getSamplesPerSymbol(), 0.4f);
        this.mQPSKDemodulator = new DQPSKDecisionDirectedDemodulator(this.mCostasLoop, this.mInterpolatingSampleBuffer);
        if (this.mMessageFramer != null) {
            this.getDibitBroadcaster().removeListener(this.mMessageFramer);
        }
        this.mMessageFramer = new DMRMessageFramer(this.mCostasLoop);
        this.mMessageFramer.setSyncDetectListener(this.mFrequencyCorrectionSyncMonitor);
        this.mMessageFramer.setListener(this.getMessageProcessor());
        this.mQPSKDemodulator.setSymbolListener(this.getDibitBroadcaster());
        this.getDibitBroadcaster().addListener(this.mMessageFramer);
    }

    @Override
    public void receive(ComplexSamples samples) {
        this.mMessageFramer.setCurrentTime(samples.timestamp());
        float[] i = this.mIBasebandFilter.filter(samples.i());
        float[] q = this.mQBasebandFilter.filter(samples.q());
        this.mPowerMonitor.process(i, q);
        ComplexSamples amplified = this.mAGC.process(i, q, samples.timestamp());
        this.mQPSKDemodulator.receive(amplified);
    }

    private float[] getBasebandFilter() {
        float[] filter = this.mBasebandFilters.get(this.getSampleRate());
        if (filter == null) {
            FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate((int)this.getSampleRate()).passBandCutoff(5100.0).passBandAmplitude(1.0).passBandRipple(0.01).stopBandAmplitude(0.0).stopBandStart(6500.0).stopBandRipple(0.01).build();
            try {
                filter = FilterFactory.getTaps(specification);
            }
            catch (Exception fde) {
                mLog.error("Couldn't design low pass baseband filter for sample rate: " + this.getSampleRate());
            }
            if (filter != null) {
                this.mBasebandFilters.put(this.getSampleRate(), filter);
            } else {
                throw new IllegalStateException("Couldn't design a DMR baseband filter for sample rate: " + this.getSampleRate());
            }
        }
        return filter;
    }

    protected void process(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.mCostasLoop.reset();
                this.setSampleRate(sourceEvent.getValue().doubleValue());
                break;
            }
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: {
                this.mCostasLoop.reset();
            }
        }
    }

    @Override
    public void reset() {
        this.mCostasLoop.reset();
        this.mFrequencyCorrectionSyncMonitor.reset();
    }

    protected Broadcaster<Dibit> getDibitBroadcaster() {
        return this.mDibitBroadcaster;
    }

    @Override
    public void setBufferListener(Listener<ByteBuffer> listener) {
        this.mByteBufferAssembler.setBufferListener(listener);
    }

    @Override
    public void removeBufferListener(Listener<ByteBuffer> listener) {
        this.mByteBufferAssembler.removeBufferListener(listener);
    }

    @Override
    public boolean hasBufferListeners() {
        return this.mByteBufferAssembler.hasBufferListeners();
    }

    protected double getSymbolRate() {
        return 4800.0;
    }

    protected double getSampleRate() {
        return this.mSampleRate;
    }

    public float getSamplesPerSymbol() {
        return (float)(this.getSampleRate() / this.getSymbolRate());
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        super.setSourceEventListener(listener);
        this.mPowerMonitor.setSourceEventListener(listener);
    }

    @Override
    public void removeSourceEventListener() {
        super.removeSourceEventListener();
        this.mPowerMonitor.setSourceEventListener(null);
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return sourceEvent -> this.process((SourceEvent)sourceEvent);
    }

    @Override
    public Listener<ComplexSamples> getComplexSamplesListener() {
        return this;
    }

    public static void main(String[] args) {
        File file = new File("/home/denny/Downloads/TIII,HYT414.585000,.wav");
        try {
            ComplexWaveSource source = new ComplexWaveSource(file);
            source.open();
            System.out.println("Source Sample Rate: " + source.getSampleRate());
            DMRDecoder decoder = new DMRDecoder(new DecodeConfigDMR());
            decoder.setMessageListener(message -> System.out.println("TS:" + message.getTimeslot() + " " + String.valueOf(message)));
            source.setListener(iNativeBuffer -> {
                Iterator<ComplexSamples> it = iNativeBuffer.iterator();
                while (it.hasNext()) {
                    ComplexSamples samples = it.next();
                    decoder.receive(samples);
                }
            });
            decoder.setSampleRate(source.getSampleRate());
            decoder.start();
            source.start();
            while (true) {
                source.next(65535);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

