/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dcs;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.fir.remez.RemezFIRFilterDesigner;
import io.github.dsheirer.module.decode.Decoder;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.dcs.DCSCode;
import io.github.dsheirer.module.decode.dcs.DCSMessage;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.real.IRealBufferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCSDecoder
extends Decoder
implements IRealBufferListener,
Listener<float[]> {
    private static final Logger mLog = LoggerFactory.getLogger(DCSDecoder.class);
    private static final double SLOPE_CALCULATION_SUM_XX = 2247.5;
    private static final float BAUD_LENGTH = 59.52381f;
    private static final float SLOPE_THRESHOLD = 0.00275f;
    private static final int MAX_ONES_SEQUENCE = 6;
    private static final int OVERLAP = (int)Math.ceil(59.52381134033203);
    private static final int POST_TRANSITION_SAMPLES_TO_SKIP = 30;
    private static final int SLOPE_CALCULATION_PERIOD = 30;
    private static final int IDEAL_SYMBOL_TRANSITION_MIN = 11;
    private static final int IDEAL_SYMBOL_TRANSITION_MAX = 19;
    private static final int CODE_MASK = 0x7FFFFF;
    private static float[] sLowPassFilterCoefficients;
    private boolean mSymbol = false;
    private float mBaudCounter = 0.0f;
    private float mMaxSlope = 0.0f;
    private float[] mResidual = new float[OVERLAP];
    private int mCode = 0;
    private int mExcessiveOneSequenceCounter = 0;
    private IRealFilter mLowPassFilter = FilterFactory.getRealFilter(sLowPassFilterCoefficients);

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.DCS;
    }

    @Override
    public Listener<float[]> getBufferListener() {
        return this::receive;
    }

    @Override
    public void receive(float[] samples) {
        if (this.getMessageListener() != null) {
            float[] filtered = this.mLowPassFilter.filter(samples);
            float[] buffer = new float[filtered.length + OVERLAP];
            int samplesToSkip = 0;
            int timingAdjust = 0;
            float slope = 0.0f;
            try {
                System.arraycopy(this.mResidual, 0, buffer, 0, this.mResidual.length);
                System.arraycopy(filtered, 0, buffer, this.mResidual.length, filtered.length);
                System.arraycopy(filtered, filtered.length - OVERLAP, this.mResidual, 0, OVERLAP);
                for (int bufferPointer = 0; bufferPointer < samples.length; ++bufferPointer) {
                    if (samplesToSkip > 0) {
                        --samplesToSkip;
                    } else {
                        slope = this.calculateSlope(buffer, bufferPointer);
                        if (this.mSymbol) {
                            if (slope > this.mMaxSlope && this.mMaxSlope < -0.00275f) {
                                this.mSymbol = false;
                                timingAdjust = this.mBaudCounter < 11.0f ? 1 : (this.mBaudCounter > 19.0f ? -1 : 0);
                                this.mBaudCounter += (float)timingAdjust;
                                samplesToSkip = 30 + timingAdjust;
                            } else if (slope < this.mMaxSlope) {
                                this.mMaxSlope = slope;
                            }
                        } else if (slope < this.mMaxSlope && this.mMaxSlope > 0.00275f) {
                            this.mSymbol = true;
                            timingAdjust = this.mBaudCounter < 11.0f ? 1 : (this.mBaudCounter > 19.0f ? -1 : 0);
                            this.mBaudCounter += (float)timingAdjust;
                            samplesToSkip = 30 + timingAdjust;
                        } else if (slope > this.mMaxSlope) {
                            this.mMaxSlope = slope;
                        }
                    }
                    this.mBaudCounter += 1.0f;
                    if (!(this.mBaudCounter > 59.52381f)) continue;
                    this.mCode = Integer.rotateLeft(this.mCode, 1) + (this.mSymbol ? 1 : 0) & 0x7FFFFF;
                    if (DCSCode.hasValue(this.mCode)) {
                        this.getMessageListener().receive(new DCSMessage(DCSCode.fromValue(this.mCode), System.currentTimeMillis()));
                    }
                    this.mBaudCounter -= 59.52381f;
                    if (this.mSymbol) {
                        ++this.mExcessiveOneSequenceCounter;
                        if (this.mExcessiveOneSequenceCounter <= 6) continue;
                        this.mSymbol = false;
                        this.mMaxSlope = -1.0f;
                        this.mExcessiveOneSequenceCounter = 0;
                        continue;
                    }
                    this.mExcessiveOneSequenceCounter = 0;
                }
            }
            catch (Exception e) {
                mLog.warn("Unexpected error while processing DCS samples", (Throwable)e);
            }
        }
    }

    public float calculateSlope(float[] samples, int offset) {
        double xbar = 0.0;
        double ybar = samples[offset];
        double sumXY = 0.0;
        for (int x = 1; x < 30; ++x) {
            double fact1 = 1.0 + (double)x;
            double dx = (double)x - xbar;
            double dy = (double)samples[offset + x] - ybar;
            sumXY += dx * dy * ((double)x / (1.0 + (double)x));
            xbar += dx / fact1;
            ybar += dy / fact1;
        }
        return (float)(sumXY / 2247.5);
    }

    static {
        FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate(8000.0).gridDensity(16).oddLength(true).passBandCutoff(200.0).passBandAmplitude(1.0).passBandRipple(0.01).stopBandStart(300.0).stopBandAmplitude(0.0).stopBandRipple(0.03).build();
        try {
            RemezFIRFilterDesigner designer = new RemezFIRFilterDesigner(specification);
            if (designer.isValid()) {
                sLowPassFilterCoefficients = designer.getImpulseResponse();
            }
        }
        catch (FilterDesignException fde) {
            mLog.error("Filter design error", (Throwable)fde);
        }
    }
}

