/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.analog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.dsp.squelch.ISquelchConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import java.util.EnumSet;

public abstract class DecodeConfigAnalog
extends DecodeConfiguration
implements ISquelchConfiguration {
    private Bandwidth mBandwidth = this.getDefaultBandwidth();
    private int mTalkgroup = 1;
    private int mSquelchThreshold = -78;
    private boolean mSquelchAutoTrack = true;

    protected abstract Bandwidth getDefaultBandwidth();

    @JacksonXmlProperty(isAttribute=true, localName="bandwidth")
    public Bandwidth getBandwidth() {
        return this.mBandwidth;
    }

    @Override
    @JsonIgnore
    public ChannelSpecification getChannelSpecification() {
        if (this.mBandwidth == Bandwidth.BW_12_5) {
            return new ChannelSpecification(25000.0, 12500, 6000.0, 7000.0);
        }
        return new ChannelSpecification(50000.0, 25000, 12500.0, 13500.0);
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.mBandwidth = bandwidth;
    }

    @JacksonXmlProperty(isAttribute=true, localName="talkgroup")
    public int getTalkgroup() {
        return this.mTalkgroup;
    }

    public void setTalkgroup(int talkgroup) {
        if (talkgroup < 1 || talkgroup > 65535) {
            throw new IllegalArgumentException("Valid talkgroup range is 1 - 65,535");
        }
        this.mTalkgroup = talkgroup;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="squelch")
    public void setSquelchThreshold(int threshold) {
        this.mSquelchThreshold = threshold;
    }

    @Override
    public int getSquelchThreshold() {
        return this.mSquelchThreshold;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="autoTrack")
    public void setSquelchAutoTrack(boolean autoTrack) {
        this.mSquelchAutoTrack = autoTrack;
    }

    @Override
    public boolean isSquelchAutoTrack() {
        return this.mSquelchAutoTrack;
    }

    public static enum Bandwidth {
        BW_3_0("3.0 kHz", 3000.0),
        BW_5_0("5.0 kHz", 5000.0),
        BW_7_5("7.5 kHz", 7500.0),
        BW_8_33("8.33 kHz", 8333.0),
        BW_12_5("12.5 kHz", 12500.0),
        BW_15_0("15.0 kHz", 15000.0),
        BW_25_0("25.0 kHz", 25000.0);

        private String mLabel;
        private double mValue;
        public static EnumSet<Bandwidth> AM_BANDWIDTHS;
        public static EnumSet<Bandwidth> FM_BANDWIDTHS;

        private Bandwidth(String label, double value) {
            this.mLabel = label;
            this.mValue = value;
        }

        public boolean isAM() {
            return AM_BANDWIDTHS.contains((Object)this);
        }

        public boolean isFM() {
            return FM_BANDWIDTHS.contains((Object)this);
        }

        public String toString() {
            return this.mLabel;
        }

        public double getValue() {
            return this.mValue;
        }

        static {
            AM_BANDWIDTHS = EnumSet.of(BW_3_0, BW_5_0, BW_8_33, BW_15_0, BW_25_0);
            FM_BANDWIDTHS = EnumSet.of(BW_7_5, BW_12_5, BW_25_0);
        }
    }
}

