/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.am;

import io.github.dsheirer.dsp.am.SquelchingAMDemodulator;
import io.github.dsheirer.dsp.gain.AudioGainAndDcFilter;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.am.DecodeConfigAM;
import io.github.dsheirer.module.decode.analog.SquelchingAnalogDecoder;

public class AMDecoder
extends SquelchingAnalogDecoder {
    private static final float DEMODULATOR_GAIN = 150.0f;
    private static final float SQUELCH_ALPHA_DECAY = 4.0E-4f;
    private static final float MINIMUM_GAIN = 0.5f;
    private static final float MAXIMUM_GAIN = 16.0f;
    private static final float OBJECTIVE_AUDIO_AMPLITUDE = 0.75f;
    private AudioGainAndDcFilter mAGC = new AudioGainAndDcFilter(0.5f, 16.0f, 0.75f);

    public AMDecoder(DecodeConfigAM config) {
        super(config, new SquelchingAMDemodulator(150.0f, 4.0E-4f, config.getSquelchThreshold(), config.isSquelchAutoTrack()));
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.AM;
    }

    @Override
    protected void broadcast(float[] demodulatedSamples) {
        super.broadcast(this.mAGC.process(demodulatedSamples));
    }

    @Override
    protected void notifyCallStart() {
        this.mAGC.reset();
        super.notifyCallStart();
    }
}

