/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode;

import io.github.dsheirer.protocol.Protocol;
import java.util.EnumSet;

public enum DecoderType {
    AM("AM", "AM", Protocol.UNKNOWN),
    DMR("DMR", "DMR", Protocol.DMR),
    LTR("LTR", "LTR", Protocol.LTR),
    LTR_NET("LTR-Net", "LTR-Net", Protocol.LTR_NET),
    MPT1327("MPT1327", "MPT1327", Protocol.MPT1327),
    NBFM("NBFM", "NBFM", Protocol.NBFM),
    PASSPORT("Passport", "Passport", Protocol.PASSPORT),
    P25_PHASE1("P25 Phase 1", "P25-1", Protocol.APCO25),
    P25_PHASE2("P25 Phase 2", "P25-2", Protocol.APCO25_PHASE2),
    DCS("Digital Coded Squelch (DCS)", "DCS", Protocol.DCS),
    FLEETSYNC2("Fleetsync II", "Fleetsync2", Protocol.FLEETSYNC),
    LJ_1200("LJ1200 173.075", "LJ1200", Protocol.LOJACK),
    MDC1200("MDC1200", "MDC1200", Protocol.MDC1200),
    TAIT_1200("Tait 1200", "Tait 1200", Protocol.TAIT1200);

    private String mDisplayString;
    private String mShortDisplayString;
    private Protocol mProtocol;
    public static EnumSet<DecoderType> PRIMARY_DECODERS;
    public static final EnumSet<DecoderType> AUX_DECODERS;
    public static final EnumSet<DecoderType> BITSTREAM_DECODERS;
    public static final EnumSet<DecoderType> MBE_AUDIO_CODEC_DECODERS;

    private DecoderType(String displayString, String shortDisplayString, Protocol protocol) {
        this.mDisplayString = displayString;
        this.mShortDisplayString = shortDisplayString;
        this.mProtocol = protocol;
    }

    public Protocol getProtocol() {
        return this.mProtocol;
    }

    public String getDisplayString() {
        return this.mDisplayString;
    }

    public String getShortDisplayString() {
        return this.mShortDisplayString;
    }

    public String toString() {
        return this.mDisplayString;
    }

    public boolean providesBitstream() {
        return BITSTREAM_DECODERS.contains((Object)this);
    }

    public boolean providesMBEAudioFrames() {
        return MBE_AUDIO_CODEC_DECODERS.contains((Object)this);
    }

    static {
        PRIMARY_DECODERS = EnumSet.of(AM, new DecoderType[]{DMR, LTR, LTR_NET, MPT1327, NBFM, P25_PHASE1, P25_PHASE2, PASSPORT});
        AUX_DECODERS = EnumSet.of(DCS, FLEETSYNC2, LJ_1200, MDC1200, TAIT_1200);
        BITSTREAM_DECODERS = EnumSet.of(DMR, MPT1327, P25_PHASE1, P25_PHASE2);
        MBE_AUDIO_CODEC_DECODERS = EnumSet.of(DMR, P25_PHASE1, P25_PHASE2);
    }
}

