/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module;

import io.github.dsheirer.module.Module;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.List;

public abstract class HistoryModule<T>
extends Module
implements Listener<T> {
    private List<T> mItems = new ArrayList<T>();
    private Broadcaster<T> mBroadcaster = new Broadcaster();
    private int mMaximumHistorySize;

    public HistoryModule(int maximumHistorySize) {
        this.mMaximumHistorySize = maximumHistorySize;
    }

    public List<T> getItems() {
        return new ArrayList<T>(this.mItems);
    }

    @Override
    public void reset() {
        this.mItems.clear();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.mItems.clear();
        this.mBroadcaster.clear();
    }

    public void addListener(Listener<T> listener) {
        this.mBroadcaster.addListener(listener);
    }

    public void removeListener(Listener<T> listener) {
        this.mBroadcaster.removeListener(listener);
    }

    @Override
    public void receive(T item) {
        while (this.mItems.size() > this.mMaximumHistorySize) {
            this.mItems.remove(0);
        }
        if (!this.mItems.contains(item)) {
            this.mItems.add(item);
        }
        this.mBroadcaster.broadcast(item);
    }
}

