/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier.ipv4;

import java.util.Objects;

public class IPV4Address {
    private int mIPAddress;

    public IPV4Address(int ipAddress) {
        this.mIPAddress = ipAddress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOctet(0));
        sb.append(".");
        sb.append(this.getOctet(1));
        sb.append(".");
        sb.append(this.getOctet(2));
        sb.append(".");
        sb.append(this.getOctet(3));
        return sb.toString();
    }

    private int getOctet(int index) {
        switch (index) {
            case 0: {
                return (this.mIPAddress & 0xFF000000) >> 24 & 0xFF;
            }
            case 1: {
                return (this.mIPAddress & 0xFF0000) >> 16;
            }
            case 2: {
                return (this.mIPAddress & 0xFF00) >> 8;
            }
            case 3: {
                return this.mIPAddress & 0xFF;
            }
        }
        throw new IllegalArgumentException("Invalid Octet index: " + index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPV4Address that = (IPV4Address)o;
        return this.mIPAddress == that.mIPAddress;
    }

    public int hashCode() {
        return Objects.hash(this.mIPAddress);
    }
}

