/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier.encryption;

import java.util.Objects;

public abstract class EncryptionKey
implements Comparable<EncryptionKey> {
    private int mAlgorithm;
    private int mKey;

    public EncryptionKey(int algorithm, int key) {
        this.mAlgorithm = algorithm;
        this.mKey = key;
    }

    public abstract boolean isEncrypted();

    public int getAlgorithm() {
        return this.mAlgorithm;
    }

    public int getKey() {
        return this.mKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALGORITHM:").append(this.getAlgorithm());
        sb.append(" KEY:").append(this.getKey());
        return sb.toString();
    }

    @Override
    public int compareTo(EncryptionKey other) {
        if (this.getAlgorithm() == other.getKey()) {
            return Integer.compare(this.getKey(), other.getKey());
        }
        return Integer.compare(this.getAlgorithm(), other.getAlgorithm());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionKey that = (EncryptionKey)o;
        return this.getAlgorithm() == that.getAlgorithm() && this.getKey() == that.getKey();
    }

    public int hashCode() {
        return Objects.hash(this.getAlgorithm(), this.getKey());
    }
}

