/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier.decoder;

import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.protocol.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelStateIdentifier
extends Identifier<State> {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelStateIdentifier.class);
    public static final ChannelStateIdentifier ACTIVE = new ChannelStateIdentifier(State.ACTIVE);
    public static final ChannelStateIdentifier CALL = new ChannelStateIdentifier(State.CALL);
    public static final ChannelStateIdentifier CONTROL = new ChannelStateIdentifier(State.CONTROL);
    public static final ChannelStateIdentifier DATA = new ChannelStateIdentifier(State.DATA);
    public static final ChannelStateIdentifier ENCRYPTED = new ChannelStateIdentifier(State.ENCRYPTED);
    public static final ChannelStateIdentifier FADE = new ChannelStateIdentifier(State.FADE);
    public static final ChannelStateIdentifier IDLE = new ChannelStateIdentifier(State.IDLE);
    public static final ChannelStateIdentifier TEARDOWN = new ChannelStateIdentifier(State.TEARDOWN);
    public static final ChannelStateIdentifier RESET = new ChannelStateIdentifier(State.RESET);

    public ChannelStateIdentifier(State value) {
        super(value, IdentifierClass.DECODER, Form.STATE, Role.ANY);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.UNKNOWN;
    }

    public static ChannelStateIdentifier get(State state) {
        switch (state) {
            case ACTIVE: {
                return ACTIVE;
            }
            case CALL: {
                return CALL;
            }
            case CONTROL: {
                return CONTROL;
            }
            case DATA: {
                return DATA;
            }
            case ENCRYPTED: {
                return ENCRYPTED;
            }
            case FADE: {
                return FADE;
            }
            case IDLE: {
                return IDLE;
            }
            case RESET: {
                return RESET;
            }
            case TEARDOWN: {
                return TEARDOWN;
            }
        }
        mLog.warn("Creating new channel state identifier for unrecognized state [" + String.valueOf((Object)state) + "]");
        return new ChannelStateIdentifier(state);
    }

    @Override
    public String toString() {
        return ((State)((Object)this.getValue())).getDisplayValue();
    }
}

