/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.playback;

import io.github.dsheirer.audio.AudioFormats;
import io.github.dsheirer.gui.preference.playback.ToneFrequency;
import io.github.dsheirer.gui.preference.playback.ToneVolume;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.playback.PlaybackPreference;
import io.github.dsheirer.source.mixer.MixerChannelConfiguration;
import io.github.dsheirer.source.mixer.MixerManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaybackPreferenceEditor
extends HBox {
    private static final Logger mLog = LoggerFactory.getLogger(PlaybackPreferenceEditor.class);
    private final PlaybackPreference mPlaybackPreference;
    private GridPane mEditorPane;
    private ComboBox<MixerChannelConfiguration> mMixerComboBox;
    private Button mMixerTestButton;
    private ToggleSwitch mUseAudioSegmentStartToneSwitch;
    private Button mTestStartToneButton;
    private ToggleSwitch mUseAudioSegmentDropToneSwitch;
    private Button mTestDropToneButton;
    private ComboBox<ToneFrequency> mStartToneFrequencyComboBox;
    private ComboBox<ToneVolume> mStartToneVolumeComboBox;
    private ComboBox<ToneFrequency> mDropToneFrequencyComboBox;
    private ComboBox<ToneVolume> mDropToneVolumeComboBox;

    public PlaybackPreferenceEditor(UserPreferences userPreferences) {
        this.mPlaybackPreference = userPreferences.getPlaybackPreference();
        HBox.setHgrow((Node)this.getEditorPane(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            int row = 0;
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setVgap(10.0);
            Label outputLabel = new Label("Audio Output Device");
            GridPane.setHalignment((Node)outputLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)outputLabel, 0, row, 2, 1);
            this.mEditorPane.add(this.getMixerComboBox(), 2, row, 3, 1);
            this.mEditorPane.add((Node)this.getMixerTestButton(), 5, row);
            this.mEditorPane.add((Node)new Separator(Orientation.HORIZONTAL), 0, ++row, 6, 1);
            this.mEditorPane.add((Node)new Label("Audio Playback Insert Tones"), 0, ++row, 2, 1);
            this.mEditorPane.add((Node)this.getUseAudioSegmentStartToneSwitch(), 0, ++row);
            this.mEditorPane.add((Node)new Label("Start Tone"), 1, row, 3, 1);
            Label startFrequencyLabel = new Label("Frequency:");
            GridPane.setHalignment((Node)startFrequencyLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)startFrequencyLabel, 1, ++row);
            this.mEditorPane.add(this.getStartToneFrequencyComboBox(), 2, row);
            Label startVolumeLabel = new Label("Volume:");
            GridPane.setHalignment((Node)startVolumeLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)startVolumeLabel, 3, row);
            this.mEditorPane.add(this.getStartToneVolumeComboBox(), 4, row);
            this.mEditorPane.add((Node)this.getTestStartToneButton(), 5, row);
            this.mEditorPane.add((Node)this.getUseAudioSegmentDropToneSwitch(), 0, ++row);
            this.mEditorPane.add((Node)new Label("Drop Tone - Do Not Monitor"), 1, row, 3, 1);
            Label dropFrequencyLabel = new Label("Frequency:");
            GridPane.setHalignment((Node)dropFrequencyLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)dropFrequencyLabel, 1, ++row);
            this.mEditorPane.add(this.getDropToneFrequencyComboBox(), 2, row);
            Label dropVolumeLabel = new Label("Volume:");
            GridPane.setHalignment((Node)dropVolumeLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)dropVolumeLabel, 3, row);
            this.mEditorPane.add(this.getDropToneVolumeComboBox(), 4, row);
            this.mEditorPane.add((Node)this.getTestDropToneButton(), 5, row);
        }
        return this.mEditorPane;
    }

    private ComboBox<MixerChannelConfiguration> getMixerComboBox() {
        if (this.mMixerComboBox == null) {
            this.mMixerComboBox = new ComboBox();
            this.mMixerComboBox.getItems().addAll(MixerManager.getOutputMixers());
            this.mMixerComboBox.getSelectionModel().select((Object)this.mPlaybackPreference.getMixerChannelConfiguration());
            this.mMixerComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.mPlaybackPreference.setMixerChannelConfiguration((MixerChannelConfiguration)newValue));
        }
        return this.mMixerComboBox;
    }

    public Button getMixerTestButton() {
        if (this.mMixerTestButton == null) {
            this.mMixerTestButton = new Button("Test");
            IconNode iconNode = new IconNode((IconCode)FontAwesome.PLAY);
            iconNode.setFill((Paint)Color.CORNFLOWERBLUE);
            this.mMixerTestButton.setGraphic((Node)iconNode);
            this.mMixerTestButton.setOnAction(event -> this.play(this.mPlaybackPreference.getMixerTestTone()));
        }
        return this.mMixerTestButton;
    }

    private ToggleSwitch getUseAudioSegmentStartToneSwitch() {
        if (this.mUseAudioSegmentStartToneSwitch == null) {
            this.mUseAudioSegmentStartToneSwitch = new ToggleSwitch();
            this.mUseAudioSegmentStartToneSwitch.setAlignment(Pos.BASELINE_RIGHT);
            this.mUseAudioSegmentStartToneSwitch.setSelected(this.mPlaybackPreference.getUseAudioSegmentStartTone());
            this.mUseAudioSegmentStartToneSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.mPlaybackPreference.setUseAudioSegmentStartTone((boolean)newValue));
        }
        return this.mUseAudioSegmentStartToneSwitch;
    }

    private ToggleSwitch getUseAudioSegmentDropToneSwitch() {
        if (this.mUseAudioSegmentDropToneSwitch == null) {
            this.mUseAudioSegmentDropToneSwitch = new ToggleSwitch();
            this.mUseAudioSegmentDropToneSwitch.setSelected(this.mPlaybackPreference.getUseAudioSegmentDropTone());
            this.mUseAudioSegmentDropToneSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.mPlaybackPreference.setUseAudioSegmentDropTone((boolean)newValue));
        }
        return this.mUseAudioSegmentDropToneSwitch;
    }

    public Button getTestStartToneButton() {
        if (this.mTestStartToneButton == null) {
            this.mTestStartToneButton = new Button("Test");
            IconNode iconNode = new IconNode((IconCode)FontAwesome.PLAY);
            iconNode.setFill((Paint)Color.CORNFLOWERBLUE);
            this.mTestStartToneButton.setGraphic((Node)iconNode);
            this.mTestStartToneButton.setOnAction(event -> this.play(this.mPlaybackPreference.getStartTone()));
            this.mTestStartToneButton.disableProperty().bind((ObservableValue)this.getUseAudioSegmentStartToneSwitch().selectedProperty().not());
        }
        return this.mTestStartToneButton;
    }

    public Button getTestDropToneButton() {
        if (this.mTestDropToneButton == null) {
            this.mTestDropToneButton = new Button("Test");
            IconNode iconNode = new IconNode((IconCode)FontAwesome.PLAY);
            iconNode.setFill((Paint)Color.CORNFLOWERBLUE);
            this.mTestDropToneButton.setGraphic((Node)iconNode);
            this.mTestDropToneButton.setOnAction(event -> this.play(this.mPlaybackPreference.getDropTone()));
            this.mTestDropToneButton.disableProperty().bind((ObservableValue)this.getUseAudioSegmentDropToneSwitch().selectedProperty().not());
        }
        return this.mTestDropToneButton;
    }

    public ComboBox<ToneFrequency> getDropToneFrequencyComboBox() {
        if (this.mDropToneFrequencyComboBox == null) {
            this.mDropToneFrequencyComboBox = new ComboBox();
            this.mDropToneFrequencyComboBox.getItems().addAll((Object[])ToneFrequency.values());
            this.mDropToneFrequencyComboBox.getSelectionModel().select((Object)this.mPlaybackPreference.getDropToneFrequency());
            this.mDropToneFrequencyComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.mPlaybackPreference.setDropToneFrequency((ToneFrequency)((Object)newValue)));
            this.mDropToneFrequencyComboBox.disableProperty().bind((ObservableValue)this.getUseAudioSegmentDropToneSwitch().selectedProperty().not());
        }
        return this.mDropToneFrequencyComboBox;
    }

    public ComboBox<ToneVolume> getDropToneVolumeComboBox() {
        if (this.mDropToneVolumeComboBox == null) {
            this.mDropToneVolumeComboBox = new ComboBox();
            this.mDropToneVolumeComboBox.getItems().addAll((Object[])ToneVolume.values());
            this.mDropToneVolumeComboBox.getSelectionModel().select((Object)this.mPlaybackPreference.getDropToneVolume());
            this.mDropToneVolumeComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.mPlaybackPreference.setDropToneVolume((ToneVolume)((Object)newValue)));
            this.mDropToneVolumeComboBox.disableProperty().bind((ObservableValue)this.getUseAudioSegmentDropToneSwitch().selectedProperty().not());
        }
        return this.mDropToneVolumeComboBox;
    }

    public ComboBox<ToneFrequency> getStartToneFrequencyComboBox() {
        if (this.mStartToneFrequencyComboBox == null) {
            this.mStartToneFrequencyComboBox = new ComboBox();
            this.mStartToneFrequencyComboBox.getItems().addAll((Object[])ToneFrequency.values());
            this.mStartToneFrequencyComboBox.getSelectionModel().select((Object)this.mPlaybackPreference.getStartToneFrequency());
            this.mStartToneFrequencyComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.mPlaybackPreference.setStartToneFrequency((ToneFrequency)((Object)newValue)));
            this.mStartToneFrequencyComboBox.disableProperty().bind((ObservableValue)this.getUseAudioSegmentStartToneSwitch().selectedProperty().not());
        }
        return this.mStartToneFrequencyComboBox;
    }

    public ComboBox<ToneVolume> getStartToneVolumeComboBox() {
        if (this.mStartToneVolumeComboBox == null) {
            this.mStartToneVolumeComboBox = new ComboBox();
            this.mStartToneVolumeComboBox.getItems().addAll((Object[])ToneVolume.values());
            this.mStartToneVolumeComboBox.getSelectionModel().select((Object)this.mPlaybackPreference.getStartToneVolume());
            this.mStartToneVolumeComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.mPlaybackPreference.setStartToneVolume((ToneVolume)((Object)newValue)));
            this.mStartToneVolumeComboBox.disableProperty().bind((ObservableValue)this.getUseAudioSegmentStartToneSwitch().selectedProperty().not());
        }
        return this.mStartToneVolumeComboBox;
    }

    private void play(float[] audioSamples) {
        if (audioSamples != null) {
            ByteBuffer buffer = ByteBuffer.allocate(audioSamples.length * 2).order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer shortBuffer = buffer.asShortBuffer();
            for (float sample : audioSamples) {
                shortBuffer.put((short)(sample * 32767.0f));
            }
            byte[] bytes = buffer.array();
            DataLine.Info info = new DataLine.Info(Clip.class, AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO);
            if (!AudioSystem.isLineSupported(info)) {
                mLog.error("Audio clip playback is not supported on this system");
                return;
            }
            try {
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.open(AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO, bytes, 0, bytes.length);
                clip.start();
            }
            catch (Exception e) {
                mLog.error("Error attempting to play audio test tone");
            }
        }
    }
}

