/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.directory;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.directory.DirectoryPreference;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Spinner;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryPreferenceEditor
extends HBox {
    private static final Logger mLog = LoggerFactory.getLogger(DirectoryPreferenceEditor.class);
    private DirectoryPreference mDirectoryPreference;
    private GridPane mEditorPane;
    private Label mApplicationRootLabel;
    private Button mChangeApplicationRootButton;
    private Button mResetApplicationRootButton;
    private Label mApplicationRootPathLabel;
    private Label mApplicationLogsLabel;
    private Button mChangeApplicationLogsButton;
    private Button mResetApplicationLogsButton;
    private Label mApplicationLogsPathLabel;
    private Label mConfigurationLabel;
    private Button mChangeConfigurationButton;
    private Button mResetConfigurationButton;
    private Label mConfigurationPathLabel;
    private Label mEventLogsLabel;
    private Button mChangeEventLogsButton;
    private Button mResetEventLogsButton;
    private Label mEventLogsPathLabel;
    private Label mJmbeLabel;
    private Button mChangeJmbeButton;
    private Button mResetJmbeButton;
    private Label mJmbePathLabel;
    private Label mPlaylistLabel;
    private Button mChangePlaylistButton;
    private Button mResetPlaylistButton;
    private Label mPlaylistPathLabel;
    private Label mRecordingLabel;
    private Button mChangeRecordingButton;
    private Button mResetRecordingButton;
    private Label mRecordingPathLabel;
    private Label mScreenCaptureLabel;
    private Button mChangeScreenCaptureButton;
    private Button mResetScreenCaptureButton;
    private Label mScreenCapturePathLabel;
    private Label mStreamingLabel;
    private Button mChangeStreamingButton;
    private Button mResetStreamingButton;
    private Label mStreamingPathLabel;
    private Spinner<Integer> mRecordingSpinner;
    private Spinner<Integer> mEventLogSpinner;

    public DirectoryPreferenceEditor(UserPreferences userPreferences) {
        this.mDirectoryPreference = userPreferences.getDirectoryPreference();
        MyEventBus.getGlobalEventBus().register((Object)this);
        HBox.setHgrow((Node)this.getEditorPane(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getEditorPane());
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            int row = 0;
            Label itemLabel = new Label("Item");
            GridPane.setMargin((Node)itemLabel, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)itemLabel, 0, row);
            Label directoryLabel = new Label("Directory");
            GridPane.setMargin((Node)directoryLabel, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)directoryLabel, 1, row++);
            this.mEditorPane.add((Node)new Separator(Orientation.HORIZONTAL), 0, row++, 4, 1);
            GridPane.setMargin((Node)this.getApplicationRootLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getApplicationRootLabel(), 0, row);
            GridPane.setMargin((Node)this.getApplicationRootPathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getApplicationRootPathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeApplicationRootButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeApplicationRootButton(), 2, row);
            GridPane.setMargin((Node)this.getResetApplicationRootButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetApplicationRootButton(), 3, row++);
            GridPane.setMargin((Node)this.getApplicationLogsLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getApplicationLogsLabel(), 0, row);
            GridPane.setMargin((Node)this.getApplicationLogsPathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getApplicationLogsPathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeApplicationLogsButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeApplicationLogsButton(), 2, row);
            GridPane.setMargin((Node)this.getResetApplicationLogsButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetApplicationLogsButton(), 3, row++);
            GridPane.setMargin((Node)this.getConfigurationLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getConfigurationLabel(), 0, row);
            GridPane.setMargin((Node)this.getConfigurationPathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getConfigurationPathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeConfigurationButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeConfigurationButton(), 2, row);
            GridPane.setMargin((Node)this.getResetConfigurationButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetConfigurationButton(), 3, row++);
            GridPane.setMargin((Node)this.getEventLogsLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getEventLogsLabel(), 0, row);
            GridPane.setMargin((Node)this.getEventLogsPathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getEventLogsPathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeEventLogsButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeEventLogsButton(), 2, row);
            GridPane.setMargin((Node)this.getResetEventLogsButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetEventLogsButton(), 3, row++);
            GridPane.setMargin((Node)this.getJmbeLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getJmbeLabel(), 0, row);
            GridPane.setMargin((Node)this.getJmbePathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getJmbePathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeJmbeButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeJmbeButton(), 2, row);
            GridPane.setMargin((Node)this.getResetJmbeButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetJmbeButton(), 3, row++);
            GridPane.setMargin((Node)this.getPlaylistLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getPlaylistLabel(), 0, row);
            GridPane.setMargin((Node)this.getPlaylistPathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getPlaylistPathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangePlaylistButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangePlaylistButton(), 2, row);
            GridPane.setMargin((Node)this.getResetPlaylistButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetPlaylistButton(), 3, row++);
            GridPane.setMargin((Node)this.getRecordingLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getRecordingLabel(), 0, row);
            GridPane.setMargin((Node)this.getRecordingPathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getRecordingPathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeRecordingButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeRecordingButton(), 2, row);
            GridPane.setMargin((Node)this.getResetRecordingButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetRecordingButton(), 3, row++);
            GridPane.setMargin((Node)this.getScreenCaptureLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getScreenCaptureLabel(), 0, row);
            GridPane.setMargin((Node)this.getScreenCapturePathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getScreenCapturePathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeScreenCaptureButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeScreenCaptureButton(), 2, row);
            GridPane.setMargin((Node)this.getResetScreenCaptureButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetScreenCaptureButton(), 3, row++);
            GridPane.setMargin((Node)this.getStreamingLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getStreamingLabel(), 0, row);
            GridPane.setMargin((Node)this.getStreamingPathLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.mEditorPane.add((Node)this.getStreamingPathLabel(), 1, row);
            GridPane.setMargin((Node)this.getChangeStreamingButton(), (Insets)new Insets(2.0, 10.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getChangeStreamingButton(), 2, row);
            GridPane.setMargin((Node)this.getResetStreamingButton(), (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)this.getResetStreamingButton(), 3, row++);
            Label monitorLabel = new Label("File storage usage monitoring - maximum size thresholds (MB)");
            GridPane.setMargin((Node)monitorLabel, (Insets)new Insets(15.0, 0.0, 2.0, 0.0));
            this.mEditorPane.add((Node)monitorLabel, 0, row++, 4, 1);
            this.mEditorPane.add((Node)new Separator(Orientation.HORIZONTAL), 0, row++, 4, 1);
            this.mEditorPane.add((Node)new Label("Event Logs"), 0, row);
            GridPane.setMargin(this.getEventLogSpinner(), (Insets)new Insets(2.0, 2.0, 2.0, 0.0));
            this.mEditorPane.add(this.getEventLogSpinner(), 1, row++);
            this.mEditorPane.add((Node)new Label("Recordings"), 0, row);
            GridPane.setMargin(this.getRecordingSpinner(), (Insets)new Insets(2.0, 2.0, 2.0, 0.0));
            this.mEditorPane.add(this.getRecordingSpinner(), 1, row);
        }
        return this.mEditorPane;
    }

    private Spinner<Integer> getRecordingSpinner() {
        if (this.mRecordingSpinner == null) {
            this.mRecordingSpinner = new Spinner(100, Integer.MAX_VALUE, this.mDirectoryPreference.getDirectoryMaxUsageRecordings(), 100);
            this.mRecordingSpinner.valueProperty().addListener((observable, oldValue, newValue) -> this.mDirectoryPreference.setDirectoryMaxUsageRecordings((int)newValue));
        }
        return this.mRecordingSpinner;
    }

    private Spinner<Integer> getEventLogSpinner() {
        if (this.mEventLogSpinner == null) {
            this.mEventLogSpinner = new Spinner(100, Integer.MAX_VALUE, this.mDirectoryPreference.getDirectoryMaxUsageEventLogs(), 100);
            this.mEventLogSpinner.setEditable(true);
            this.mEventLogSpinner.valueProperty().addListener((observable, oldValue, newValue) -> this.mDirectoryPreference.setDirectoryMaxUsageEventLogs((int)newValue));
        }
        return this.mEventLogSpinner;
    }

    private Label getApplicationRootLabel() {
        if (this.mApplicationRootLabel == null) {
            this.mApplicationRootLabel = new Label("Application Root");
        }
        return this.mApplicationRootLabel;
    }

    private Button getChangeApplicationRootButton() {
        if (this.mChangeApplicationRootButton == null) {
            this.mChangeApplicationRootButton = new Button("Change...");
            this.mChangeApplicationRootButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Application Root Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryApplicationRoot().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeApplicationRootButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryApplicationRoot(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeApplicationRootButton;
    }

    private Button getResetApplicationRootButton() {
        if (this.mResetApplicationRootButton == null) {
            this.mResetApplicationRootButton = new Button("Reset");
            this.mResetApplicationRootButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryApplicationRoot();
                }
            });
        }
        return this.mResetApplicationRootButton;
    }

    private Label getApplicationRootPathLabel() {
        if (this.mApplicationRootPathLabel == null) {
            this.mApplicationRootPathLabel = new Label(this.mDirectoryPreference.getDirectoryApplicationRoot().toString());
        }
        return this.mApplicationRootPathLabel;
    }

    private Label getApplicationLogsLabel() {
        if (this.mApplicationLogsLabel == null) {
            this.mApplicationLogsLabel = new Label("Application Logs");
        }
        return this.mApplicationLogsLabel;
    }

    private Button getChangeApplicationLogsButton() {
        if (this.mChangeApplicationLogsButton == null) {
            this.mChangeApplicationLogsButton = new Button("Change...");
            this.mChangeApplicationLogsButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Application Logs Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryApplicationLog().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeApplicationLogsButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryApplicationLogs(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeApplicationLogsButton;
    }

    private Button getResetApplicationLogsButton() {
        if (this.mResetApplicationLogsButton == null) {
            this.mResetApplicationLogsButton = new Button("Reset");
            this.mResetApplicationLogsButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryApplicationLogs();
                }
            });
        }
        return this.mResetApplicationLogsButton;
    }

    private Label getApplicationLogsPathLabel() {
        if (this.mApplicationLogsPathLabel == null) {
            this.mApplicationLogsPathLabel = new Label(this.mDirectoryPreference.getDirectoryApplicationLog().toString());
        }
        return this.mApplicationLogsPathLabel;
    }

    private Label getConfigurationLabel() {
        if (this.mConfigurationLabel == null) {
            this.mConfigurationLabel = new Label("Configuration");
        }
        return this.mConfigurationLabel;
    }

    private Button getChangeConfigurationButton() {
        if (this.mChangeConfigurationButton == null) {
            this.mChangeConfigurationButton = new Button("Change...");
            this.mChangeConfigurationButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Configuration Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryConfiguration().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeConfigurationButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryConfiguration(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeConfigurationButton;
    }

    private Button getResetConfigurationButton() {
        if (this.mResetConfigurationButton == null) {
            this.mResetConfigurationButton = new Button("Reset");
            this.mResetConfigurationButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryConfiguration();
                }
            });
        }
        return this.mResetConfigurationButton;
    }

    private Label getConfigurationPathLabel() {
        if (this.mConfigurationPathLabel == null) {
            this.mConfigurationPathLabel = new Label(this.mDirectoryPreference.getDirectoryConfiguration().toString());
        }
        return this.mConfigurationPathLabel;
    }

    private Label getEventLogsLabel() {
        if (this.mEventLogsLabel == null) {
            this.mEventLogsLabel = new Label("Event Logs");
        }
        return this.mEventLogsLabel;
    }

    private Button getChangeEventLogsButton() {
        if (this.mChangeEventLogsButton == null) {
            this.mChangeEventLogsButton = new Button("Change...");
            this.mChangeEventLogsButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Event Logs Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryEventLog().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeEventLogsButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryEventLogs(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeEventLogsButton;
    }

    private Button getResetEventLogsButton() {
        if (this.mResetEventLogsButton == null) {
            this.mResetEventLogsButton = new Button("Reset");
            this.mResetEventLogsButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryEventLogs();
                }
            });
        }
        return this.mResetEventLogsButton;
    }

    private Label getEventLogsPathLabel() {
        if (this.mEventLogsPathLabel == null) {
            this.mEventLogsPathLabel = new Label(this.mDirectoryPreference.getDirectoryEventLog().toString());
        }
        return this.mEventLogsPathLabel;
    }

    private Label getJmbeLabel() {
        if (this.mJmbeLabel == null) {
            this.mJmbeLabel = new Label("JMBE Libraries");
        }
        return this.mJmbeLabel;
    }

    private Button getChangeJmbeButton() {
        if (this.mChangeJmbeButton == null) {
            this.mChangeJmbeButton = new Button("Change...");
            this.mChangeJmbeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select JMBE Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryJmbe().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeJmbeButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryJmbe(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeJmbeButton;
    }

    private Button getResetJmbeButton() {
        if (this.mResetJmbeButton == null) {
            this.mResetJmbeButton = new Button("Reset");
            this.mResetJmbeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryJmbe();
                }
            });
        }
        return this.mResetJmbeButton;
    }

    private Label getJmbePathLabel() {
        if (this.mJmbePathLabel == null) {
            this.mJmbePathLabel = new Label(this.mDirectoryPreference.getDirectoryJmbe().toString());
        }
        return this.mJmbePathLabel;
    }

    private Label getPlaylistLabel() {
        if (this.mPlaylistLabel == null) {
            this.mPlaylistLabel = new Label("Playlists");
        }
        return this.mPlaylistLabel;
    }

    private Button getChangePlaylistButton() {
        if (this.mChangePlaylistButton == null) {
            this.mChangePlaylistButton = new Button("Change...");
            this.mChangePlaylistButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Playlist Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryPlaylist().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangePlaylistButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryPlaylist(selected.toPath());
                    }
                }
            });
        }
        return this.mChangePlaylistButton;
    }

    private Button getResetPlaylistButton() {
        if (this.mResetPlaylistButton == null) {
            this.mResetPlaylistButton = new Button("Reset");
            this.mResetPlaylistButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryPlaylist();
                }
            });
        }
        return this.mResetPlaylistButton;
    }

    private Label getPlaylistPathLabel() {
        if (this.mPlaylistPathLabel == null) {
            this.mPlaylistPathLabel = new Label(this.mDirectoryPreference.getDirectoryPlaylist().toString());
        }
        return this.mPlaylistPathLabel;
    }

    private Label getRecordingLabel() {
        if (this.mRecordingLabel == null) {
            this.mRecordingLabel = new Label("Recordings");
        }
        return this.mRecordingLabel;
    }

    private Button getChangeRecordingButton() {
        if (this.mChangeRecordingButton == null) {
            this.mChangeRecordingButton = new Button("Change...");
            this.mChangeRecordingButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Recording Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryRecording().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeRecordingButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryRecording(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeRecordingButton;
    }

    private Button getResetRecordingButton() {
        if (this.mResetRecordingButton == null) {
            this.mResetRecordingButton = new Button("Reset");
            this.mResetRecordingButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryRecording();
                }
            });
        }
        return this.mResetRecordingButton;
    }

    private Label getRecordingPathLabel() {
        if (this.mRecordingPathLabel == null) {
            this.mRecordingPathLabel = new Label(this.mDirectoryPreference.getDirectoryRecording().toString());
        }
        return this.mRecordingPathLabel;
    }

    private Label getScreenCaptureLabel() {
        if (this.mScreenCaptureLabel == null) {
            this.mScreenCaptureLabel = new Label("Screen Captures");
        }
        return this.mScreenCaptureLabel;
    }

    private Button getChangeScreenCaptureButton() {
        if (this.mChangeScreenCaptureButton == null) {
            this.mChangeScreenCaptureButton = new Button("Change...");
            this.mChangeScreenCaptureButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Screen Capture Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryScreenCapture().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeScreenCaptureButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryScreenCapture(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeScreenCaptureButton;
    }

    private Button getResetScreenCaptureButton() {
        if (this.mResetScreenCaptureButton == null) {
            this.mResetScreenCaptureButton = new Button("Reset");
            this.mResetScreenCaptureButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryScreenCapture();
                }
            });
        }
        return this.mResetScreenCaptureButton;
    }

    private Label getScreenCapturePathLabel() {
        if (this.mScreenCapturePathLabel == null) {
            this.mScreenCapturePathLabel = new Label(this.mDirectoryPreference.getDirectoryScreenCapture().toString());
        }
        return this.mScreenCapturePathLabel;
    }

    private Label getStreamingLabel() {
        if (this.mStreamingLabel == null) {
            this.mStreamingLabel = new Label("Streaming");
        }
        return this.mStreamingLabel;
    }

    private Button getChangeStreamingButton() {
        if (this.mChangeStreamingButton == null) {
            this.mChangeStreamingButton = new Button("Change...");
            this.mChangeStreamingButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryChooser directoryChooser = new DirectoryChooser();
                    directoryChooser.setTitle("Select Streaming Folder");
                    directoryChooser.setInitialDirectory(DirectoryPreferenceEditor.this.mDirectoryPreference.getDirectoryStreaming().toFile());
                    Stage stage = (Stage)DirectoryPreferenceEditor.this.getChangeStreamingButton().getScene().getWindow();
                    File selected = directoryChooser.showDialog((Window)stage);
                    if (selected != null) {
                        DirectoryPreferenceEditor.this.mDirectoryPreference.setDirectoryStreaming(selected.toPath());
                    }
                }
            });
        }
        return this.mChangeStreamingButton;
    }

    private Button getResetStreamingButton() {
        if (this.mResetStreamingButton == null) {
            this.mResetStreamingButton = new Button("Reset");
            this.mResetStreamingButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DirectoryPreferenceEditor.this.mDirectoryPreference.resetDirectoryStreaming();
                }
            });
        }
        return this.mResetStreamingButton;
    }

    private Label getStreamingPathLabel() {
        if (this.mStreamingPathLabel == null) {
            this.mStreamingPathLabel = new Label(this.mDirectoryPreference.getDirectoryStreaming().toString());
        }
        return this.mStreamingPathLabel;
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType != null && preferenceType == PreferenceType.DIRECTORY) {
            this.getApplicationRootPathLabel().setText(this.mDirectoryPreference.getDirectoryApplicationRoot().toString());
            this.getApplicationLogsPathLabel().setText(this.mDirectoryPreference.getDirectoryApplicationLog().toString());
            this.getEventLogsPathLabel().setText(this.mDirectoryPreference.getDirectoryEventLog().toString());
            this.getPlaylistPathLabel().setText(this.mDirectoryPreference.getDirectoryPlaylist().toString());
            this.getRecordingPathLabel().setText(this.mDirectoryPreference.getDirectoryRecording().toString());
            this.getScreenCapturePathLabel().setText(this.mDirectoryPreference.getDirectoryScreenCapture().toString());
            this.getStreamingPathLabel().setText(this.mDirectoryPreference.getDirectoryStreaming().toString());
        }
    }
}

