/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference;

import io.github.dsheirer.preference.TimestampFormat;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.event.DecodeEventPreference;
import java.util.Date;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class DecodeEventViewPreferenceEditor
extends HBox {
    private DecodeEventPreference mDecodeEventPreference;
    private GridPane mEditorPane;
    private ChoiceBox<DisplayableTimestamp> mTimestampFormatChoiceBox;
    private Label mTimestampFormatLabel;

    public DecodeEventViewPreferenceEditor(UserPreferences userPreferences) {
        this.mDecodeEventPreference = userPreferences.getDecodeEventPreference();
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            GridPane.setMargin((Node)this.getTimestampFormatLabel(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            GridPane.setHalignment((Node)this.getTimestampFormatLabel(), (HPos)HPos.LEFT);
            this.mEditorPane.add((Node)this.getTimestampFormatLabel(), 0, 0);
            this.mEditorPane.add(this.getTimestampFormatChoiceBox(), 1, 0);
        }
        return this.mEditorPane;
    }

    private Label getTimestampFormatLabel() {
        if (this.mTimestampFormatLabel == null) {
            this.mTimestampFormatLabel = new Label("Timestamp Format");
        }
        return this.mTimestampFormatLabel;
    }

    private ChoiceBox<DisplayableTimestamp> getTimestampFormatChoiceBox() {
        if (this.mTimestampFormatChoiceBox == null) {
            this.mTimestampFormatChoiceBox = new ChoiceBox();
            for (TimestampFormat format : TimestampFormat.values()) {
                this.mTimestampFormatChoiceBox.getItems().add((Object)new DisplayableTimestamp(this, format));
            }
            TimestampFormat current = this.mDecodeEventPreference.getTimestampFormat();
            for (DisplayableTimestamp displayableTimestamp : this.mTimestampFormatChoiceBox.getItems()) {
                if (displayableTimestamp.getTimestampFormat() != current) continue;
                this.mTimestampFormatChoiceBox.getSelectionModel().select((Object)displayableTimestamp);
            }
            this.mTimestampFormatChoiceBox.setOnAction(event -> {
                DisplayableTimestamp selected = (DisplayableTimestamp)this.mTimestampFormatChoiceBox.getSelectionModel().getSelectedItem();
                this.mDecodeEventPreference.setTimestampFormat(selected.getTimestampFormat());
            });
        }
        return this.mTimestampFormatChoiceBox;
    }

    public class DisplayableTimestamp {
        private TimestampFormat mTimestampFormat;

        public DisplayableTimestamp(DecodeEventViewPreferenceEditor this$0, TimestampFormat timestampFormat) {
            this.mTimestampFormat = timestampFormat;
        }

        public TimestampFormat getTimestampFormat() {
            return this.mTimestampFormat;
        }

        public String toString() {
            return this.mTimestampFormat.getFormatter().format(new Date(System.currentTimeMillis()));
        }
    }
}

