/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.power;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.dsp.filter.channelizer.PolyphaseChannelSource;
import io.github.dsheirer.dsp.squelch.ISquelchConfiguration;
import io.github.dsheirer.gui.control.DbPowerMeter;
import io.github.dsheirer.gui.power.PeakMonitor;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamplesToNativeBufferModule;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.channel.HalfBandTunerChannelSource;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.spectrum.ComplexDftProcessor;
import io.github.dsheirer.spectrum.FrequencyOverlayPanel;
import io.github.dsheirer.spectrum.SpectrumPanel;
import io.github.dsheirer.spectrum.converter.ComplexDecibelConverter;
import io.github.dsheirer.spectrum.converter.DFTResultsConverter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.MouseInputAdapter;
import jiconfont.IconCode;
import jiconfont.IconFont;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPowerPanel
extends JPanel
implements Listener<ProcessingChain> {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelPowerPanel.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    private static final DecimalFormat FREQUENCY_FORMAT = new DecimalFormat("0.00000");
    private static final String NOT_AVAILABLE = "Not Available";
    private PlaylistManager mPlaylistManager;
    private ProcessingChain mProcessingChain;
    private ComplexSamplesToNativeBufferModule mSampleStreamTapModule = new ComplexSamplesToNativeBufferModule();
    private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
    private DFTResultsConverter mDFTResultsConverter = new ComplexDecibelConverter();
    private JLayeredPane mLayeredPanel;
    private SpectrumPanel mSpectrumPanel;
    private FrequencyOverlayPanel mFrequencyOverlayPanel;
    private DbPowerMeter mPowerMeter = new DbPowerMeter();
    private PeakMonitor mPeakMonitor = new PeakMonitor(-110.0);
    private SourceEventProcessor mSourceEventProcessor = new SourceEventProcessor();
    private SpinnerNumberModel mNoiseFloorSpinnerModel;
    private JSpinner mNoiseFloorSpinner;
    private JLabel mPowerLabel;
    private JLabel mPeakLabel;
    private JLabel mSquelchLabel;
    private JLabel mSquelchValueLabel;
    private JLabel mPllFrequencyLabel;
    private JLabel mPllFrequencyValueLabel;
    private JButton mSquelchUpButton;
    private JButton mSquelchDownButton;
    private JButton mLogIndexesButton;
    private JCheckBox mSquelchAutoTrackCheckBox;
    private double mSquelchThreshold;
    private boolean mPanelVisible = false;
    private boolean mDftProcessing = false;

    public ChannelPowerPanel(PlaylistManager playlistManager, SettingsManager settingsManager) {
        this.mPlaylistManager = playlistManager;
        this.setLayout((LayoutManager)new MigLayout("", "[][][][grow,fill]", "[grow,fill]"));
        this.mPowerMeter.setPeakVisible(true);
        this.mPowerMeter.setSquelchThresholdVisible(true);
        this.add(this.mPowerMeter);
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout((LayoutManager)new MigLayout("", "[right][left][][]", ""));
        this.mPeakLabel = new JLabel("0");
        this.mPeakLabel.setToolTipText("Current peak power level in decibels.");
        valuePanel.add(new JLabel("Peak:"));
        valuePanel.add((Component)this.mPeakLabel, "wrap");
        this.mPowerLabel = new JLabel("0");
        this.mPowerLabel.setToolTipText("Current Power level in decibels");
        valuePanel.add(new JLabel("Power:"));
        valuePanel.add((Component)this.mPowerLabel, "wrap");
        this.mSquelchLabel = new JLabel("Squelch:");
        this.mSquelchLabel.setEnabled(false);
        valuePanel.add(this.mSquelchLabel);
        this.mSquelchValueLabel = new JLabel(NOT_AVAILABLE);
        this.mSquelchValueLabel.setToolTipText("Squelch threshold value in decibels");
        this.mSquelchValueLabel.setEnabled(false);
        valuePanel.add((Component)this.mSquelchValueLabel, "wrap");
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        Icon iconUp = IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_UP, (float)12.0f);
        this.mSquelchUpButton = new JButton(iconUp);
        this.mSquelchUpButton.setToolTipText("Increases the squelch threshold value");
        this.mSquelchUpButton.setEnabled(false);
        this.mSquelchUpButton.addActionListener(e -> this.broadcast(SourceEvent.requestSquelchThreshold(null, this.mSquelchThreshold + 1.0)));
        valuePanel.add(this.mSquelchUpButton);
        Icon iconDown = IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_DOWN, (float)12.0f);
        this.mSquelchDownButton = new JButton(iconDown);
        this.mSquelchDownButton.setToolTipText("Decreases the squelch threshold value.");
        this.mSquelchDownButton.setEnabled(false);
        this.mSquelchDownButton.addActionListener(e -> this.broadcast(SourceEvent.requestSquelchThreshold(null, this.mSquelchThreshold - 1.0)));
        valuePanel.add((Component)this.mSquelchDownButton, "wrap");
        this.mSquelchAutoTrackCheckBox = new JCheckBox("Auto Track");
        this.mSquelchAutoTrackCheckBox.setToolTipText("Enable or disable monitoring of the noise floor to auto-adjust the squelch threshold value maintaining a consistent level/buffer above the noise floor");
        this.mSquelchAutoTrackCheckBox.setEnabled(false);
        this.mSquelchAutoTrackCheckBox.addActionListener(e -> this.broadcast(SourceEvent.requestSquelchAutoTrack(this.mSquelchAutoTrackCheckBox.isSelected())));
        valuePanel.add((Component)this.mSquelchAutoTrackCheckBox, "span,left");
        this.add(valuePanel);
        this.add(new JSeparator(1));
        JPanel fftPanel = new JPanel();
        fftPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow,fill]", "[][grow,fill]"));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow,fill][right][grow,fill][right][grow,fill][]", ""));
        labelPanel.add(new JLabel("Channel Spectrum"));
        this.mPllFrequencyLabel = new JLabel("PLL:");
        this.mPllFrequencyLabel.setEnabled(false);
        labelPanel.add(this.mPllFrequencyLabel);
        this.mPllFrequencyValueLabel = new JLabel("0 Hz");
        this.mPllFrequencyValueLabel.setEnabled(false);
        labelPanel.add(this.mPllFrequencyValueLabel);
        this.mNoiseFloorSpinnerModel = new SpinnerNumberModel(18, 8, 36, 1);
        this.mNoiseFloorSpinnerModel.addChangeListener(e -> {
            Number number = this.mNoiseFloorSpinnerModel.getNumber();
            this.mSpectrumPanel.setSampleSize(number.doubleValue());
        });
        this.mNoiseFloorSpinner = new JSpinner(this.mNoiseFloorSpinnerModel);
        labelPanel.add(this.mNoiseFloorSpinner);
        labelPanel.add(new JLabel("Spectral Display Noise Floor"));
        this.mLogIndexesButton = new JButton("Log Settings");
        this.mLogIndexesButton.addActionListener(e -> {
            if (this.mProcessingChain != null) {
                Source source = this.mProcessingChain.getSource();
                if (source instanceof PolyphaseChannelSource) {
                    PolyphaseChannelSource pcs = (PolyphaseChannelSource)source;
                    List<Integer> indexes = pcs.getOutputProcessorIndexes();
                    double sampleRate = pcs.getSampleRate();
                    long indexCenterFrequency = pcs.getIndexCenterFrequency();
                    long appliedFrequencyOffset = pcs.getFrequencyOffset();
                    long requestedCenterFrequency = pcs.getFrequency();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Polyphase Channel - BW: ").append(FREQUENCY_FORMAT.format(sampleRate / 1000000.0));
                    sb.append(" Center/Requested/Mixer: ").append(FREQUENCY_FORMAT.format((double)indexCenterFrequency / 1000000.0));
                    sb.append("/").append(FREQUENCY_FORMAT.format((double)requestedCenterFrequency / 1000000.0));
                    sb.append("/").append(FREQUENCY_FORMAT.format((double)appliedFrequencyOffset / 1000000.0));
                    sb.append(" Polyphase Indexes: ").append(indexes);
                    sb.append(" Tuner SR:").append(FREQUENCY_FORMAT.format(pcs.getTunerSampleRate() / 1000000.0));
                    sb.append(" CF:").append(FREQUENCY_FORMAT.format(pcs.getTunerCenterFrequency() / 1000000.0));
                    mLog.info(sb.toString());
                    mLog.info("Output Processor: " + pcs.getStateDescription());
                } else if (source instanceof HalfBandTunerChannelSource) {
                    HalfBandTunerChannelSource hbtcs = (HalfBandTunerChannelSource)source;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Heterodyne Channel - CF:").append(FREQUENCY_FORMAT.format((double)hbtcs.getFrequency() / 1000000.0));
                    sb.append(" SR:").append(FREQUENCY_FORMAT.format(hbtcs.getSampleRate() / 1000000.0));
                    sb.append(" Mixer:").append(FREQUENCY_FORMAT.format((double)hbtcs.getMixerFrequency() / 1000000.0));
                    mLog.info(sb.toString());
                } else {
                    mLog.info("Unsupported channel type: " + String.valueOf(source != null ? source.getClass() : " null"));
                }
            }
        });
        labelPanel.add(this.mLogIndexesButton);
        fftPanel.add((Component)labelPanel, "wrap");
        this.mFrequencyOverlayPanel = new FrequencyOverlayPanel(settingsManager);
        this.mSpectrumPanel = new SpectrumPanel(settingsManager);
        this.mSpectrumPanel.setSampleSize(18.0);
        this.mLayeredPanel = new JLayeredPane();
        this.mLayeredPanel.addComponentListener(new ResizeListener());
        MouseEventProcessor mouser = new MouseEventProcessor();
        this.mFrequencyOverlayPanel.addMouseListener(mouser);
        this.mFrequencyOverlayPanel.addMouseMotionListener(mouser);
        this.mFrequencyOverlayPanel.addMouseWheelListener(mouser);
        this.mLayeredPanel.add(this.mSpectrumPanel, 0, 0);
        this.mLayeredPanel.add(this.mFrequencyOverlayPanel, 1, 0);
        fftPanel.add(this.mLayeredPanel);
        this.add(fftPanel);
        this.mSampleStreamTapModule.setListener(this.mComplexDftProcessor);
        this.mComplexDftProcessor.addConverter(this.mDFTResultsConverter);
        this.mDFTResultsConverter.addListener(this.mSpectrumPanel);
        this.mSpectrumPanel.clearSpectrum();
    }

    public void setPanelVisible(boolean visible) {
        this.mPanelVisible = visible;
        this.updateFFTProcessing();
    }

    private void updateFFTProcessing() {
        if (this.mPanelVisible && this.mProcessingChain != null) {
            this.startDftProcessing();
        } else {
            this.stopDftProcessing();
        }
    }

    private void startDftProcessing() {
        if (!this.mDftProcessing) {
            this.mDftProcessing = true;
            this.mSampleStreamTapModule.setListener(this.mComplexDftProcessor);
            this.mComplexDftProcessor.start();
        }
    }

    private void stopDftProcessing() {
        if (this.mDftProcessing) {
            this.mSampleStreamTapModule.removeListener();
            this.mComplexDftProcessor.stop();
            this.mSpectrumPanel.clearSpectrum();
            this.mDftProcessing = false;
        }
    }

    private void updatePllFrequency(long trackingFrequency) {
        EventQueue.invokeLater(() -> {
            String formattedValue = NumberFormat.getInstance().format(-trackingFrequency);
            this.mPllFrequencyValueLabel.setText(formattedValue + " Hz");
            this.mPllFrequencyValueLabel.setEnabled(true);
            this.mPllFrequencyLabel.setEnabled(true);
        });
        this.mFrequencyOverlayPanel.setPllTrackingFrequency(trackingFrequency);
    }

    private void setConfigSquelchThreshold(int threshold) {
        Channel channel;
        if (this.mProcessingChain != null && (channel = this.mPlaylistManager.getChannelProcessingManager().getChannel(this.mProcessingChain)) != null && channel.getDecodeConfiguration() instanceof ISquelchConfiguration) {
            ISquelchConfiguration configuration = (ISquelchConfiguration)((Object)channel.getDecodeConfiguration());
            configuration.setSquelchThreshold(threshold);
            this.mPlaylistManager.schedulePlaylistSave();
        }
    }

    private void setConfigSquelchAutoTrack(boolean autoTrack) {
        Channel channel = this.mPlaylistManager.getChannelProcessingManager().getChannel(this.mProcessingChain);
        if (channel != null && channel.getDecodeConfiguration() instanceof ISquelchConfiguration) {
            ISquelchConfiguration configuration = (ISquelchConfiguration)((Object)channel.getDecodeConfiguration());
            configuration.setSquelchAutoTrack(autoTrack);
            this.mPlaylistManager.schedulePlaylistSave();
        }
    }

    private void broadcast(SourceEvent sourceEvent) {
        if (this.mProcessingChain != null) {
            this.mProcessingChain.broadcast(sourceEvent);
        }
    }

    private void reset() {
        this.mPeakMonitor.reset();
        this.mPowerMeter.reset();
        this.mPeakLabel.setText("0");
        this.mPowerLabel.setText("0");
        this.mPllFrequencyLabel.setEnabled(false);
        this.mPllFrequencyValueLabel.setText("0 Hz");
        this.mPllFrequencyValueLabel.setEnabled(false);
        this.mFrequencyOverlayPanel.process(SourceEvent.frequencyChange(null, 0L));
        this.mFrequencyOverlayPanel.process(SourceEvent.sampleRateChange(0.0));
        this.mFrequencyOverlayPanel.setPllTrackingFrequency(0L);
        this.mFrequencyOverlayPanel.setChannelBandwidth(0);
        this.mSquelchLabel.setEnabled(false);
        this.mSquelchValueLabel.setText(NOT_AVAILABLE);
        this.mSquelchValueLabel.setEnabled(false);
        this.mSquelchUpButton.setEnabled(false);
        this.mSquelchDownButton.setEnabled(false);
        this.mSquelchAutoTrackCheckBox.setEnabled(false);
        this.mSquelchAutoTrackCheckBox.setSelected(false);
    }

    @Override
    public void receive(ProcessingChain processingChain) {
        if (this.mProcessingChain != null) {
            this.mProcessingChain.removeSourceEventListener(this.mSourceEventProcessor);
            this.mProcessingChain.removeModule(this.mSampleStreamTapModule);
        }
        this.reset();
        this.mProcessingChain = processingChain;
        if (this.mProcessingChain != null) {
            TunerChannel tunerChannel;
            Channel channel;
            this.mProcessingChain.addSourceEventListener(this.mSourceEventProcessor);
            this.mProcessingChain.addModule(this.mSampleStreamTapModule);
            Source source = this.mProcessingChain.getSource();
            if (source instanceof TunerChannelSource) {
                TunerChannelSource tcs = (TunerChannelSource)source;
                this.mFrequencyOverlayPanel.process(SourceEvent.frequencyChange(null, tcs.getFrequency()));
                this.mFrequencyOverlayPanel.process(SourceEvent.sampleRateChange(tcs.getSampleRate()));
            }
            if ((channel = this.mPlaylistManager.getChannelProcessingManager().getChannel(this.mProcessingChain)) != null && (tunerChannel = channel.getTunerChannel()) != null) {
                this.mFrequencyOverlayPanel.setChannelBandwidth(tunerChannel.getBandwidth());
            }
        }
        this.updateFFTProcessing();
        this.broadcast(SourceEvent.requestCurrentSquelchAutoTrack());
        this.broadcast(SourceEvent.requestCurrentSquelchThreshold());
    }

    private class SourceEventProcessor
    implements Listener<SourceEvent> {
        private SourceEventProcessor() {
        }

        @Override
        public void receive(SourceEvent sourceEvent) {
            switch (sourceEvent.getEvent()) {
                case NOTIFICATION_CHANNEL_POWER: {
                    double power = sourceEvent.getValue().doubleValue();
                    double peak = ChannelPowerPanel.this.mPeakMonitor.process(power);
                    EventQueue.invokeLater(() -> {
                        ChannelPowerPanel.this.mPowerMeter.setPower(power);
                        ChannelPowerPanel.this.mPowerLabel.setText(DECIMAL_FORMAT.format(power));
                        ChannelPowerPanel.this.mPowerMeter.setPeak(peak);
                        ChannelPowerPanel.this.mPeakLabel.setText(DECIMAL_FORMAT.format(peak));
                    });
                    break;
                }
                case NOTIFICATION_SQUELCH_THRESHOLD: {
                    double threshold;
                    ChannelPowerPanel.this.mSquelchThreshold = threshold = sourceEvent.getValue().doubleValue();
                    ChannelPowerPanel.this.setConfigSquelchThreshold((int)threshold);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChannelPowerPanel.this.mPowerMeter.setSquelchThreshold(threshold);
                            ChannelPowerPanel.this.mSquelchLabel.setEnabled(true);
                            ChannelPowerPanel.this.mSquelchValueLabel.setEnabled(true);
                            ChannelPowerPanel.this.mSquelchValueLabel.setText(DECIMAL_FORMAT.format(threshold));
                            ChannelPowerPanel.this.mSquelchDownButton.setEnabled(true);
                            ChannelPowerPanel.this.mSquelchUpButton.setEnabled(true);
                        }
                    });
                    break;
                }
                case NOTIFICATION_PLL_FREQUENCY: {
                    if (!sourceEvent.hasValue()) break;
                    ChannelPowerPanel.this.updatePllFrequency(sourceEvent.getValue().longValue());
                    break;
                }
                case NOTIFICATION_SQUELCH_AUTO_TRACK: {
                    boolean autoTrack = sourceEvent.getValue().intValue() == 1;
                    ChannelPowerPanel.this.setConfigSquelchAutoTrack(autoTrack);
                    EventQueue.invokeLater(() -> {
                        ChannelPowerPanel.this.mSquelchAutoTrackCheckBox.setSelected(autoTrack);
                        ChannelPowerPanel.this.mSquelchAutoTrackCheckBox.setEnabled(true);
                    });
                }
            }
        }
    }

    public class ResizeListener
    implements ComponentListener {
        @Override
        public void componentResized(ComponentEvent e) {
            Component c = e.getComponent();
            ChannelPowerPanel.this.mSpectrumPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
            ChannelPowerPanel.this.mFrequencyOverlayPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }

    public class MouseEventProcessor
    extends MouseInputAdapter {
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            this.update(event);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        private void update(MouseEvent event) {
            ChannelPowerPanel.this.mFrequencyOverlayPanel.setCursorLocation(event.getPoint());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ChannelPowerPanel.this.mFrequencyOverlayPanel.setCursorVisible(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ChannelPowerPanel.this.mFrequencyOverlayPanel.setCursorVisible(false);
        }
    }
}

