/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.source;

import io.github.dsheirer.gui.playlist.source.FrequencyField;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyEditor
extends SourceConfigurationEditor<SourceConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(FrequencyEditor.class);
    private static final String NONE = "(none)           ";
    private TunerManager mTunerManager;
    private FrequencyBox mPrimaryFrequencyBox;
    private ObservableList<FrequencyBox> mFrequencyBoxes = FXCollections.observableArrayList();
    private ComboBox<String> mPreferredTunerComboBox;
    private VBox mFrequencyBoxContainer;
    private Spinner<Integer> mChannelRotationDelaySpinner;
    private boolean mAllowMultipleFrequencies = false;
    private int mFrequencyRotationDefault = 500;
    private int mFrequencyRotationMinimum = 200;
    private int mFrequencyRotationMaximum = 2000;

    public FrequencyEditor(TunerManager tunerManager, int minRotationDelay, int maxRotationDelay, int defaultRotationDelay) {
        this.mTunerManager = tunerManager;
        this.mAllowMultipleFrequencies = true;
        this.mFrequencyRotationMinimum = minRotationDelay;
        this.mFrequencyRotationMaximum = maxRotationDelay;
        this.mFrequencyRotationDefault = defaultRotationDelay;
        this.init();
    }

    public FrequencyEditor(TunerManager tunerManager) {
        this.mTunerManager = tunerManager;
        this.init();
    }

    private void init() {
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        Label label = new Label(this.mAllowMultipleFrequencies ? "Frequencies (MHz)" : "Frequency (MHz)");
        label.setAlignment(Pos.BASELINE_RIGHT);
        hBox.getChildren().addAll((Object[])new Node[]{label, this.getFrequencyBoxContainer()});
        Label preferredTunerLabel = new Label("Preferred Tuner");
        HBox tunerBox = new HBox();
        tunerBox.setAlignment(Pos.CENTER_LEFT);
        tunerBox.setSpacing(10.0);
        tunerBox.getChildren().addAll((Object[])new Node[]{preferredTunerLabel, this.getPreferredTunerComboBox()});
        VBox vbox = new VBox();
        vbox.setSpacing(10.0);
        vbox.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
        if (this.mAllowMultipleFrequencies) {
            Label frequencyRotationLabel = new Label("Frequency Rotation Delay (ms)");
            HBox frequencyBox = new HBox();
            frequencyBox.setAlignment(Pos.CENTER_LEFT);
            frequencyBox.setSpacing(10.0);
            frequencyBox.getChildren().addAll((Object[])new Node[]{frequencyRotationLabel, this.getFrequencyRotationDelaySpinner()});
            this.getFrequencyRotationDelaySpinner().disableProperty().bind((ObservableValue)Bindings.greaterThan((int)2, (ObservableNumberValue)Bindings.size(this.mFrequencyBoxes)));
            vbox.getChildren().addAll((Object[])new Node[]{tunerBox, frequencyBox});
        } else {
            vbox.getChildren().addAll((Object[])new Node[]{tunerBox});
        }
        hBox.getChildren().add((Object)vbox);
        this.setAlignment(Pos.TOP_LEFT);
        this.getChildren().add((Object)hBox);
    }

    @Override
    public void disable(boolean disable) {
        for (FrequencyBox frequencyBox : this.mFrequencyBoxes) {
            frequencyBox.disable(disable);
        }
        this.getPreferredTunerComboBox().setDisable(disable);
    }

    @Override
    public void save() {
        List<Long> frequencies;
        String preferredTuner = (String)this.getPreferredTunerComboBox().getSelectionModel().getSelectedItem();
        if (preferredTuner != null && preferredTuner.contentEquals(NONE)) {
            preferredTuner = null;
        }
        if ((frequencies = this.getFrequencies()).size() <= 1) {
            SourceConfigTuner sourceConfigTuner = null;
            sourceConfigTuner = this.getSourceConfiguration() instanceof SourceConfigTuner ? (SourceConfigTuner)this.getSourceConfiguration() : new SourceConfigTuner();
            if (frequencies.size() == 1) {
                sourceConfigTuner.setFrequency(frequencies.get(0));
            } else {
                sourceConfigTuner.setFrequency(0L);
            }
            sourceConfigTuner.setPreferredTuner(preferredTuner);
            this.setSourceConfiguration(sourceConfigTuner);
        } else {
            SourceConfigTunerMultipleFrequency sourceConfigMulti = null;
            sourceConfigMulti = this.getSourceConfiguration() instanceof SourceConfigTunerMultipleFrequency ? (SourceConfigTunerMultipleFrequency)this.getSourceConfiguration() : new SourceConfigTunerMultipleFrequency();
            sourceConfigMulti.setFrequencies(frequencies);
            sourceConfigMulti.setPreferredTuner(preferredTuner);
            sourceConfigMulti.setFrequencyRotationDelay((Integer)this.getFrequencyRotationDelaySpinner().getValue());
            this.setSourceConfiguration(sourceConfigMulti);
        }
    }

    @Override
    public void setSourceConfiguration(SourceConfiguration sourceConfiguration) {
        super.setSourceConfiguration(sourceConfiguration);
        String preferredTuner = null;
        this.disable(sourceConfiguration == null);
        this.getFrequencyRotationDelaySpinner().getValueFactory().setValue((Object)200);
        if (sourceConfiguration == null) {
            this.setFrequencies(Collections.emptyList());
            this.getPreferredTunerComboBox().setDisable(true);
            this.getPreferredTunerComboBox().getSelectionModel().select(null);
        } else if (sourceConfiguration instanceof SourceConfigTuner) {
            SourceConfigTuner sourceConfigTuner = (SourceConfigTuner)sourceConfiguration;
            this.setFrequency(sourceConfigTuner.getFrequency());
            preferredTuner = sourceConfigTuner.getPreferredTuner();
        } else if (sourceConfiguration instanceof SourceConfigTunerMultipleFrequency) {
            SourceConfigTunerMultipleFrequency sourceMulti = (SourceConfigTunerMultipleFrequency)sourceConfiguration;
            this.setFrequencies(sourceMulti.getFrequencies());
            preferredTuner = sourceMulti.getPreferredTuner();
            int rotationDelay = sourceMulti.getFrequencyRotationDelay();
            if (rotationDelay < this.mFrequencyRotationMinimum) {
                rotationDelay = this.mFrequencyRotationMinimum;
                sourceMulti.setFrequencyRotationDelay(rotationDelay);
            }
            if (rotationDelay > this.mFrequencyRotationMaximum) {
                rotationDelay = this.mFrequencyRotationMaximum;
                sourceMulti.setFrequencyRotationDelay(rotationDelay);
            }
            this.getFrequencyRotationDelaySpinner().getValueFactory().setValue((Object)rotationDelay);
        } else {
            this.setFrequencies(Collections.emptyList());
            this.getPreferredTunerComboBox().setDisable(false);
            this.getPreferredTunerComboBox().getSelectionModel().select(null);
        }
        this.updatePreferredTuners();
        if (preferredTuner != null) {
            if (!this.getPreferredTunerComboBox().getItems().contains((Object)preferredTuner)) {
                this.getPreferredTunerComboBox().getItems().add((Object)preferredTuner);
            }
            this.getPreferredTunerComboBox().getSelectionModel().select((Object)preferredTuner);
        } else {
            this.getPreferredTunerComboBox().getSelectionModel().select((Object)NONE);
        }
        this.modifiedProperty().set(false);
    }

    private Spinner<Integer> getFrequencyRotationDelaySpinner() {
        if (this.mChannelRotationDelaySpinner == null) {
            this.mChannelRotationDelaySpinner = new Spinner();
            this.mChannelRotationDelaySpinner.setTooltip(new Tooltip("Delay on each frequency before rotating to next when seeking to next active channel frequency"));
            this.mChannelRotationDelaySpinner.getStyleClass().add((Object)"split-arrows-horizontal");
            SpinnerValueFactory.IntegerSpinnerValueFactory svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(this.mFrequencyRotationMinimum, this.mFrequencyRotationMaximum, this.mFrequencyRotationMinimum, 50);
            this.mChannelRotationDelaySpinner.setValueFactory((SpinnerValueFactory)svf);
            this.mChannelRotationDelaySpinner.getValueFactory().valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mChannelRotationDelaySpinner;
    }

    private void updatePreferredTuners() {
        this.getPreferredTunerComboBox().getItems().clear();
        this.getPreferredTunerComboBox().getItems().add((Object)NONE);
        if (this.mTunerManager != null) {
            this.getPreferredTunerComboBox().getItems().addAll(this.mTunerManager.getPreferredTunerNames());
        }
    }

    private FrequencyBox getPrimaryFrequencyBox() {
        if (this.mPrimaryFrequencyBox == null) {
            this.mPrimaryFrequencyBox = new FrequencyBox(this.mAllowMultipleFrequencies ? Buttons.ADD : Buttons.NONE);
            this.mFrequencyBoxes.add((Object)this.mPrimaryFrequencyBox);
        }
        return this.mPrimaryFrequencyBox;
    }

    private ComboBox<String> getPreferredTunerComboBox() {
        if (this.mPreferredTunerComboBox == null) {
            this.mPreferredTunerComboBox = new ComboBox();
            this.mPreferredTunerComboBox.setDisable(true);
            this.mPreferredTunerComboBox.getItems().add((Object)NONE);
            this.mPreferredTunerComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mPreferredTunerComboBox;
    }

    private VBox getFrequencyBoxContainer() {
        if (this.mFrequencyBoxContainer == null) {
            this.mFrequencyBoxContainer = new VBox();
            this.mFrequencyBoxContainer.setSpacing(5.0);
            this.mFrequencyBoxContainer.getChildren().addAll((Object[])new Node[]{this.getPrimaryFrequencyBox()});
        }
        return this.mFrequencyBoxContainer;
    }

    public void setFrequencies(List<Long> frequencies) {
        this.resetFrequencyBoxes();
        for (int x = 0; x < frequencies.size(); ++x) {
            if (x == 0) {
                this.getPrimaryFrequencyBox().getFrequencyField().set(frequencies.get(0));
                continue;
            }
            FrequencyBox frequencyBox = this.addFrequencyBox();
            frequencyBox.getFrequencyField().set(frequencies.get(x));
        }
    }

    public void setFrequency(Long frequency) {
        this.resetFrequencyBoxes();
        this.getPrimaryFrequencyBox().getFrequencyField().set(frequency);
    }

    public List<Long> getFrequencies() {
        ArrayList<Long> frequencies = new ArrayList<Long>();
        for (FrequencyBox frequencyBox : this.mFrequencyBoxes) {
            long frequency = frequencyBox.getFrequencyField().get();
            if (frequency <= 0L) continue;
            frequencies.add(frequency);
        }
        return frequencies;
    }

    private void resetFrequencyBoxes() {
        this.getFrequencyBoxContainer().getChildren().clear();
        this.mFrequencyBoxes.clear();
        this.getFrequencyBoxContainer().getChildren().add((Object)this.getPrimaryFrequencyBox());
        this.mFrequencyBoxes.add((Object)this.getPrimaryFrequencyBox());
        this.getPrimaryFrequencyBox().getFrequencyField().set(0L);
    }

    private FrequencyBox addFrequencyBox() {
        FrequencyBox frequencyBox = new FrequencyBox(Buttons.REMOVE);
        frequencyBox.disable(false);
        this.mFrequencyBoxes.add((Object)frequencyBox);
        this.getFrequencyBoxContainer().getChildren().add((Object)frequencyBox);
        return frequencyBox;
    }

    private void removeFrequencyBox(FrequencyBox toRemove) {
        this.getFrequencyBoxContainer().getChildren().remove((Object)toRemove);
        this.mFrequencyBoxes.remove((Object)toRemove);
        this.modifiedProperty().set(true);
    }

    public class FrequencyBox
    extends HBox {
        private FrequencyField mFrequencyField;
        private Button mAddButton;
        private Button mRemoveButton;

        public FrequencyBox(Buttons buttons) {
            this.setSpacing(10.0);
            this.getChildren().add((Object)this.getFrequencyField());
            switch (buttons) {
                case ADD: {
                    this.getChildren().add((Object)this.getAddButton());
                    break;
                }
                case REMOVE: {
                    this.getChildren().add((Object)this.getRemoveButton());
                }
            }
        }

        public void disable(boolean disable) {
            this.getFrequencyField().setDisable(disable);
            this.getAddButton().setDisable(disable);
            this.getRemoveButton().setDisable(disable);
        }

        public FrequencyField getFrequencyField() {
            if (this.mFrequencyField == null) {
                this.mFrequencyField = new FrequencyField();
                this.mFrequencyField.setDisable(true);
                this.mFrequencyField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                        FrequencyEditor.this.modifiedProperty().set(true);
                    }
                });
            }
            return this.mFrequencyField;
        }

        private Button getAddButton() {
            if (this.mAddButton == null) {
                this.mAddButton = new Button("Add");
                this.mAddButton.setDisable(true);
                this.mAddButton.setOnAction(event -> FrequencyEditor.this.addFrequencyBox());
            }
            return this.mAddButton;
        }

        private Button getRemoveButton() {
            if (this.mRemoveButton == null) {
                this.mRemoveButton = new Button("Remove");
                this.mRemoveButton.setDisable(true);
                this.mRemoveButton.setOnAction(event -> {
                    Alert confirm = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to remove this frequency?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    confirm.setTitle("Remove Frequency");
                    confirm.setHeaderText("Remove frequency?");
                    confirm.initOwner(((Node)event.getTarget()).getScene().getWindow());
                    confirm.showAndWait().ifPresent(buttonType -> {
                        if (buttonType == ButtonType.YES) {
                            FrequencyEditor.this.removeFrequencyBox(this);
                        }
                    });
                });
            }
            return this.mRemoveButton;
        }
    }

    public static enum Buttons {
        ADD,
        REMOVE,
        NONE;

    }
}

