/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.alias.ViewAliasRequest;
import io.github.dsheirer.gui.playlist.radioreference.FlashAliasListComboBoxRequest;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceDecoder;
import io.github.dsheirer.gui.playlist.radioreference.TalkgroupEncryption;
import io.github.dsheirer.gui.playlist.radioreference.TalkgroupMode;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.type.System;
import io.github.dsheirer.rrapi.type.Talkgroup;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkgroupEditor
extends GridPane {
    private static final Logger mLog = LoggerFactory.getLogger(TalkgroupEditor.class);
    private UserPreferences mUserPreferences;
    private PlaylistManager mPlaylistManager;
    private TextField mAlphaTagTextField;
    private TextField mDescriptionTextField;
    private TextField mTalkgroupTextField;
    private TextField mModeTextField;
    private Button mEditAliasButton;
    private TextField mAliasNameTextField;
    private TextField mAliasGroupTextField;
    private Button mCreateAliasButton;
    private Label mCreateLabel;
    private Label mNameLabel;
    private Label mGroupLabel;
    private Label mNotSupportedLabel;
    private RadioReferenceDecoder mRadioReferenceDecoder;
    private String mAliasListName;
    private System mSystem;
    private Talkgroup mTalkgroup;
    private Alias mAlias;
    private boolean mSetEncryptedDoNotMonitor;

    public TalkgroupEditor(UserPreferences userPreferences, PlaylistManager playlistManager) {
        this.mUserPreferences = userPreferences;
        this.mPlaylistManager = playlistManager;
        this.setHgap(5.0);
        this.setVgap(5.0);
        int row = 0;
        Label radioReferenceLabel = new Label("Radio Reference Talkgroup Details");
        GridPane.setConstraints((Node)radioReferenceLabel, (int)1, (int)row);
        GridPane.setHalignment((Node)radioReferenceLabel, (HPos)HPos.LEFT);
        this.getChildren().add((Object)radioReferenceLabel);
        Label talkgroupLabel = new Label("Talkgroup");
        GridPane.setConstraints((Node)talkgroupLabel, (int)0, (int)(++row));
        GridPane.setHalignment((Node)talkgroupLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)talkgroupLabel);
        GridPane.setHgrow((Node)this.getTalkgroupTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getTalkgroupTextField(), (int)1, (int)row);
        this.getChildren().add((Object)this.getTalkgroupTextField());
        Label alphaLabel = new Label("Alpha Tag");
        GridPane.setConstraints((Node)alphaLabel, (int)0, (int)(++row));
        GridPane.setHalignment((Node)alphaLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)alphaLabel);
        GridPane.setHgrow((Node)this.getAlphaTagTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getAlphaTagTextField(), (int)1, (int)row);
        this.getChildren().add((Object)this.getAlphaTagTextField());
        Label descriptionLabel = new Label("Description");
        GridPane.setConstraints((Node)descriptionLabel, (int)0, (int)(++row));
        GridPane.setHalignment((Node)descriptionLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)descriptionLabel);
        GridPane.setHgrow((Node)this.getDescriptionTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getDescriptionTextField(), (int)1, (int)row);
        this.getChildren().add((Object)this.getDescriptionTextField());
        Label modeLabel = new Label("Mode");
        GridPane.setConstraints((Node)modeLabel, (int)0, (int)(++row));
        GridPane.setHalignment((Node)modeLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)modeLabel);
        GridPane.setHgrow((Node)this.getModeTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getModeTextField(), (int)1, (int)row);
        this.getChildren().add((Object)this.getModeTextField());
        Separator separator2 = new Separator(Orientation.HORIZONTAL);
        GridPane.setConstraints((Node)separator2, (int)0, (int)(++row), (int)2, (int)1);
        this.getChildren().add((Object)separator2);
        GridPane.setConstraints((Node)this.getEditAliasButton(), (int)1, (int)(++row));
        this.getChildren().add((Object)this.getEditAliasButton());
        GridPane.setConstraints((Node)this.getCreateLabel(), (int)1, (int)row);
        GridPane.setHalignment((Node)this.getCreateLabel(), (HPos)HPos.LEFT);
        this.getChildren().add((Object)this.getCreateLabel());
        GridPane.setConstraints((Node)this.getNotSupportedLabel(), (int)1, (int)row);
        GridPane.setHalignment((Node)this.getNotSupportedLabel(), (HPos)HPos.LEFT);
        this.getChildren().add((Object)this.getNotSupportedLabel());
        GridPane.setConstraints((Node)this.getNameLabel(), (int)0, (int)(++row));
        GridPane.setHalignment((Node)this.getNameLabel(), (HPos)HPos.RIGHT);
        this.getChildren().add((Object)this.getNameLabel());
        GridPane.setConstraints((Node)this.getAliasNameTextField(), (int)1, (int)row);
        this.getChildren().add((Object)this.getAliasNameTextField());
        GridPane.setConstraints((Node)this.getGroupLabel(), (int)0, (int)(++row));
        GridPane.setHalignment((Node)this.getGroupLabel(), (HPos)HPos.RIGHT);
        this.getChildren().add((Object)this.getGroupLabel());
        GridPane.setConstraints((Node)this.getAliasGroupTextField(), (int)1, (int)row);
        this.getChildren().add((Object)this.getAliasGroupTextField());
        GridPane.setConstraints((Node)this.getCreateAliasButton(), (int)1, (int)(++row));
        this.getChildren().add((Object)this.getCreateAliasButton());
    }

    public void setTalkgroup(Talkgroup talkgroup, System system, RadioReferenceDecoder decoder, Alias alias, String aliasListName, String group, boolean setEncryptedDoNotMonitor) {
        this.mRadioReferenceDecoder = decoder;
        this.mTalkgroup = talkgroup;
        this.mSystem = system;
        this.mAliasListName = aliasListName;
        this.mAlias = alias;
        this.mSetEncryptedDoNotMonitor = setEncryptedDoNotMonitor;
        if (talkgroup != null) {
            this.getTalkgroupTextField().setText(decoder.format(talkgroup, system));
            this.getAlphaTagTextField().setText(talkgroup.getAlphaTag());
            this.getAliasNameTextField().setText(talkgroup.getAlphaTag());
            this.getDescriptionTextField().setText(talkgroup.getDescription());
            TalkgroupMode talkgroupMode = TalkgroupMode.lookup(talkgroup.getMode());
            TalkgroupEncryption talkgroupEncryption = TalkgroupEncryption.lookup(talkgroup.getEncryptionState());
            this.getModeTextField().setText(talkgroupMode.toString() + (String)(talkgroupEncryption != TalkgroupEncryption.UNENCRYPTED ? " - " + talkgroupEncryption.toString() : ""));
        } else {
            this.getTalkgroupTextField().setText(null);
            this.getAlphaTagTextField().setText(null);
            this.getDescriptionTextField().setText(null);
            this.getModeTextField().setText(null);
            this.getAliasNameTextField().setText(null);
        }
        boolean supported = decoder.hasSupportedProtocol(system);
        this.getEditAliasButton().setVisible(this.mAlias != null);
        this.getCreateAliasButton().setVisible(this.mTalkgroup != null && this.mAlias == null && supported);
        this.getNameLabel().setVisible(this.mTalkgroup != null && this.mAlias == null && supported);
        this.getAliasNameTextField().setVisible(this.mTalkgroup != null && this.mAlias == null && supported);
        this.getGroupLabel().setVisible(this.mTalkgroup != null && this.mAlias == null && supported);
        this.getAliasGroupTextField().setText(group);
        this.getAliasGroupTextField().setVisible(this.mTalkgroup != null && this.mAlias == null && supported);
        this.getCreateLabel().setVisible(this.mTalkgroup != null && this.mAlias == null && supported);
        this.getNotSupportedLabel().setVisible(this.mTalkgroup != null && !supported);
    }

    private Label getNotSupportedLabel() {
        if (this.mNotSupportedLabel == null) {
            this.mNotSupportedLabel = new Label("Protocol Not Supported");
            this.mNotSupportedLabel.setVisible(false);
        }
        return this.mNotSupportedLabel;
    }

    private Label getCreateLabel() {
        if (this.mCreateLabel == null) {
            this.mCreateLabel = new Label("Create Talkgroup Alias");
            this.mCreateLabel.setVisible(false);
        }
        return this.mCreateLabel;
    }

    private Label getNameLabel() {
        if (this.mNameLabel == null) {
            this.mNameLabel = new Label("Name");
            this.mNameLabel.setVisible(false);
        }
        return this.mNameLabel;
    }

    private Label getGroupLabel() {
        if (this.mGroupLabel == null) {
            this.mGroupLabel = new Label("Group");
            this.mGroupLabel.setVisible(false);
        }
        return this.mGroupLabel;
    }

    private TextField getAliasNameTextField() {
        if (this.mAliasNameTextField == null) {
            this.mAliasNameTextField = new TextField();
            this.mAliasNameTextField.setMaxWidth(Double.MAX_VALUE);
            this.mAliasNameTextField.setVisible(false);
        }
        return this.mAliasNameTextField;
    }

    private TextField getAliasGroupTextField() {
        if (this.mAliasGroupTextField == null) {
            this.mAliasGroupTextField = new TextField();
            this.mAliasGroupTextField.setMaxWidth(Double.MAX_VALUE);
            this.mAliasGroupTextField.setVisible(false);
        }
        return this.mAliasGroupTextField;
    }

    private Button getCreateAliasButton() {
        if (this.mCreateAliasButton == null) {
            this.mCreateAliasButton = new Button("Create Talkgroup Alias");
            this.mCreateAliasButton.setVisible(false);
            this.mCreateAliasButton.setOnAction(event -> {
                if (this.mAliasListName == null) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "Please select an Alias List", new ButtonType[]{ButtonType.OK});
                    alert.setTitle("Alias List Required");
                    alert.setHeaderText("An alias list is required to create aliases");
                    alert.initOwner(this.getCreateAliasButton().getScene().getWindow());
                    alert.showAndWait();
                    MyEventBus.getGlobalEventBus().post((Object)new FlashAliasListComboBoxRequest());
                } else if (this.mRadioReferenceDecoder != null && this.mTalkgroup != null && this.mSystem != null) {
                    Alias alias = this.mRadioReferenceDecoder.createAlias(this.mTalkgroup, this.mSystem, this.mAliasListName, this.getAliasGroupTextField().getText());
                    alias.setName(this.getAliasNameTextField().getText());
                    if (this.mSetEncryptedDoNotMonitor && TalkgroupEncryption.lookup(this.mTalkgroup.getEncryptionState()) == TalkgroupEncryption.FULL) {
                        int priority = -1;
                        alias.addAliasID(new io.github.dsheirer.alias.id.priority.Priority(priority));
                    }
                    this.mPlaylistManager.getAliasModel().addAlias(alias);
                }
            });
        }
        return this.mCreateAliasButton;
    }

    private Button getEditAliasButton() {
        if (this.mEditAliasButton == null) {
            this.mEditAliasButton = new Button("View/Edit Alias");
            this.mEditAliasButton.setVisible(false);
            this.mEditAliasButton.setOnAction(event -> {
                if (this.mAlias != null) {
                    MyEventBus.getGlobalEventBus().post((Object)new ViewAliasRequest(this.mAlias));
                }
            });
        }
        return this.mEditAliasButton;
    }

    public TextField getAlphaTagTextField() {
        if (this.mAlphaTagTextField == null) {
            this.mAlphaTagTextField = new TextField();
            this.mAlphaTagTextField.setMaxWidth(Double.MAX_VALUE);
            this.mAlphaTagTextField.setDisable(true);
        }
        return this.mAlphaTagTextField;
    }

    public TextField getDescriptionTextField() {
        if (this.mDescriptionTextField == null) {
            this.mDescriptionTextField = new TextField();
            this.mDescriptionTextField.setMaxWidth(Double.MAX_VALUE);
            this.mDescriptionTextField.setDisable(true);
        }
        return this.mDescriptionTextField;
    }

    public TextField getTalkgroupTextField() {
        if (this.mTalkgroupTextField == null) {
            this.mTalkgroupTextField = new TextField();
            this.mTalkgroupTextField.setMaxWidth(Double.MAX_VALUE);
            this.mTalkgroupTextField.setDisable(true);
        }
        return this.mTalkgroupTextField;
    }

    public TextField getModeTextField() {
        if (this.mModeTextField == null) {
            this.mModeTextField = new TextField();
            this.mModeTextField.setMaxWidth(Double.MAX_VALUE);
            this.mModeTextField.setPrefWidth(25.0);
            this.mModeTextField.setDisable(true);
        }
        return this.mModeTextField;
    }
}

