/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.priority.Priority;
import io.github.dsheirer.alias.id.talkgroup.Talkgroup;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupRange;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.control.MaxLengthUnaryOperator;
import io.github.dsheirer.gui.playlist.radioreference.FlashAliasListComboBoxRequest;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceDecoder;
import io.github.dsheirer.gui.playlist.radioreference.TalkgroupEditor;
import io.github.dsheirer.gui.playlist.radioreference.TalkgroupEncryption;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.rrapi.type.System;
import io.github.dsheirer.rrapi.type.TalkgroupCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.animation.RotateTransition;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.TextFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTalkgroupSelectionEditor
extends GridPane {
    private static final Logger mLog = LoggerFactory.getLogger(SystemTalkgroupSelectionEditor.class);
    private final TalkgroupCategory ALL_TALKGROUPS = new TalkgroupCategory();
    private UserPreferences mUserPreferences;
    private PlaylistManager mPlaylistManager;
    private TableView<AliasedTalkgroup> mTalkgroupTableView;
    private ComboBox<TalkgroupCategory> mTalkgroupCategoryComboBox;
    private TextField mSearchField;
    private TalkgroupEditor mTalkgroupEditor;
    private ComboBox<String> mAliasListNameComboBox;
    private Button mNewAliasListButton;
    private TalkgroupFilter mTalkgroupFilter = new TalkgroupFilter(this);
    private FilteredList<AliasedTalkgroup> mTalkgroupFilteredList;
    private ObservableList<AliasedTalkgroup> mTalkgroupList = FXCollections.observableArrayList();
    private System mCurrentSystem;
    private RadioReferenceDecoder mRadioReferenceDecoder;
    private AliasList mAliasList;
    private AliasListChangeListener mAliasListChangeListener = new AliasListChangeListener();
    private Button mImportAllTalkgroupsButton;
    private Label mPlaceholderLabel;
    private ProgressIndicator mProgressIndicator;
    private CheckBox mEncryptedAsDoNotMonitorCheckBox;

    public SystemTalkgroupSelectionEditor(UserPreferences userPreferences, PlaylistManager playlistManager) {
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.mUserPreferences = userPreferences;
        this.mPlaylistManager = playlistManager;
        this.ALL_TALKGROUPS.setName("(All Talkgroups)");
        this.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        this.setVgap(10.0);
        this.setHgap(10.0);
        this.setMaxHeight(Double.MAX_VALUE);
        int row = 0;
        ColumnConstraints column1 = new ColumnConstraints();
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setPercentWidth(40.0);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        HBox listBox = new HBox();
        listBox.setSpacing(5.0);
        listBox.setAlignment(Pos.CENTER);
        Label importLabel = new Label("Import To Alias List:");
        listBox.getChildren().addAll((Object[])new Node[]{importLabel, this.getAliasListNameComboBox(), this.getNewAliasListButton()});
        GridPane.setConstraints((Node)listBox, (int)0, (int)row);
        this.getChildren().add((Object)listBox);
        GridPane.setConstraints((Node)this.getEncryptedAsDoNotMonitorCheckBox(), (int)1, (int)row);
        GridPane.setHalignment((Node)this.getEncryptedAsDoNotMonitorCheckBox(), (HPos)HPos.CENTER);
        this.getChildren().add((Object)this.getEncryptedAsDoNotMonitorCheckBox());
        HBox searchBox = new HBox();
        searchBox.setSpacing(5.0);
        searchBox.setAlignment(Pos.CENTER);
        searchBox.getChildren().addAll((Object[])new Node[]{new Label("Search"), this.getSearchField()});
        GridPane.setConstraints((Node)searchBox, (int)0, (int)(++row));
        this.getChildren().add((Object)searchBox);
        GridPane.setHalignment((Node)this.getImportAllTalkgroupsButton(), (HPos)HPos.CENTER);
        GridPane.setConstraints((Node)this.getImportAllTalkgroupsButton(), (int)1, (int)row);
        this.getChildren().add((Object)this.getImportAllTalkgroupsButton());
        HBox categoryBox = new HBox();
        categoryBox.setAlignment(Pos.CENTER_LEFT);
        categoryBox.setSpacing(5.0);
        HBox.setHgrow(this.getTalkgroupCategoryComboBox(), (javafx.scene.layout.Priority)javafx.scene.layout.Priority.ALWAYS);
        categoryBox.getChildren().addAll((Object[])new Node[]{new Label("Category"), this.getTalkgroupCategoryComboBox()});
        GridPane.setHgrow((Node)categoryBox, (javafx.scene.layout.Priority)javafx.scene.layout.Priority.ALWAYS);
        GridPane.setConstraints((Node)categoryBox, (int)0, (int)(++row));
        this.getChildren().add((Object)categoryBox);
        Separator separator = new Separator(Orientation.HORIZONTAL);
        GridPane.setHgrow((Node)separator, (javafx.scene.layout.Priority)javafx.scene.layout.Priority.ALWAYS);
        GridPane.setConstraints((Node)separator, (int)1, (int)row);
        this.getChildren().add((Object)separator);
        GridPane.setHgrow(this.getTalkgroupTableView(), (javafx.scene.layout.Priority)javafx.scene.layout.Priority.ALWAYS);
        GridPane.setVgrow(this.getTalkgroupTableView(), (javafx.scene.layout.Priority)javafx.scene.layout.Priority.ALWAYS);
        GridPane.setConstraints(this.getTalkgroupTableView(), (int)0, (int)(++row));
        this.getChildren().add(this.getTalkgroupTableView());
        GridPane.setHgrow((Node)this.getTalkgroupEditor(), (javafx.scene.layout.Priority)javafx.scene.layout.Priority.ALWAYS);
        GridPane.setVgrow((Node)this.getTalkgroupEditor(), (javafx.scene.layout.Priority)javafx.scene.layout.Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getTalkgroupEditor(), (int)1, (int)row);
        this.getChildren().add((Object)this.getTalkgroupEditor());
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
    }

    public void clear() {
        this.mTalkgroupList.clear();
        this.getTalkgroupCategoryComboBox().getItems().clear();
    }

    public void clearAndSetLoading() {
        this.clear();
        this.setLoading(true);
    }

    private CheckBox getEncryptedAsDoNotMonitorCheckBox() {
        if (this.mEncryptedAsDoNotMonitorCheckBox == null) {
            this.mEncryptedAsDoNotMonitorCheckBox = new CheckBox("Set Encrypted Talkgroups To Muted");
            this.mEncryptedAsDoNotMonitorCheckBox.setDisable(true);
            this.mEncryptedAsDoNotMonitorCheckBox.selectedProperty().set(this.mUserPreferences.getRadioReferencePreference().isEncryptedTalkgroupDoNotMonitor());
            this.mEncryptedAsDoNotMonitorCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.mUserPreferences.getRadioReferencePreference().setEncryptedTalkgroupDoNotMonitor(this.mEncryptedAsDoNotMonitorCheckBox.isSelected()));
        }
        return this.mEncryptedAsDoNotMonitorCheckBox;
    }

    private void setLoading(boolean loading) {
        this.getTalkgroupTableView().setPlaceholder((Node)(loading ? this.getProgressIndicator() : this.getPlaceholderLabel()));
    }

    private ProgressIndicator getProgressIndicator() {
        if (this.mProgressIndicator == null) {
            this.mProgressIndicator = new ProgressIndicator();
            this.mProgressIndicator.setProgress(-1.0);
        }
        return this.mProgressIndicator;
    }

    private Label getPlaceholderLabel() {
        if (this.mPlaceholderLabel == null) {
            this.mPlaceholderLabel = new Label("No Talkgroups Available");
        }
        return this.mPlaceholderLabel;
    }

    private void updateFilter() {
        this.mTalkgroupFilter.setFilterText(this.getSearchField().getText());
        TalkgroupCategory category = (TalkgroupCategory)this.getTalkgroupCategoryComboBox().getSelectionModel().getSelectedItem();
        if (category == this.ALL_TALKGROUPS) {
            this.mTalkgroupFilter.setCategory(null);
        } else {
            this.mTalkgroupFilter.setCategory(category != null ? Integer.valueOf(category.getTalkgroupCategoryId()) : null);
        }
        this.mTalkgroupFilteredList.setPredicate(null);
        this.mTalkgroupFilteredList.setPredicate((Predicate)this.mTalkgroupFilter);
    }

    public void setSystem(System system, List<io.github.dsheirer.rrapi.type.Talkgroup> talkgroups, List<TalkgroupCategory> categories, RadioReferenceDecoder decoder) {
        this.mCurrentSystem = system;
        this.mRadioReferenceDecoder = decoder;
        this.clearAndSetLoading();
        if (talkgroups != null && !talkgroups.isEmpty()) {
            Collections.sort(talkgroups, Comparator.comparingInt(io.github.dsheirer.rrapi.type.Talkgroup::getDecimalValue));
            for (io.github.dsheirer.rrapi.type.Talkgroup talkgroup : talkgroups) {
                this.mTalkgroupList.add((Object)new AliasedTalkgroup(talkgroup, this.getAlias(talkgroup)));
            }
            if (categories.size() > 0) {
                Collections.sort(categories, (o1, o2) -> o1.getName().compareTo(o2.getName()));
                categories.add(0, this.ALL_TALKGROUPS);
                this.getTalkgroupCategoryComboBox().getItems().addAll(categories);
                this.getTalkgroupCategoryComboBox().getSelectionModel().select((Object)this.ALL_TALKGROUPS);
            }
        }
        Protocol protocol = this.getRadioReferenceDecoder().getProtocol(this.getCurrentSystem());
        boolean supported = this.getRadioReferenceDecoder().hasSupportedProtocol(this.getCurrentSystem());
        this.getImportAllTalkgroupsButton().setDisable(!supported);
        this.getEncryptedAsDoNotMonitorCheckBox().setDisable(!supported);
        this.setLoading(false);
    }

    @Subscribe
    public void process(FlashAliasListComboBoxRequest request) {
        this.flashAliasListComboBox();
    }

    private void flashAliasListComboBox() {
        RotateTransition rt = new RotateTransition(Duration.millis((double)150.0), this.getAliasListNameComboBox());
        rt.setByAngle(20.0);
        rt.setCycleCount(6);
        rt.setAutoReverse(true);
        rt.play();
    }

    private Button getImportAllTalkgroupsButton() {
        if (this.mImportAllTalkgroupsButton == null) {
            this.mImportAllTalkgroupsButton = new Button("Import All Talkgroups");
            this.mImportAllTalkgroupsButton.setOnAction(event -> {
                String aliasList = (String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem();
                if (aliasList == null) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "Please select an Alias List", new ButtonType[]{ButtonType.OK});
                    alert.setTitle("Alias List Required");
                    alert.setHeaderText("An alias list is required to create aliases");
                    alert.initOwner(this.getImportAllTalkgroupsButton().getScene().getWindow());
                    alert.showAndWait();
                    this.flashAliasListComboBox();
                } else {
                    ArrayList<io.github.dsheirer.rrapi.type.Talkgroup> aliasesToCreate = new ArrayList<io.github.dsheirer.rrapi.type.Talkgroup>();
                    for (AliasedTalkgroup aliasedTalkgroup : this.mTalkgroupFilteredList) {
                        if (aliasedTalkgroup.hasAlias()) continue;
                        aliasesToCreate.add(aliasedTalkgroup.getTalkgroup());
                    }
                    if (!aliasesToCreate.isEmpty()) {
                        this.createAliases(aliasesToCreate);
                    }
                }
            });
        }
        return this.mImportAllTalkgroupsButton;
    }

    public void createAliases(List<io.github.dsheirer.rrapi.type.Talkgroup> talkgroups) {
        ArrayList<Alias> createdAliases = new ArrayList<Alias>();
        for (io.github.dsheirer.rrapi.type.Talkgroup talkgroup : talkgroups) {
            TalkgroupCategory talkgroupCategory = this.getTalkgroupCategory(talkgroup);
            String group = talkgroupCategory != null ? talkgroupCategory.getName() : null;
            Alias alias = this.getRadioReferenceDecoder().createAlias(talkgroup, this.getCurrentSystem(), (String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem(), group);
            if (this.getEncryptedAsDoNotMonitorCheckBox().selectedProperty().get() && TalkgroupEncryption.lookup(talkgroup.getEncryptionState()) == TalkgroupEncryption.FULL) {
                int priority = -1;
                alias.addAliasID(new Priority(priority));
            }
            createdAliases.add(alias);
        }
        this.mPlaylistManager.getAliasModel().addAliases(createdAliases);
    }

    private TalkgroupCategory getTalkgroupCategory(io.github.dsheirer.rrapi.type.Talkgroup talkgroup) {
        if (talkgroup != null) {
            for (TalkgroupCategory category : this.getTalkgroupCategoryComboBox().getItems()) {
                if (category.getTalkgroupCategoryId() != talkgroup.getTalkgroupCategoryId()) continue;
                return category;
            }
        }
        return null;
    }

    private System getCurrentSystem() {
        return this.mCurrentSystem;
    }

    private AliasList getAliasList() {
        if (this.mAliasList == null) {
            this.mAliasList = new AliasList("empty");
        }
        return this.mAliasList;
    }

    private Alias getAlias(io.github.dsheirer.rrapi.type.Talkgroup talkgroup) {
        TalkgroupIdentifier talkgroupIdentifier = this.getRadioReferenceDecoder().getIdentifier(talkgroup, this.getCurrentSystem());
        List<Alias> aliases = this.getAliasList().getAliases(talkgroupIdentifier);
        if (aliases.size() > 0) {
            return aliases.get(0);
        }
        return null;
    }

    private RadioReferenceDecoder getRadioReferenceDecoder() {
        return this.mRadioReferenceDecoder;
    }

    private TalkgroupEditor getTalkgroupEditor() {
        if (this.mTalkgroupEditor == null) {
            this.mTalkgroupEditor = new TalkgroupEditor(this.mUserPreferences, this.mPlaylistManager);
        }
        return this.mTalkgroupEditor;
    }

    private TextField getSearchField() {
        if (this.mSearchField == null) {
            this.mSearchField = TextFields.createClearableTextField();
            this.mSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.updateFilter());
        }
        return this.mSearchField;
    }

    private ComboBox<String> getAliasListNameComboBox() {
        if (this.mAliasListNameComboBox == null) {
            Predicate<String> filterPredicate = s -> !s.contentEquals("(No Alias List)");
            FilteredList filteredChannelList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasListNames(), filterPredicate);
            this.mAliasListNameComboBox = new ComboBox((ObservableList)filteredChannelList);
            this.mAliasListNameComboBox.setPrefWidth(150.0);
            this.mAliasListNameComboBox.setOnAction(event -> this.updateAliasList((String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem()));
            if (this.mAliasListNameComboBox.getItems().size() > 0) {
                this.mAliasListNameComboBox.getSelectionModel().select(0);
            }
            this.updateAliasList((String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem());
        }
        return this.mAliasListNameComboBox;
    }

    private void updateAliasList(String aliasListName) {
        if (this.mAliasList != null) {
            this.mAliasList.aliases().removeListener((ListChangeListener)this.mAliasListChangeListener);
        }
        this.mAliasList = this.mPlaylistManager.getAliasModel().getAliasList(aliasListName);
        if (this.mAliasList != null) {
            this.mAliasList.aliases().addListener((ListChangeListener)this.mAliasListChangeListener);
        }
        for (AliasedTalkgroup item : this.mTalkgroupList) {
            item.setAlias(this.getAlias(item.getTalkgroup()));
        }
    }

    private void updateAlias(Alias alias) {
        AliasedTalkgroup currentlySelected = (AliasedTalkgroup)this.getTalkgroupTableView().getSelectionModel().getSelectedItem();
        if (alias != null) {
            for (AliasID aliasID : alias.getAliasIdentifiers()) {
                if (aliasID instanceof Talkgroup) {
                    int value = ((Talkgroup)aliasID).getValue();
                    for (AliasedTalkgroup aliasedTalkgroup : this.mTalkgroupList) {
                        if (aliasedTalkgroup.getTalkgroupValue() != value) continue;
                        aliasedTalkgroup.setAlias(this.getAlias(aliasedTalkgroup.getTalkgroup()));
                        if (currentlySelected == null || currentlySelected != aliasedTalkgroup) continue;
                        this.getTalkgroupTableView().getSelectionModel().select(null);
                        this.getTalkgroupTableView().getSelectionModel().select((Object)aliasedTalkgroup);
                    }
                    continue;
                }
                if (!(aliasID instanceof TalkgroupRange)) continue;
                TalkgroupRange range = (TalkgroupRange)aliasID;
                for (int x = range.getMinTalkgroup(); x <= range.getMaxTalkgroup(); ++x) {
                    for (AliasedTalkgroup aliasedTalkgroup : this.mTalkgroupList) {
                        if (aliasedTalkgroup.getTalkgroupValue() != x) continue;
                        aliasedTalkgroup.setAlias(this.getAlias(aliasedTalkgroup.getTalkgroup()));
                        if (currentlySelected == null || currentlySelected != aliasedTalkgroup) continue;
                        this.getTalkgroupTableView().getSelectionModel().select(null);
                        this.getTalkgroupTableView().getSelectionModel().select((Object)aliasedTalkgroup);
                    }
                }
            }
        }
    }

    private Button getNewAliasListButton() {
        if (this.mNewAliasListButton == null) {
            this.mNewAliasListButton = new Button("New Alias List");
            this.mNewAliasListButton.setOnAction(event -> {
                TextInputDialog dialog = new TextInputDialog();
                dialog.setTitle("Create New Alias List");
                dialog.setHeaderText("Please enter an alias list name (max 25 chars).");
                dialog.setContentText("Name:");
                dialog.getEditor().setTextFormatter(new TextFormatter((UnaryOperator)new MaxLengthUnaryOperator(25)));
                Optional result = dialog.showAndWait();
                result.ifPresent(s -> {
                    String name = (String)result.get();
                    if (name != null && !name.isEmpty()) {
                        name = name.trim();
                        this.mPlaylistManager.getAliasModel().addAliasList(name);
                        this.getAliasListNameComboBox().getSelectionModel().select((Object)name);
                    }
                });
            });
        }
        return this.mNewAliasListButton;
    }

    private ComboBox<TalkgroupCategory> getTalkgroupCategoryComboBox() {
        if (this.mTalkgroupCategoryComboBox == null) {
            this.mTalkgroupCategoryComboBox = new ComboBox();
            this.mTalkgroupCategoryComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mTalkgroupCategoryComboBox.setConverter((StringConverter)new TalkgroupCategoryStringConverter());
            this.mTalkgroupCategoryComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateFilter());
        }
        return this.mTalkgroupCategoryComboBox;
    }

    private TableView<AliasedTalkgroup> getTalkgroupTableView() {
        if (this.mTalkgroupTableView == null) {
            this.mTalkgroupTableView = new TableView();
            this.mTalkgroupTableView.setMaxHeight(Double.MAX_VALUE);
            TableColumn talkgroupColumn = new TableColumn("Talkgroup");
            talkgroupColumn.setCellValueFactory((Callback)new PropertyValueFactory("talkgroup"));
            TableColumn descriptionColumn = new TableColumn("Description");
            descriptionColumn.setPrefWidth(300.0);
            descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
            TableColumn aliasColumn = new TableColumn("Alias");
            aliasColumn.setPrefWidth(170.0);
            aliasColumn.setCellValueFactory((Callback)new PropertyValueFactory("alias"));
            this.mTalkgroupTableView.getColumns().addAll((Object[])new TableColumn[]{talkgroupColumn, descriptionColumn, aliasColumn});
            this.mTalkgroupTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, selected) -> {
                TalkgroupCategory talkgroupCategory = this.getTalkgroupCategory(selected != null ? selected.getTalkgroup() : null);
                String aliasListName = (String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem();
                this.getTalkgroupEditor().setTalkgroup(selected != null ? selected.getTalkgroup() : null, this.getCurrentSystem(), this.getRadioReferenceDecoder(), selected != null ? selected.getAlias() : null, aliasListName, talkgroupCategory != null ? talkgroupCategory.getName() : null, this.getEncryptedAsDoNotMonitorCheckBox().selectedProperty().get());
            });
            this.mTalkgroupFilteredList = new FilteredList(this.mTalkgroupList);
            SortedList sortedList = new SortedList(this.mTalkgroupFilteredList);
            sortedList.comparatorProperty().bind((ObservableValue)this.mTalkgroupTableView.comparatorProperty());
            this.mTalkgroupTableView.setItems((ObservableList)sortedList);
        }
        return this.mTalkgroupTableView;
    }

    public class TalkgroupFilter
    implements Predicate<AliasedTalkgroup> {
        private String mFilterText;
        private Integer mCategory;

        public TalkgroupFilter(SystemTalkgroupSelectionEditor this$0) {
        }

        public void setFilterText(String filterText) {
            this.mFilterText = filterText != null ? filterText.toLowerCase() : null;
        }

        public void setCategory(Integer category) {
            this.mCategory = category;
        }

        @Override
        public boolean test(AliasedTalkgroup aliasedTalkgroup) {
            if (this.mCategory == null && (this.mFilterText == null || this.mFilterText.isEmpty())) {
                return true;
            }
            io.github.dsheirer.rrapi.type.Talkgroup talkgroup = aliasedTalkgroup.getTalkgroup();
            if (this.mCategory != null && this.mFilterText != null) {
                if (talkgroup.getTalkgroupCategoryId() != this.mCategory.intValue()) {
                    return false;
                }
                if (aliasedTalkgroup.descriptionProperty().get() != null && ((String)aliasedTalkgroup.descriptionProperty().get()).toLowerCase().contains(this.mFilterText)) {
                    return true;
                }
                if (aliasedTalkgroup.talkgroupProperty().get() != null && ((String)aliasedTalkgroup.talkgroupProperty().get()).toLowerCase().contains(this.mFilterText)) {
                    return true;
                }
                return aliasedTalkgroup.aliasProperty().get() != null && ((String)aliasedTalkgroup.aliasProperty().get()).toLowerCase().contains(this.mFilterText);
            }
            if (this.mCategory != null) {
                return talkgroup.getTalkgroupCategoryId() == this.mCategory.intValue();
            }
            if (aliasedTalkgroup.descriptionProperty().get() != null && ((String)aliasedTalkgroup.descriptionProperty().get()).toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            if (aliasedTalkgroup.talkgroupProperty().get() != null && ((String)aliasedTalkgroup.talkgroupProperty().get()).toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            return aliasedTalkgroup.aliasProperty().get() != null && ((String)aliasedTalkgroup.aliasProperty().get()).toLowerCase().contains(this.mFilterText);
        }
    }

    public class AliasListChangeListener
    implements ListChangeListener<Alias> {
        public void onChanged(ListChangeListener.Change<? extends Alias> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Alias alias : change.getAddedSubList()) {
                        SystemTalkgroupSelectionEditor.this.updateAlias(alias);
                    }
                    continue;
                }
                if (change.wasRemoved()) {
                    for (Alias alias : change.getRemoved()) {
                        SystemTalkgroupSelectionEditor.this.updateAlias(alias);
                    }
                    continue;
                }
                if (!change.wasUpdated()) continue;
                for (int x = change.getFrom(); x < change.getTo(); ++x) {
                    SystemTalkgroupSelectionEditor.this.updateAlias((Alias)change.getList().get(x));
                }
            }
        }
    }

    public class AliasedTalkgroup {
        private io.github.dsheirer.rrapi.type.Talkgroup mTalkgroup;
        private Alias mAlias;
        private StringProperty mAliasProperty = new SimpleStringProperty();
        private StringProperty mDescriptionProperty = new SimpleStringProperty();
        private StringProperty mTalkgroupProperty = new SimpleStringProperty();

        public AliasedTalkgroup(io.github.dsheirer.rrapi.type.Talkgroup talkgroup, Alias alias) {
            this.mTalkgroup = talkgroup;
            this.mDescriptionProperty.setValue(this.mTalkgroup.getDescription());
            this.setAlias(alias);
            this.updateTalkgroup();
        }

        public boolean hasAlias() {
            return this.mAlias != null;
        }

        public Alias getAlias() {
            return this.mAlias;
        }

        public int getTalkgroupValue() {
            return SystemTalkgroupSelectionEditor.this.getRadioReferenceDecoder().getTalkgroupValue(this.mTalkgroup, SystemTalkgroupSelectionEditor.this.getCurrentSystem());
        }

        public void updateTalkgroup() {
            this.mTalkgroupProperty.set((Object)SystemTalkgroupSelectionEditor.this.getRadioReferenceDecoder().format(this.mTalkgroup, SystemTalkgroupSelectionEditor.this.getCurrentSystem()));
        }

        public StringProperty aliasProperty() {
            return this.mAliasProperty;
        }

        public StringProperty descriptionProperty() {
            return this.mDescriptionProperty;
        }

        public StringProperty talkgroupProperty() {
            return this.mTalkgroupProperty;
        }

        public io.github.dsheirer.rrapi.type.Talkgroup getTalkgroup() {
            return this.mTalkgroup;
        }

        public void setAlias(Alias alias) {
            this.mAliasProperty.unbind();
            this.mAliasProperty.setValue(null);
            this.mAlias = alias;
            if (this.mAlias != null) {
                this.mAliasProperty.bind((ObservableValue)this.mAlias.nameProperty());
            }
        }
    }

    public class TalkgroupCategoryStringConverter
    extends StringConverter<TalkgroupCategory> {
        public String toString(TalkgroupCategory cat) {
            return cat != null ? cat.getName() : null;
        }

        public TalkgroupCategory fromString(String string) {
            for (TalkgroupCategory cat : SystemTalkgroupSelectionEditor.this.getTalkgroupCategoryComboBox().getItems()) {
                if (!cat.getName().contentEquals(string)) continue;
                return cat;
            }
            return null;
        }
    }

    public class TalkgroupCategoryListCell
    extends ListCell<TalkgroupCategory> {
        public TalkgroupCategoryListCell(SystemTalkgroupSelectionEditor this$0) {
        }

        protected void updateItem(TalkgroupCategory item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(empty || item == null ? null : item.getName());
        }
    }
}

