/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.id.talkgroup.Talkgroup;
import io.github.dsheirer.identifier.talkgroup.LTRTalkgroup;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.identifier.talkgroup.UnknownTalkgroupIdentifier;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.mpt1327.identifier.MPT1327Talkgroup;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.passport.identifier.PassportTalkgroup;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.talkgroup.LTRTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.MPT1327TalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.rrapi.type.Flavor;
import io.github.dsheirer.rrapi.type.Site;
import io.github.dsheirer.rrapi.type.SiteFrequency;
import io.github.dsheirer.rrapi.type.System;
import io.github.dsheirer.rrapi.type.SystemInformation;
import io.github.dsheirer.rrapi.type.Tag;
import io.github.dsheirer.rrapi.type.Type;
import io.github.dsheirer.rrapi.type.Voice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioReferenceDecoder {
    private static final Logger mLog = LoggerFactory.getLogger(RadioReferenceDecoder.class);
    private UserPreferences mUserPreferences;
    private Map<Integer, Flavor> mFlavorMap;
    private Map<Integer, Tag> mTagMap;
    private Map<Integer, Type> mTypeMap;
    private Map<Integer, Voice> mVoiceMap;

    public RadioReferenceDecoder(UserPreferences userPreferences, Map<Integer, Type> typeMap, Map<Integer, Flavor> flavorMap, Map<Integer, Voice> voiceMap, Map<Integer, Tag> tagMap) {
        this.mUserPreferences = userPreferences;
        this.mTypeMap = typeMap;
        this.mFlavorMap = flavorMap;
        this.mVoiceMap = voiceMap;
        this.mTagMap = tagMap;
    }

    public int getTalkgroupValue(io.github.dsheirer.rrapi.type.Talkgroup talkgroup, System system) {
        Protocol protocol = this.getProtocol(system);
        switch (protocol) {
            case LTR: {
                int value = talkgroup.getDecimalValue();
                int area = value >= 100000 ? 1 : 0;
                int home = value % 100000 / 1000;
                int group = value % 1000;
                return LTRTalkgroup.create(area, home, group);
            }
            case MPT1327: {
                int mptValue = talkgroup.getDecimalValue();
                int prefix = mptValue / 10000;
                int ident = mptValue % 10000;
                return MPT1327Talkgroup.encode(prefix, ident);
            }
        }
        return talkgroup.getDecimalValue();
    }

    public static int convertToRadioReferenceTalkgroup(int value, Protocol protocol) {
        switch (protocol) {
            case LTR: {
                int area = LTRTalkgroupFormatter.getArea(value);
                int home = LTRTalkgroupFormatter.getLcn(value);
                int group = LTRTalkgroupFormatter.getTalkgroup(value);
                return area * 100000 + home * 1000 + group;
            }
            case MPT1327: {
                int prefix = MPT1327TalkgroupFormatter.getPrefix(value);
                int ident = MPT1327TalkgroupFormatter.getIdent(value);
                return prefix * 10000 + ident;
            }
        }
        return value;
    }

    public TalkgroupIdentifier getIdentifier(io.github.dsheirer.rrapi.type.Talkgroup talkgroup, System system) {
        Protocol protocol = this.getProtocol(system);
        int value = this.getTalkgroupValue(talkgroup, system);
        switch (protocol) {
            case APCO25: {
                return APCO25Talkgroup.create(value);
            }
            case LTR: {
                return LTRTalkgroup.create(value);
            }
            case MPT1327: {
                return MPT1327Talkgroup.createTo(value);
            }
            case PASSPORT: {
                return PassportTalkgroup.create(value);
            }
        }
        return UnknownTalkgroupIdentifier.create(value);
    }

    public Talkgroup getTalkgroupAliasId(io.github.dsheirer.rrapi.type.Talkgroup talkgroup, System system) {
        Protocol protocol = this.getProtocol(system);
        int value = this.getTalkgroupValue(talkgroup, system);
        return new Talkgroup(protocol, value);
    }

    public Alias createAlias(io.github.dsheirer.rrapi.type.Talkgroup talkgroup, System system, String aliasList, String group) {
        Alias alias = new Alias(talkgroup.getAlphaTag());
        alias.setAliasListName(aliasList);
        alias.setGroup(group);
        alias.addAliasID(this.getTalkgroupAliasId(talkgroup, system));
        return alias;
    }

    public String format(io.github.dsheirer.rrapi.type.Talkgroup talkgroup, System system) {
        return this.mUserPreferences.getTalkgroupFormatPreference().format(this.getIdentifier(talkgroup, system));
    }

    public List<Tag> getTags(io.github.dsheirer.rrapi.type.Talkgroup talkgroup) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (talkgroup != null && talkgroup.getTags() != null) {
            for (Tag tag : talkgroup.getTags()) {
                tags.add(this.mTagMap.get(tag.getTagId()));
            }
        }
        return tags;
    }

    public Type getType(System system) {
        if (system != null) {
            return this.mTypeMap.get(system.getTypeId());
        }
        return null;
    }

    public Type getType(SystemInformation systemInformation) {
        if (systemInformation != null) {
            return this.mTypeMap.get(systemInformation.getTypeId());
        }
        return null;
    }

    public Flavor getFlavor(System system) {
        if (system != null) {
            return this.mFlavorMap.get(system.getFlavorId());
        }
        return null;
    }

    public Flavor getFlavor(SystemInformation systemInformation) {
        if (systemInformation != null) {
            return this.mFlavorMap.get(systemInformation.getFlavorId());
        }
        return null;
    }

    public Voice getVoice(System system) {
        if (system != null) {
            return this.mVoiceMap.get(system.getVoiceId());
        }
        return null;
    }

    public boolean hasSupportedProtocol(System system) {
        return this.getProtocol(system) != Protocol.UNKNOWN;
    }

    public boolean isLTR(System system) {
        return this.getType(system) != null && this.getType(system).getName().toLowerCase().contentEquals("ltr");
    }

    public boolean isHybridMotorolaP25(System system) {
        return this.getType(system) != null && this.getType(system).getName().contentEquals("Motorola") && this.getProtocol(system) == Protocol.APCO25;
    }

    public boolean isLSM(Site site) {
        if (site != null) {
            if (site.getModulation() != null && site.getModulation().contentEquals("LSM")) {
                return true;
            }
            if (site.getDescription() != null && site.getDescription().contains("Simulcast")) {
                return true;
            }
        }
        return false;
    }

    public boolean hasTimeslotFrequencies(SystemInformation systemInformation, Site site) {
        Type type = this.getType(systemInformation);
        Flavor flavor = this.getFlavor(systemInformation);
        return type != null && flavor != null && type.getName().contains("DMR") && !site.getSiteFrequencies().isEmpty();
    }

    public List<TimeslotFrequency> getTimeslotFrequencies(SystemInformation systemInformation, Site site) {
        if (this.hasTimeslotFrequencies(systemInformation, site)) {
            ArrayList<TimeslotFrequency> frequencies = new ArrayList<TimeslotFrequency>();
            for (SiteFrequency siteFrequency : site.getSiteFrequencies()) {
                int lcn = siteFrequency.getLogicalChannelNumber();
                if (siteFrequency.getChannelId() != null) {
                    try {
                        lcn = Integer.parseInt(siteFrequency.getChannelId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                TimeslotFrequency timeslotFrequency = new TimeslotFrequency();
                timeslotFrequency.setNumber(lcn);
                timeslotFrequency.setDownlinkFrequency((long)(siteFrequency.getFrequency() * 1000000.0));
                frequencies.add(timeslotFrequency);
            }
            return frequencies;
        }
        return Collections.emptyList();
    }

    public Protocol getProtocol(System system) {
        if (system == null) {
            return Protocol.UNKNOWN;
        }
        Type type = this.getType(system);
        Flavor flavor = this.getFlavor(system);
        Voice voice = this.getVoice(system);
        switch (type.getName()) {
            case "DMR": {
                return Protocol.DMR;
            }
            case "LTR": {
                if (flavor != null) {
                    if (flavor.getName().contentEquals("Standard") || flavor.getName().contentEquals("Net")) {
                        return Protocol.LTR;
                    }
                    if (flavor.getName().contentEquals("Passport")) {
                        return Protocol.PASSPORT;
                    }
                }
                return Protocol.LTR;
            }
            case "MPT-1327": {
                return Protocol.MPT1327;
            }
            case "Project 25": {
                return Protocol.APCO25;
            }
            case "Motorola": {
                if (!voice.getName().contentEquals("Analog and APCO-25 Common Air Interface") && !voice.getName().contentEquals("APCO-25 Common Air Interface Exclusive")) break;
                return Protocol.APCO25;
            }
        }
        return Protocol.UNKNOWN;
    }

    public DecoderType getDecoderType(System system) {
        Type type = this.getType(system);
        Flavor flavor = this.getFlavor(system);
        Voice voice = this.getVoice(system);
        if (type != null && flavor != null && voice != null) {
            switch (type.getName()) {
                case "DMR": {
                    return DecoderType.DMR;
                }
                case "LTR": {
                    if (flavor.getName().contentEquals("Net")) {
                        return DecoderType.LTR_NET;
                    }
                    if (flavor.getName().contentEquals("Passport")) {
                        return DecoderType.PASSPORT;
                    }
                    return DecoderType.LTR;
                }
                case "MPT-1327": {
                    return DecoderType.MPT1327;
                }
                case "Project 25": {
                    if (flavor.getName().contentEquals("Phase II")) {
                        return DecoderType.P25_PHASE2;
                    }
                    if (!flavor.getName().contentEquals("Phase I")) break;
                    return DecoderType.P25_PHASE1;
                }
                case "Motorola": {
                    if (!voice.getName().contentEquals("Analog and APCO-25 Common Air Interface") && !voice.getName().contentEquals("APCO-25 Common Air Interface Exclusive")) break;
                    return DecoderType.P25_PHASE1;
                }
            }
        }
        return null;
    }
}

