/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.rrapi.type.Mode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ModeDecoderType {
    AM("am", DecoderType.AM),
    APCO25("p25", DecoderType.P25_PHASE1),
    DMR("dmr", DecoderType.DMR),
    DSTAR("d-star", null),
    FM("fm", DecoderType.NBFM),
    FMN("fmn", DecoderType.NBFM),
    NXDN("nxdn", null),
    TELM("telm", null),
    USB("usb", null),
    LSB("lsb", null),
    YAESU_SYSTEM_FUSION("ysf", null),
    UNKNOWN("UNKNOWN", null);

    private String mValue;
    private DecoderType mDecoderType;
    private static final Logger mLog;

    private ModeDecoderType(String value, DecoderType decoderType) {
        this.mValue = value;
        this.mDecoderType = decoderType;
    }

    public String getValue() {
        return this.mValue;
    }

    public DecoderType getDecoderType() {
        return this.mDecoderType;
    }

    public boolean hasDecoderType() {
        return this.mDecoderType != null;
    }

    public static ModeDecoderType get(Mode mode) {
        if (mode != null) {
            for (ModeDecoderType modeDecoderType : ModeDecoderType.values()) {
                if (!modeDecoderType.getValue().contentEquals(mode.getName().toLowerCase())) continue;
                return modeDecoderType;
            }
            mLog.warn("Unrecognized Radio Reference Mode [" + mode.getName() + " ID:" + mode.getModeId() + "]");
        }
        return UNKNOWN;
    }

    static {
        mLog = LoggerFactory.getLogger(ModeDecoderType.class);
    }
}

