/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.channel.ViewChannelRequest;
import io.github.dsheirer.gui.playlist.radioreference.Level;
import io.github.dsheirer.gui.playlist.radioreference.ModeDecoderType;
import io.github.dsheirer.module.decode.DecoderFactory;
import io.github.dsheirer.module.decode.analog.DecodeConfigAnalog;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.nbfm.DecodeConfigNBFM;
import io.github.dsheirer.module.decode.p25.phase1.DecodeConfigP25Phase1;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.type.Category;
import io.github.dsheirer.rrapi.type.Frequency;
import io.github.dsheirer.rrapi.type.Mode;
import io.github.dsheirer.rrapi.type.SubCategory;
import io.github.dsheirer.service.radioreference.RadioReference;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.util.ThreadPool;
import java.text.DecimalFormat;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(FrequencyEditor.class);
    private final DecimalFormat FREQUENCY_FORMATTER = new DecimalFormat("0.00000");
    private UserPreferences mUserPreferences;
    private RadioReference mRadioReference;
    private PlaylistManager mPlaylistManager;
    private Level mLevel;
    private TextField mAlphaTagTextField;
    private TextField mFrequencyTextField;
    private TextField mModeTextField;
    private TextField mToneTextField;
    private TextField mSystemTextField;
    private TextField mSiteTextField;
    private TextField mNameTextField;
    private TextField mDecoderTextField;
    private Button mCreateButton;
    private Label mChannelCreatedLabel;
    private CheckBox mShowCreatedChannelCheckBox;
    private ModeDecoderType mModeDecoderType;
    private long mFrequency;

    public FrequencyEditor(UserPreferences userPreferences, RadioReference radioReference, PlaylistManager playlistManager, Level level) {
        this.mUserPreferences = userPreferences;
        this.mRadioReference = radioReference;
        this.mPlaylistManager = playlistManager;
        this.mLevel = level;
        GridPane gridPane = new GridPane();
        gridPane.setVgap(5.0);
        gridPane.setHgap(5.0);
        int row = 0;
        Label detailsLabel = new Label("Radio Reference Details");
        GridPane.setConstraints((Node)detailsLabel, (int)1, (int)row);
        gridPane.getChildren().add((Object)detailsLabel);
        Label alphaLabel = new Label("Alpha Tag");
        GridPane.setHalignment((Node)alphaLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)alphaLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)alphaLabel);
        GridPane.setHgrow((Node)this.getAlphaTagTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getAlphaTagTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getAlphaTagTextField());
        Label toneLabel = new Label("Tone");
        GridPane.setHalignment((Node)toneLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)toneLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)toneLabel);
        GridPane.setHgrow((Node)this.getToneTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getToneTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getToneTextField());
        Label modeLabel = new Label("Mode");
        GridPane.setHalignment((Node)modeLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)modeLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)modeLabel);
        GridPane.setHgrow((Node)this.getModeTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getModeTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getModeTextField());
        Label frequencyLabel = new Label("Frequency");
        GridPane.setHalignment((Node)frequencyLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)frequencyLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)frequencyLabel);
        GridPane.setHgrow((Node)this.getFrequencyTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getFrequencyTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getFrequencyTextField());
        Separator separator = new Separator(Orientation.HORIZONTAL);
        GridPane.setConstraints((Node)separator, (int)0, (int)(++row), (int)2, (int)1);
        gridPane.getChildren().add((Object)separator);
        Label createLabel = new Label("Create Channel Configuration");
        GridPane.setConstraints((Node)createLabel, (int)1, (int)(++row));
        gridPane.getChildren().add((Object)createLabel);
        Label systemLabel = new Label("System");
        GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)systemLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)systemLabel);
        GridPane.setHgrow((Node)this.getSystemTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getSystemTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getSystemTextField());
        Label siteLabel = new Label("Site");
        GridPane.setHalignment((Node)siteLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)siteLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)siteLabel);
        GridPane.setHgrow((Node)this.getSiteTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getSiteTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getSiteTextField());
        Label nameLabel = new Label("Name");
        GridPane.setHalignment((Node)nameLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)nameLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)nameLabel);
        GridPane.setHgrow((Node)this.getNameTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getNameTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getNameTextField());
        Label decoderLabel = new Label("Decoder");
        GridPane.setHalignment((Node)decoderLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)decoderLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)decoderLabel);
        GridPane.setHgrow((Node)this.getDecoderTextField(), (Priority)Priority.ALWAYS);
        GridPane.setConstraints((Node)this.getDecoderTextField(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getDecoderTextField());
        GridPane.setConstraints((Node)this.getShowCreatedChannelCheckBox(), (int)1, (int)(++row));
        gridPane.getChildren().add((Object)this.getShowCreatedChannelCheckBox());
        GridPane.setHgrow((Node)this.getCreateButton(), (Priority)Priority.ALWAYS);
        GridPane.setMargin((Node)this.getCreateButton(), (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        GridPane.setConstraints((Node)this.getCreateButton(), (int)1, (int)(++row));
        gridPane.getChildren().add((Object)this.getCreateButton());
        GridPane.setConstraints((Node)this.getChannelCreatedLabel(), (int)1, (int)(++row));
        gridPane.getChildren().add((Object)this.getChannelCreatedLabel());
        this.getChildren().add((Object)gridPane);
    }

    public void setItem(Frequency item, Category category, SubCategory subCategory) {
        this.mModeDecoderType = ModeDecoderType.UNKNOWN;
        if (item != null) {
            this.mFrequency = (long)(item.getDownlink() * 1000000.0);
            this.getAlphaTagTextField().setText(item.getAlphaTag());
            this.getFrequencyTextField().setText(this.FREQUENCY_FORMATTER.format(item.getDownlink()));
            this.getToneTextField().setText(item.getTone());
            this.updateMode(item.getMode());
            this.getSystemTextField().setText(category != null ? category.getName() : null);
            this.getSiteTextField().setText(subCategory != null ? subCategory.getName() : null);
            this.getNameTextField().setText(item.getAlphaTag());
        } else {
            this.mFrequency = 0L;
            this.getAlphaTagTextField().setText(null);
            this.getFrequencyTextField().setText(null);
            this.getModeTextField().setText(null);
            this.getToneTextField().setText(null);
            this.getSystemTextField().setText(null);
            this.getSiteTextField().setText(null);
            this.getNameTextField().setText(null);
            this.getSystemTextField().setDisable(true);
            this.getSiteTextField().setDisable(true);
            this.getNameTextField().setDisable(true);
            this.getCreateButton().setDisable(true);
            this.getShowCreatedChannelCheckBox().setDisable(true);
        }
    }

    private void updateMode(String modeId) {
        if (modeId != null) {
            ThreadPool.CACHED.execute(() -> {
                Integer parsed = null;
                try {
                    parsed = Integer.parseInt(modeId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (parsed != null) {
                    try {
                        Mode mode = this.mRadioReference.getService().getMode(parsed.intValue());
                        this.mModeDecoderType = ModeDecoderType.get(mode);
                        Platform.runLater(() -> {
                            this.getModeTextField().setText(mode.getName());
                            boolean disable = !this.mModeDecoderType.hasDecoderType();
                            this.getSystemTextField().setDisable(disable);
                            this.getSiteTextField().setDisable(disable);
                            this.getNameTextField().setDisable(disable);
                            this.getCreateButton().setDisable(disable);
                            this.getShowCreatedChannelCheckBox().setDisable(disable);
                            if (this.mModeDecoderType.hasDecoderType()) {
                                this.getDecoderTextField().setText(this.mModeDecoderType.getDecoderType().getDisplayString());
                            } else {
                                this.getDecoderTextField().setText(mode.getName() + " - Not Supported");
                            }
                        });
                    }
                    catch (Throwable t) {
                        mLog.error("Error retrieving mode from radio reference", t);
                    }
                }
            });
        } else {
            this.getModeTextField().setText(null);
        }
    }

    private TextField getAlphaTagTextField() {
        if (this.mAlphaTagTextField == null) {
            this.mAlphaTagTextField = new TextField();
            this.mAlphaTagTextField.setMaxWidth(Double.MAX_VALUE);
            this.mAlphaTagTextField.setDisable(true);
        }
        return this.mAlphaTagTextField;
    }

    private TextField getFrequencyTextField() {
        if (this.mFrequencyTextField == null) {
            this.mFrequencyTextField = new TextField();
            this.mFrequencyTextField.setMaxWidth(Double.MAX_VALUE);
            this.mFrequencyTextField.setDisable(true);
        }
        return this.mFrequencyTextField;
    }

    private TextField getModeTextField() {
        if (this.mModeTextField == null) {
            this.mModeTextField = new TextField();
            this.mModeTextField.setMaxWidth(Double.MAX_VALUE);
            this.mModeTextField.setDisable(true);
        }
        return this.mModeTextField;
    }

    private TextField getToneTextField() {
        if (this.mToneTextField == null) {
            this.mToneTextField = new TextField();
            this.mToneTextField.setMaxWidth(Double.MAX_VALUE);
            this.mToneTextField.setDisable(true);
        }
        return this.mToneTextField;
    }

    private CheckBox getShowCreatedChannelCheckBox() {
        if (this.mShowCreatedChannelCheckBox == null) {
            boolean show = this.mUserPreferences.getRadioReferencePreference().getShowChannelEditor(this.mLevel);
            this.mShowCreatedChannelCheckBox = new CheckBox("View Channel Editor After Create");
            this.mShowCreatedChannelCheckBox.setDisable(true);
            this.mShowCreatedChannelCheckBox.selectedProperty().set(show);
            this.mShowCreatedChannelCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.mUserPreferences.getRadioReferencePreference().setShowChannelEditor((boolean)newValue, this.mLevel));
        }
        return this.mShowCreatedChannelCheckBox;
    }

    private Label getChannelCreatedLabel() {
        if (this.mChannelCreatedLabel == null) {
            this.mChannelCreatedLabel = new Label("Channel Created Successfully");
            this.mChannelCreatedLabel.setDisable(true);
            this.mChannelCreatedLabel.setOpacity(0.0);
        }
        return this.mChannelCreatedLabel;
    }

    private Button getCreateButton() {
        if (this.mCreateButton == null) {
            this.mCreateButton = new Button("Create");
            this.mCreateButton.setDisable(true);
            this.mCreateButton.setOnAction(event -> {
                Channel channel = this.createChannel(this.mModeDecoderType, this.mFrequency, this.getSystemTextField().getText(), this.getSiteTextField().getText(), this.getNameTextField().getText());
                if (channel != null) {
                    this.getCreateButton().setDisable(true);
                    this.mPlaylistManager.getChannelModel().addChannel(channel);
                    if (this.getShowCreatedChannelCheckBox().selectedProperty().get()) {
                        MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(channel));
                    } else {
                        this.getChannelCreatedLabel().setOpacity(1.0);
                        FadeTransition transition = new FadeTransition(Duration.seconds((double)2.0), (Node)this.getChannelCreatedLabel());
                        transition.setDelay(Duration.seconds((double)1.0));
                        transition.setToValue(0.0);
                        transition.play();
                    }
                }
            });
        }
        return this.mCreateButton;
    }

    private Channel createChannel(ModeDecoderType modeDecoderType, long frequency, String system, String site, String name) {
        if (modeDecoderType.hasDecoderType()) {
            Channel channel = new Channel();
            channel.setSystem(system);
            channel.setSite(site);
            channel.setName(name);
            SourceConfigTuner sourceConfigTuner = new SourceConfigTuner();
            sourceConfigTuner.setFrequency(frequency);
            channel.setSourceConfiguration(sourceConfigTuner);
            DecodeConfiguration decodeConfiguration = DecoderFactory.getDecodeConfiguration(modeDecoderType.getDecoderType());
            if (decodeConfiguration instanceof DecodeConfigNBFM && modeDecoderType == ModeDecoderType.FM) {
                ((DecodeConfigNBFM)decodeConfiguration).setBandwidth(DecodeConfigAnalog.Bandwidth.BW_25_0);
            } else if (decodeConfiguration instanceof DecodeConfigP25Phase1) {
                ((DecodeConfigP25Phase1)decodeConfiguration).setModulation(P25P1Decoder.Modulation.C4FM);
            }
            channel.setDecodeConfiguration(decodeConfiguration);
            return channel;
        }
        mLog.warn("Can't create channel configuration for [" + modeDecoderType.name() + "] no supported decoder type");
        return null;
    }

    private TextField getSystemTextField() {
        if (this.mSystemTextField == null) {
            this.mSystemTextField = new TextField();
            this.mSystemTextField.setMaxWidth(Double.MAX_VALUE);
            this.mSystemTextField.setDisable(true);
        }
        return this.mSystemTextField;
    }

    private TextField getSiteTextField() {
        if (this.mSiteTextField == null) {
            this.mSiteTextField = new TextField();
            this.mSiteTextField.setMaxWidth(Double.MAX_VALUE);
            this.mSiteTextField.setDisable(true);
        }
        return this.mSiteTextField;
    }

    private TextField getNameTextField() {
        if (this.mNameTextField == null) {
            this.mNameTextField = new TextField();
            this.mNameTextField.setMaxWidth(Double.MAX_VALUE);
            this.mNameTextField.setDisable(true);
        }
        return this.mNameTextField;
    }

    private TextField getDecoderTextField() {
        if (this.mDecoderTextField == null) {
            this.mDecoderTextField = new TextField();
            this.mDecoderTextField.setMaxWidth(Double.MAX_VALUE);
            this.mDecoderTextField.setDisable(true);
        }
        return this.mDecoderTextField;
    }
}

