/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.gui.playlist.radioreference.AgencyFrequencyEditor;
import io.github.dsheirer.gui.playlist.radioreference.CountyAgency;
import io.github.dsheirer.gui.playlist.radioreference.Level;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceUnavailableAlert;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.type.Agency;
import io.github.dsheirer.rrapi.type.AgencyInfo;
import io.github.dsheirer.rrapi.type.CountyInfo;
import io.github.dsheirer.service.radioreference.RadioReference;
import io.github.dsheirer.util.ThreadPool;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgencyEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(AgencyEditor.class);
    private UserPreferences mUserPreferences;
    private RadioReference mRadioReference;
    private PlaylistManager mPlaylistManager;
    private Level mLevel;
    private ListView<Agency> mAgencyListView;
    private AgencyFrequencyEditor mAgencyFrequencyEditor;
    private IntegerProperty mAgencyCountProperty = new SimpleIntegerProperty();

    public AgencyEditor(UserPreferences userPreferences, RadioReference radioReference, PlaylistManager playlistManager, Level level) {
        this.mUserPreferences = userPreferences;
        this.mRadioReference = radioReference;
        this.mPlaylistManager = playlistManager;
        this.mLevel = level;
        this.mAgencyCountProperty.bind((ObservableValue)Bindings.size((ObservableList)this.getAgencyListView().getItems()));
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        VBox.setVgrow((Node)this.getAgencyFrequencyEditor(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getAgencyListView(), this.getAgencyFrequencyEditor()});
    }

    public void setAgencies(List<Agency> agencies) {
        this.clear();
        if (agencies != null && !agencies.isEmpty()) {
            Collections.sort(agencies, new AgencyComparator(this));
            this.getAgencyListView().getItems().addAll(agencies);
            int preferredAgencyId = this.mUserPreferences.getRadioReferencePreference().getPreferredAgencyId(this.mLevel);
            for (Agency agency : this.getAgencyListView().getItems()) {
                if (agency.getAgencyId() != preferredAgencyId) continue;
                this.getAgencyListView().getSelectionModel().select((Object)agency);
                this.getAgencyListView().scrollTo((Object)agency);
                return;
            }
        }
    }

    public void clear() {
        this.getAgencyListView().getItems().clear();
        this.getAgencyFrequencyEditor().setCategories(null);
    }

    public IntegerProperty agencyCountProperty() {
        return this.mAgencyCountProperty;
    }

    private AgencyFrequencyEditor getAgencyFrequencyEditor() {
        if (this.mAgencyFrequencyEditor == null) {
            this.mAgencyFrequencyEditor = new AgencyFrequencyEditor(this.mUserPreferences, this.mRadioReference, this.mPlaylistManager, this.mLevel);
        }
        return this.mAgencyFrequencyEditor;
    }

    private ListView<Agency> getAgencyListView() {
        if (this.mAgencyListView == null) {
            this.mAgencyListView = new ListView();
            this.mAgencyListView.setPrefHeight(200.0);
            this.mAgencyListView.setCellFactory(param -> new AgencyListCell(this));
            this.mAgencyListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setAgency((Agency)newValue));
            this.mAgencyListView.setPlaceholder((Node)new Label("No agencies available"));
        }
        return this.mAgencyListView;
    }

    private void setAgency(Agency agency) {
        if (agency != null) {
            this.getAgencyFrequencyEditor().clearAndSetLoading();
            this.mUserPreferences.getRadioReferencePreference().setPreferredAgencyId(agency.getAgencyId(), this.mLevel);
            ThreadPool.CACHED.submit(() -> {
                try {
                    if (this.mLevel == Level.COUNTY && agency instanceof CountyAgency) {
                        CountyInfo countyInfo = this.mRadioReference.getService().getCountyInfo(-agency.getAgencyId());
                        Platform.runLater(() -> this.getAgencyFrequencyEditor().setCategories(countyInfo.getCategories()));
                    } else {
                        AgencyInfo agencyInfo = this.mRadioReference.getService().getAgencyInfo(agency);
                        Platform.runLater(() -> this.getAgencyFrequencyEditor().setCategories(agencyInfo.getCategories()));
                    }
                }
                catch (Throwable t) {
                    mLog.error("Error retrieving agency info", t);
                    Platform.runLater(() -> {
                        this.getAgencyFrequencyEditor().setLoading(false);
                        new RadioReferenceUnavailableAlert((Node)this.getAgencyListView()).showAndWait();
                    });
                }
            });
        } else {
            this.getAgencyFrequencyEditor().clear();
        }
    }

    public class AgencyComparator
    implements Comparator<Agency> {
        public AgencyComparator(AgencyEditor this$0) {
        }

        @Override
        public int compare(Agency o1, Agency o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null || o2 instanceof CountyAgency) {
                return 1;
            }
            if (o2.getName() == null || o1 instanceof CountyAgency) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    public class AgencyListCell
    extends ListCell<Agency> {
        public AgencyListCell(AgencyEditor this$0) {
        }

        protected void updateItem(Agency item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(empty || item == null ? null : item.getName());
        }
    }
}

