/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import com.google.common.base.Joiner;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditorFactory;
import io.github.dsheirer.gui.playlist.channel.ChannelTabRequest;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.channel.UnknownConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.ViewChannelRequest;
import io.github.dsheirer.module.decode.DecoderFactory;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.textfield.TextFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelEditor
extends SplitPane
implements IFilterProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelEditor.class);
    private PlaylistManager mPlaylistManager;
    private TunerManager mTunerManager;
    private UserPreferences mUserPreferences;
    private TableView<Channel> mChannelTableView;
    private Label mPlaceholderLabel;
    private MenuButton mNewButton;
    private Button mDeleteButton;
    private Button mCloneButton;
    private VBox mButtonBox;
    private HBox mSearchAndViewBox;
    private TextField mSearchField;
    private SegmentedButton mViewSegmentedButton;
    private ToggleButton mAllToggleButton;
    private ToggleButton mAutoStartToggleButton;
    private ToggleButton mPlayingToggleButton;
    private ChannelConfigurationEditor mChannelConfigurationEditor;
    private UnknownConfigurationEditor mUnknownConfigurationEditor;
    private Map<DecoderType, ChannelConfigurationEditor> mChannelConfigurationEditorMap = new HashMap<DecoderType, ChannelConfigurationEditor>();
    private FilteredList<Channel> mChannelFilteredList;
    private ChannelListFilter mChannelListFilter = new ChannelListFilter();

    public ChannelEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences) {
        this.mPlaylistManager = playlistManager;
        this.mTunerManager = tunerManager;
        this.mUserPreferences = userPreferences;
        this.mUnknownConfigurationEditor = new UnknownConfigurationEditor(this.mPlaylistManager, this.mTunerManager, userPreferences, this);
        HBox channelsBox = new HBox();
        channelsBox.setSpacing(10.0);
        HBox.setHgrow(this.getChannelTableView(), (Priority)Priority.ALWAYS);
        channelsBox.getChildren().addAll((Object[])new Node[]{this.getChannelTableView(), this.getButtonBox()});
        VBox topBox = new VBox();
        topBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        topBox.setSpacing(10.0);
        VBox.setVgrow((Node)channelsBox, (Priority)Priority.ALWAYS);
        topBox.getChildren().addAll((Object[])new Node[]{this.getSearchAndViewBox(), channelsBox});
        this.setOrientation(Orientation.VERTICAL);
        this.getItems().addAll((Object[])new Node[]{topBox, this.getChannelConfigurationEditor()});
    }

    public void process(ChannelTabRequest channelTabRequest) {
        Channel channel;
        if (channelTabRequest instanceof ViewChannelRequest && (channel = ((ViewChannelRequest)channelTabRequest).getChannel()) != null) {
            this.getSearchField().setText(null);
            this.getChannelTableView().getSelectionModel().select((Object)channel);
            this.getChannelTableView().scrollTo((Object)channel);
        }
    }

    private void setChannel(Channel channel) {
        if (this.getChannelConfigurationEditor().modifiedProperty().get()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.getButtonTypes().clear();
            alert.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.NO, ButtonType.YES});
            alert.setTitle("Save Changes");
            alert.setHeaderText("Channel configuration has been modified");
            alert.setContentText("Do you want to save these changes?");
            alert.initOwner(this.getButtonBox().getScene().getWindow());
            alert.setResizable(true);
            alert.onShownProperty().addListener(e -> Platform.runLater(() -> alert.setResizable(false)));
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.YES) {
                this.getChannelConfigurationEditor().save();
            }
        }
        this.getCloneButton().setDisable(channel == null);
        this.getDeleteButton().setDisable(channel == null);
        if (channel == null) {
            this.setChannelConfigurationEditor(this.mUnknownConfigurationEditor);
        } else {
            DecoderType channelDecoderType = null;
            if (channel.getDecodeConfiguration() != null) {
                channelDecoderType = channel.getDecodeConfiguration().getDecoderType();
            }
            if (channelDecoderType == null) {
                this.setChannelConfigurationEditor(this.mUnknownConfigurationEditor);
            } else {
                DecoderType editorDecoderType = this.getChannelConfigurationEditor().getDecoderType();
                if (editorDecoderType == null || editorDecoderType != channelDecoderType) {
                    ChannelConfigurationEditor editor = this.mChannelConfigurationEditorMap.get((Object)channelDecoderType);
                    if (editor == null && (editor = ChannelConfigurationEditorFactory.getEditor(channelDecoderType, this.mPlaylistManager, this.mTunerManager, this.mUserPreferences, this)) != null) {
                        this.mChannelConfigurationEditorMap.put(channelDecoderType, editor);
                    }
                    if (editor == null) {
                        editor = this.mUnknownConfigurationEditor;
                    }
                    this.setChannelConfigurationEditor(editor);
                }
            }
        }
        this.getChannelConfigurationEditor().setItem(channel);
    }

    private void createNewChannel(DecoderType decoderType) {
        Channel channel = new Channel();
        channel.setDecodeConfiguration(DecoderFactory.getDecodeConfiguration(decoderType));
        this.mPlaylistManager.getChannelModel().addChannel(channel);
        this.getChannelTableView().getSelectionModel().select((Object)channel);
        this.getChannelTableView().scrollTo((Object)channel);
    }

    private SegmentedButton getViewSegmentedButton() {
        if (this.mViewSegmentedButton == null) {
            this.mViewSegmentedButton = new SegmentedButton(new ToggleButton[]{this.getAllToggleButton(), this.getPlayingToggleButton(), this.getAutoStartToggleButton()});
            this.mViewSegmentedButton.getStyleClass().add((Object)"dark");
            this.getAllToggleButton().setSelected(true);
            this.mViewSegmentedButton.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == null) {
                    oldValue.setSelected(true);
                } else {
                    this.updateChannelListFilter();
                }
            });
        }
        return this.mViewSegmentedButton;
    }

    private ToggleButton getAllToggleButton() {
        if (this.mAllToggleButton == null) {
            this.mAllToggleButton = new ToggleButton("All");
        }
        return this.mAllToggleButton;
    }

    private ToggleButton getAutoStartToggleButton() {
        if (this.mAutoStartToggleButton == null) {
            this.mAutoStartToggleButton = new ToggleButton("Auto-Start");
        }
        return this.mAutoStartToggleButton;
    }

    private ToggleButton getPlayingToggleButton() {
        if (this.mPlayingToggleButton == null) {
            this.mPlayingToggleButton = new ToggleButton("Playing");
        }
        return this.mPlayingToggleButton;
    }

    private void setChannelConfigurationEditor(ChannelConfigurationEditor editor) {
        if (editor != this.getChannelConfigurationEditor()) {
            this.getItems().remove((Object)this.getChannelConfigurationEditor());
            this.mChannelConfigurationEditor = editor;
            this.getItems().add((Object)this.getChannelConfigurationEditor());
        }
    }

    private ChannelConfigurationEditor getChannelConfigurationEditor() {
        if (this.mChannelConfigurationEditor == null) {
            this.mChannelConfigurationEditor = this.mUnknownConfigurationEditor;
            this.mChannelConfigurationEditor.setMaxWidth(Double.MAX_VALUE);
        }
        return this.mChannelConfigurationEditor;
    }

    private HBox getSearchAndViewBox() {
        if (this.mSearchAndViewBox == null) {
            this.mSearchAndViewBox = new HBox();
            this.mSearchAndViewBox.setAlignment(Pos.CENTER_LEFT);
            this.mSearchAndViewBox.setSpacing(10.0);
            HBox searchBox = new HBox();
            searchBox.setSpacing(5.0);
            searchBox.setAlignment(Pos.CENTER);
            Label searchLabel = new Label("Search:");
            searchLabel.setAlignment(Pos.CENTER_RIGHT);
            searchBox.getChildren().addAll((Object[])new Node[]{searchLabel, this.getSearchField()});
            HBox viewBox = new HBox();
            viewBox.setSpacing(5.0);
            viewBox.setAlignment(Pos.CENTER);
            Label viewLabel = new Label("View Channels:");
            viewBox.getChildren().addAll((Object[])new Node[]{viewLabel, this.getViewSegmentedButton()});
            this.mSearchAndViewBox.getChildren().addAll((Object[])new Node[]{searchBox, viewBox});
        }
        return this.mSearchAndViewBox;
    }

    private TextField getSearchField() {
        if (this.mSearchField == null) {
            this.mSearchField = TextFields.createClearableTextField();
            this.mSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.updateChannelListFilter());
        }
        return this.mSearchField;
    }

    private void updateChannelListFilter() {
        this.mChannelListFilter.setFilterText(this.getSearchField().getText());
        if (this.getAllToggleButton().isSelected()) {
            this.mChannelListFilter.setView(ChannelListFilter.View.ALL);
        } else if (this.getAutoStartToggleButton().isSelected()) {
            this.mChannelListFilter.setView(ChannelListFilter.View.AUTO_START);
        } else if (this.getPlayingToggleButton().isSelected()) {
            this.mChannelListFilter.setView(ChannelListFilter.View.PLAYING);
        }
        this.mChannelFilteredList.setPredicate(null);
        this.mChannelFilteredList.setPredicate((Predicate)this.mChannelListFilter);
    }

    @Override
    public void clearFilter() {
        this.mChannelFilteredList.setPredicate(null);
    }

    @Override
    public void restoreFilter() {
        this.mChannelFilteredList.setPredicate((Predicate)this.mChannelListFilter);
    }

    private TableView<Channel> getChannelTableView() {
        if (this.mChannelTableView == null) {
            this.mChannelTableView = new TableView();
            TableColumn playingColumn = new TableColumn("Playing");
            playingColumn.setPrefWidth(75.0);
            playingColumn.setCellValueFactory((Callback)new PropertyValueFactory("processing"));
            playingColumn.setCellFactory(param -> {
                TableCell<Channel, Boolean> tableCell = new TableCell<Channel, Boolean>(this){

                    protected void updateItem(Boolean item, boolean empty) {
                        this.setAlignment(Pos.CENTER);
                        this.setText(null);
                        if (empty || item == null || !item.booleanValue()) {
                            this.setGraphic(null);
                        } else {
                            IconNode iconNode = new IconNode((IconCode)FontAwesome.CHECK);
                            iconNode.setFill((Paint)Color.GREEN);
                            this.setGraphic((Node)iconNode);
                        }
                    }
                };
                return tableCell;
            });
            TableColumn autoStartColumn = new TableColumn("Auto-Start");
            autoStartColumn.setCellValueFactory((Callback)new PropertyValueFactory("autoStart"));
            autoStartColumn.setPrefWidth(95.0);
            autoStartColumn.setCellFactory(param -> {
                TableCell<Channel, Boolean> tableCell = new TableCell<Channel, Boolean>(this){

                    protected void updateItem(Boolean item, boolean empty) {
                        this.setAlignment(Pos.CENTER);
                        this.setText(null);
                        if (empty || item == null || !item.booleanValue()) {
                            this.setGraphic(null);
                        } else {
                            IconNode iconNode = new IconNode((IconCode)FontAwesome.CHECK);
                            iconNode.setFill((Paint)Color.GREEN);
                            this.setGraphic((Node)iconNode);
                        }
                    }
                };
                return tableCell;
            });
            TableColumn systemColumn = new TableColumn("System");
            systemColumn.setCellValueFactory((Callback)new PropertyValueFactory("system"));
            systemColumn.setPrefWidth(175.0);
            TableColumn siteColumn = new TableColumn("Site");
            siteColumn.setCellValueFactory((Callback)new PropertyValueFactory("site"));
            siteColumn.setPrefWidth(175.0);
            TableColumn nameColumn = new TableColumn("Name");
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            nameColumn.setPrefWidth(200.0);
            TableColumn frequencyColumn = new TableColumn("Frequency");
            frequencyColumn.setComparator((o1, o2) -> {
                if (o1 instanceof Channel) {
                    Channel c1 = (Channel)o1;
                    if (o2 instanceof Channel) {
                        Channel c2 = (Channel)o2;
                        if (!c1.getFrequencyList().isEmpty() && !c2.getFrequencyList().isEmpty()) {
                            return Long.compare((Long)c1.getFrequencyList().get(0), (Long)c2.getFrequencyList().get(0));
                        }
                        if (!c1.getFrequencyList().isEmpty()) {
                            return Long.compare((Long)c1.getFrequencyList().get(0), 0L);
                        }
                        if (!c2.getFrequencyList().isEmpty()) {
                            return Long.compare(0L, (Long)c2.getFrequencyList().get(0));
                        }
                    }
                }
                return Integer.compare(o1.hashCode(), o2.hashCode());
            });
            frequencyColumn.setCellValueFactory((Callback)new FrequencyCellValueFactory(this));
            frequencyColumn.setPrefWidth(100.0);
            TableColumn protocolColumn = new TableColumn("Protocol");
            protocolColumn.setCellValueFactory((Callback)new ProtocolCellValueFactory(this));
            protocolColumn.setPrefWidth(100.0);
            this.mChannelTableView.getColumns().addAll((Object[])new TableColumn[]{systemColumn, siteColumn, nameColumn, frequencyColumn, protocolColumn, playingColumn, autoStartColumn});
            this.mChannelTableView.setPlaceholder((Node)this.getPlaceholderLabel());
            this.mChannelFilteredList = new FilteredList(this.mPlaylistManager.getChannelModel().channelList(), (Predicate)this.mChannelListFilter);
            SortedList sortedList = new SortedList(this.mChannelFilteredList);
            sortedList.comparatorProperty().bind((ObservableValue)this.mChannelTableView.comparatorProperty());
            this.mChannelTableView.setItems((ObservableList)sortedList);
            this.mChannelTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setChannel((Channel)newValue));
        }
        return this.mChannelTableView;
    }

    private Label getPlaceholderLabel() {
        if (this.mPlaceholderLabel == null) {
            this.mPlaceholderLabel = new Label("No Channel Configurations Available");
        }
        return this.mPlaceholderLabel;
    }

    private VBox getButtonBox() {
        if (this.mButtonBox == null) {
            this.mButtonBox = new VBox();
            this.mButtonBox.setSpacing(10.0);
            this.mButtonBox.getChildren().addAll((Object[])new Node[]{this.getNewButton(), this.getCloneButton(), this.getDeleteButton()});
        }
        return this.mButtonBox;
    }

    private MenuButton getNewButton() {
        if (this.mNewButton == null) {
            this.mNewButton = new MenuButton("New");
            this.mNewButton.setAlignment(Pos.CENTER);
            this.mNewButton.setMaxWidth(Double.MAX_VALUE);
            MenuItem decodersItem = new MenuItem("Decoder");
            decodersItem.setDisable(true);
            this.mNewButton.getItems().addAll((Object[])new MenuItem[]{decodersItem, new SeparatorMenuItem()});
            for (DecoderType decoderType : DecoderType.PRIMARY_DECODERS) {
                if (decoderType == DecoderType.P25_PHASE2) {
                    this.mNewButton.getItems().add((Object)new NewP25P2ChannelMenu());
                    continue;
                }
                this.mNewButton.getItems().add((Object)new NewChannelMenuItem(decoderType));
            }
        }
        return this.mNewButton;
    }

    private Button getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = new Button("Delete");
            this.mDeleteButton.setDisable(true);
            this.mDeleteButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteButton.setOnAction(event -> {
                Channel selected = (Channel)this.getChannelTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to delete the selected channel?", new ButtonType[]{ButtonType.NO, ButtonType.YES});
                    alert.setTitle("Delete Channel");
                    alert.setHeaderText("Are you sure?");
                    alert.initOwner(this.getDeleteButton().getScene().getWindow());
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.YES) {
                        if (selected.isProcessing()) {
                            try {
                                this.mPlaylistManager.getChannelProcessingManager().stop(selected);
                            }
                            catch (Exception e) {
                                mLog.error("Couldn't stop channel [" + selected.getName() + "] prior to delete by user");
                            }
                        }
                        this.mPlaylistManager.getChannelModel().removeChannel(selected);
                    }
                }
            });
        }
        return this.mDeleteButton;
    }

    private Button getCloneButton() {
        if (this.mCloneButton == null) {
            this.mCloneButton = new Button("Clone");
            this.mCloneButton.setDisable(true);
            this.mCloneButton.setMaxWidth(Double.MAX_VALUE);
            this.mCloneButton.setOnAction(event -> {
                Channel selected = (Channel)this.getChannelTableView().getSelectionModel().getSelectedItem();
                Channel copy = selected.copyOf();
                this.mPlaylistManager.getChannelModel().addChannel(copy);
                this.getChannelTableView().getSelectionModel().select((Object)copy);
            });
        }
        return this.mCloneButton;
    }

    public static class ChannelListFilter
    implements Predicate<Channel> {
        private String mFilterText;
        private View mView = View.ALL;

        public void setFilterText(String filterText) {
            this.mFilterText = filterText == null || filterText.trim().isEmpty() ? null : filterText.toLowerCase();
        }

        public void setView(View view) {
            this.mView = view;
        }

        @Override
        public boolean test(Channel channel) {
            switch (this.mView) {
                default: {
                    return this.matchesFilter(channel);
                }
                case AUTO_START: {
                    return channel.isAutoStart() && this.matchesFilter(channel);
                }
                case PLAYING: 
            }
            return channel.isProcessing() && this.matchesFilter(channel);
        }

        private boolean matchesFilter(Channel channel) {
            if (this.mFilterText == null) {
                return true;
            }
            if (channel.getName() != null && channel.getName().toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            if (channel.getSite() != null && channel.getSite().toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            if (channel.getSystem() != null && channel.getSystem().toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            return channel.getDecodeConfiguration().getDecoderType().toString().toLowerCase().contains(this.mFilterText);
        }

        public static enum View {
            ALL,
            AUTO_START,
            PLAYING;

        }
    }

    public class FrequencyCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<Channel, String>, ObservableValue<String>> {
        private SimpleStringProperty mFrequency = new SimpleStringProperty();

        public FrequencyCellValueFactory(ChannelEditor this$0) {
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<Channel, String> param) {
            ObservableList<Long> frequencies = ((Channel)param.getValue()).getFrequencyList();
            if (frequencies != null) {
                ArrayList<String> freqsMHz = new ArrayList<String>();
                for (Long frequency : frequencies) {
                    freqsMHz.add(String.valueOf((double)frequency.longValue() / 1000000.0));
                }
                this.mFrequency.set(Joiner.on((String)", ").join(freqsMHz));
            } else {
                this.mFrequency.set(null);
            }
            return this.mFrequency;
        }
    }

    public class ProtocolCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<Channel, String>, ObservableValue<String>> {
        private SimpleStringProperty mProtocol = new SimpleStringProperty();

        public ProtocolCellValueFactory(ChannelEditor this$0) {
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<Channel, String> param) {
            Channel channel = (Channel)param.getValue();
            if (channel != null) {
                this.mProtocol.set(channel.getDecodeConfiguration().getDecoderType().getDisplayString());
            } else {
                this.mProtocol.set(null);
            }
            return this.mProtocol;
        }
    }

    public class NewP25P2ChannelMenu
    extends Menu {
        public NewP25P2ChannelMenu() {
            this.setText(DecoderType.P25_PHASE2.getDisplayString());
            MenuItem trunked = new MenuItem("Trunked System");
            trunked.setOnAction(event -> ChannelEditor.this.createNewChannel(DecoderType.P25_PHASE1));
            MenuItem channel = new MenuItem("Individual Channel");
            channel.setOnAction(event -> ChannelEditor.this.createNewChannel(DecoderType.P25_PHASE2));
            this.getItems().addAll((Object[])new MenuItem[]{trunked, channel});
        }
    }

    public class NewChannelMenuItem
    extends MenuItem {
        private DecoderType mDecoderType;

        public NewChannelMenuItem(DecoderType decoderType) {
            this.setText(decoderType.getDisplayString());
            this.mDecoderType = decoderType;
            this.setOnAction(event -> ChannelEditor.this.createNewChannel(this.mDecoderType));
        }
    }
}

