/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.status.UserStatusID;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStatusEditor
extends IdentifierEditor<UserStatusID> {
    private static final Logger mLog = LoggerFactory.getLogger(UserStatusEditor.class);
    private TextField mUserStatusField;
    private TextFormatter<Integer> mIntegerTextFormatter;

    public UserStatusEditor() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        Label valueLabel = new Label("User Status");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)0, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getUserStatusField(), (int)1, (int)0);
        gridPane.getChildren().add((Object)this.getUserStatusField());
        Label helpLabel = new Label("Format: 0 - 255");
        GridPane.setConstraints((Node)helpLabel, (int)2, (int)0);
        gridPane.getChildren().add((Object)helpLabel);
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(UserStatusID item) {
        super.setItem(item);
        UserStatusID userStatus = (UserStatusID)this.getItem();
        this.getUserStatusField().setDisable(userStatus == null);
        if (userStatus != null) {
            this.getTextFormatter().setValue((Object)userStatus.getStatus());
        } else {
            this.getTextFormatter().setValue(null);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private TextField getUserStatusField() {
        if (this.mUserStatusField == null) {
            this.mUserStatusField = new TextField();
            this.mUserStatusField.setTextFormatter(this.getTextFormatter());
        }
        return this.mUserStatusField;
    }

    private TextFormatter<Integer> getTextFormatter() {
        if (this.mIntegerTextFormatter == null) {
            this.mIntegerTextFormatter = new IntegerFormatter(0, 255);
            this.mIntegerTextFormatter.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

                public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                    if (UserStatusEditor.this.getItem() != null) {
                        ((UserStatusID)UserStatusEditor.this.getItem()).setStatus(newValue != null ? newValue : 0);
                        UserStatusEditor.this.modifiedProperty().set(true);
                    }
                }
            });
        }
        return this.mIntegerTextFormatter;
    }
}

