/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.tone.TonesID;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.identifier.tone.AmbeTone;
import io.github.dsheirer.identifier.tone.Tone;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TonesEditor
extends IdentifierEditor<TonesID> {
    private static final Logger mLog = LoggerFactory.getLogger(TonesEditor.class);
    private ListView<Tone> mToneListView;
    private ComboBox<AmbeTone> mAmbeToneComboBox;
    private TextField mDurationTextField;
    private IntegerFormatter mDurationIntegerFormatter;
    private Button mAddToneButton;
    private Button mDeleteToneButton;
    private Button mMoveUpButton;
    private Button mMoveDownButton;
    private DurationValueChangeListener mDurationValueChangeListener = new DurationValueChangeListener();
    private AmbeToneComboBoxEventHandler mAmbeToneComboBoxEventHandler = new AmbeToneComboBoxEventHandler();

    public TonesEditor() {
        VBox upDownBox = new VBox();
        upDownBox.setAlignment(Pos.CENTER);
        upDownBox.setSpacing(10.0);
        upDownBox.getChildren().addAll((Object[])new Node[]{this.getMoveUpButton(), this.getMoveDownButton()});
        GridPane editorsPane = new GridPane();
        editorsPane.setAlignment(Pos.CENTER);
        editorsPane.setHgap(5.0);
        editorsPane.setVgap(10.0);
        Label toneLabel = new Label("Tone");
        GridPane.setConstraints((Node)toneLabel, (int)0, (int)0);
        GridPane.setHalignment((Node)toneLabel, (HPos)HPos.RIGHT);
        editorsPane.getChildren().add((Object)toneLabel);
        GridPane.setConstraints(this.getAmbeToneComboBox(), (int)1, (int)0);
        editorsPane.getChildren().add(this.getAmbeToneComboBox());
        Label durationLabel = new Label("Duration 1-50");
        GridPane.setConstraints((Node)durationLabel, (int)0, (int)1);
        GridPane.setHalignment((Node)durationLabel, (HPos)HPos.RIGHT);
        editorsPane.getChildren().add((Object)durationLabel);
        GridPane.setConstraints((Node)this.getDurationTextField(), (int)1, (int)1);
        editorsPane.getChildren().add((Object)this.getDurationTextField());
        VBox buttonBox = new VBox();
        buttonBox.setAlignment(Pos.CENTER);
        buttonBox.setSpacing(10.0);
        buttonBox.getChildren().addAll((Object[])new Node[]{this.getAddToneButton(), this.getDeleteToneButton()});
        HBox editorBox = new HBox();
        editorBox.setSpacing(10.0);
        HBox.setHgrow(this.getToneListView(), (Priority)Priority.ALWAYS);
        editorBox.getChildren().addAll((Object[])new Node[]{this.getToneListView(), upDownBox, editorsPane, buttonBox});
        this.getChildren().add((Object)editorBox);
    }

    @Override
    public void setItem(TonesID item) {
        super.setItem(item);
        this.getToneListView().setDisable(item == null);
        this.getAddToneButton().setDisable(item == null);
        if (item != null) {
            this.getToneListView().setItems(item.getToneSequence().tonesProperty());
        } else {
            this.getToneListView().setItems(FXCollections.emptyObservableList());
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private void setTone(Tone tone) {
        this.getDeleteToneButton().setDisable(tone == null);
        this.mAmbeToneComboBoxEventHandler.disable();
        this.mDurationValueChangeListener.disable();
        this.getAmbeToneComboBox().setDisable(tone == null);
        this.getDurationTextField().setDisable(tone == null);
        if (tone != null) {
            this.getAmbeToneComboBox().getSelectionModel().select((Object)tone.getAmbeTone());
            this.getDurationIntegerFormatter().setValue(tone.getDuration());
        } else {
            this.getAmbeToneComboBox().getSelectionModel().select(null);
            this.getDurationIntegerFormatter().setValue(2);
        }
        this.mAmbeToneComboBoxEventHandler.enable();
        this.mDurationValueChangeListener.enable();
        this.updateMoveButtons();
    }

    private Button getAddToneButton() {
        if (this.mAddToneButton == null) {
            this.mAddToneButton = new Button("Add Tone");
            this.mAddToneButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddToneButton.setDisable(true);
            this.mAddToneButton.setOnAction(event -> {
                Tone tone = new Tone(AmbeTone.DTMF_0, 2);
                ((TonesID)this.getItem()).getToneSequence().addTone(tone);
                this.modifiedProperty().set(true);
                this.getToneListView().getSelectionModel().select((Object)tone);
                this.getToneListView().scrollTo((Object)tone);
            });
        }
        return this.mAddToneButton;
    }

    private Button getDeleteToneButton() {
        if (this.mDeleteToneButton == null) {
            this.mDeleteToneButton = new Button("Delete Tone");
            this.mDeleteToneButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteToneButton.setDisable(true);
            this.mDeleteToneButton.setOnAction(event -> {
                Tone selected = (Tone)this.getToneListView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    ((TonesID)this.getItem()).getToneSequence().removeTone(selected);
                    this.modifiedProperty().set(true);
                }
            });
        }
        return this.mDeleteToneButton;
    }

    private void updateMoveButtons() {
        if (this.getToneListView().getItems().size() >= 2 && this.getToneListView().getSelectionModel().getSelectedItem() != null) {
            Tone selected = (Tone)this.getToneListView().getSelectionModel().getSelectedItem();
            this.getMoveUpButton().setDisable(this.getToneListView().getItems().indexOf((Object)selected) == 0);
            this.getMoveDownButton().setDisable(this.getToneListView().getItems().indexOf((Object)selected) >= this.getToneListView().getItems().size() - 1);
        } else {
            this.getMoveDownButton().setDisable(true);
            this.getMoveUpButton().setDisable(true);
        }
    }

    private Button getMoveUpButton() {
        if (this.mMoveUpButton == null) {
            this.mMoveUpButton = new Button();
            IconNode iconNode = new IconNode((IconCode)FontAwesome.ARROW_UP);
            iconNode.setIconSize((Number)12);
            iconNode.setFill(this.getMoveUpButton().getTextFill());
            this.mMoveUpButton.setGraphic((Node)iconNode);
            this.mMoveUpButton.setMaxWidth(Double.MAX_VALUE);
            this.mMoveUpButton.setDisable(true);
            this.mMoveUpButton.setOnAction(event -> {
                Tone selected = (Tone)this.getToneListView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    int index = ((TonesID)this.getItem()).getToneSequence().getTones().indexOf(selected);
                    ((TonesID)this.getItem()).getToneSequence().getTones().remove(selected);
                    ((TonesID)this.getItem()).getToneSequence().getTones().add(index - 1, selected);
                    this.getToneListView().getSelectionModel().select((Object)selected);
                }
            });
        }
        return this.mMoveUpButton;
    }

    private Button getMoveDownButton() {
        if (this.mMoveDownButton == null) {
            this.mMoveDownButton = new Button();
            IconNode iconNode = new IconNode((IconCode)FontAwesome.ARROW_DOWN);
            iconNode.setIconSize((Number)12);
            iconNode.setFill(this.getMoveDownButton().getTextFill());
            this.mMoveDownButton.setGraphic((Node)iconNode);
            this.mMoveDownButton.setMaxWidth(Double.MAX_VALUE);
            this.mMoveDownButton.setDisable(true);
            this.mMoveDownButton.setOnAction(event -> {
                Tone selected = (Tone)this.getToneListView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    int index = ((TonesID)this.getItem()).getToneSequence().getTones().indexOf(selected);
                    ((TonesID)this.getItem()).getToneSequence().getTones().remove(selected);
                    ((TonesID)this.getItem()).getToneSequence().getTones().add(index + 1, selected);
                    this.getToneListView().getSelectionModel().select((Object)selected);
                }
            });
        }
        return this.mMoveDownButton;
    }

    private ListView<Tone> getToneListView() {
        if (this.mToneListView == null) {
            this.mToneListView = new ListView();
            this.mToneListView.setDisable(true);
            this.mToneListView.setPrefHeight(75.0);
            this.mToneListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setTone((Tone)newValue));
        }
        return this.mToneListView;
    }

    private ComboBox<AmbeTone> getAmbeToneComboBox() {
        if (this.mAmbeToneComboBox == null) {
            this.mAmbeToneComboBox = new ComboBox();
            this.mAmbeToneComboBox.setTooltip(new Tooltip("Tone to match"));
            this.mAmbeToneComboBox.getItems().addAll(AmbeTone.ALL_VALID_TONES);
            this.mAmbeToneComboBox.setDisable(true);
            this.mAmbeToneComboBox.setOnAction((EventHandler)this.mAmbeToneComboBoxEventHandler);
        }
        return this.mAmbeToneComboBox;
    }

    private TextField getDurationTextField() {
        if (this.mDurationTextField == null) {
            this.mDurationTextField = new TextField();
            this.mDurationTextField.setTooltip(new Tooltip("Duration in 20 millisecond units"));
            this.mDurationTextField.setMaxWidth(Double.MAX_VALUE);
            this.mDurationTextField.setTextFormatter((TextFormatter)this.getDurationIntegerFormatter());
            this.mDurationTextField.setDisable(true);
        }
        return this.mDurationTextField;
    }

    private IntegerFormatter getDurationIntegerFormatter() {
        if (this.mDurationIntegerFormatter == null) {
            this.mDurationIntegerFormatter = new IntegerFormatter(1, 50);
            this.mDurationIntegerFormatter.valueProperty().addListener((ChangeListener)this.mDurationValueChangeListener);
        }
        return this.mDurationIntegerFormatter;
    }

    private class DurationValueChangeListener
    implements ChangeListener<Integer> {
        private boolean mEnabled = false;

        private DurationValueChangeListener() {
        }

        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            Tone selected;
            if (this.mEnabled && newValue != null && (selected = (Tone)TonesEditor.this.getToneListView().getSelectionModel().getSelectedItem()) != null) {
                selected.setDuration(newValue);
            }
        }

        public void enable() {
            this.mEnabled = true;
        }

        public void disable() {
            this.mEnabled = false;
        }
    }

    private class AmbeToneComboBoxEventHandler
    implements EventHandler<ActionEvent> {
        private boolean mEnabled = false;

        private AmbeToneComboBoxEventHandler() {
        }

        public void handle(ActionEvent event) {
            Tone selectedTone;
            if (this.mEnabled && (selectedTone = (Tone)TonesEditor.this.getToneListView().getSelectionModel().getSelectedItem()) != null) {
                AmbeTone ambeTone = (AmbeTone)((Object)TonesEditor.this.mAmbeToneComboBox.getSelectionModel().getSelectedItem());
                selectedTone.setAmbeTone(ambeTone);
                TonesEditor.this.modifiedProperty().set(true);
            }
        }

        public void enable() {
            this.mEnabled = true;
        }

        public void disable() {
            this.mEnabled = false;
        }
    }
}

