/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.talkgroup.P25FullyQualifiedTalkgroup;
import io.github.dsheirer.gui.control.HexFormatter;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25FullyQualifiedTalkgroupEditor
extends IdentifierEditor<P25FullyQualifiedTalkgroup> {
    private static final Logger mLog = LoggerFactory.getLogger(P25FullyQualifiedTalkgroupEditor.class);
    private UserPreferences mUserPreferences;
    private Label mProtocolLabel;
    private TextField mWacnField;
    private TextField mSystemField;
    private TextField mTalkgroupField;
    private TextFormatter<Integer> mWacnTextFormatter;
    private TextFormatter<Integer> mSystemTextFormatter;
    private TextFormatter<Integer> mTalkgroupTextFormatter;
    private WacnValueChangeListener mWacnValueChangeListener = new WacnValueChangeListener();
    private SystemValueChangeListener mSystemValueChangeListener = new SystemValueChangeListener();
    private TalkgroupValueChangeListener mTalkgroupValueChangeListener = new TalkgroupValueChangeListener();

    public P25FullyQualifiedTalkgroupEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        GridPane.setConstraints((Node)this.getProtocolLabel(), (int)0, (int)0);
        gridPane.getChildren().add((Object)this.getProtocolLabel());
        Label valueLabel = new Label("WACN");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)1, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getWacnField(), (int)2, (int)0);
        gridPane.getChildren().add((Object)this.getWacnField());
        Label systemLabel = new Label("System");
        GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)systemLabel, (int)3, (int)0);
        gridPane.getChildren().add((Object)systemLabel);
        GridPane.setConstraints((Node)this.getSystemField(), (int)4, (int)0);
        gridPane.getChildren().add((Object)this.getSystemField());
        Label radioLabel = new Label("Talkgroup");
        GridPane.setHalignment((Node)radioLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)radioLabel, (int)5, (int)0);
        gridPane.getChildren().add((Object)radioLabel);
        GridPane.setConstraints((Node)this.getTalkgroupField(), (int)6, (int)0);
        gridPane.getChildren().add((Object)this.getTalkgroupField());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(P25FullyQualifiedTalkgroup item) {
        super.setItem(item);
        P25FullyQualifiedTalkgroup fqt = (P25FullyQualifiedTalkgroup)this.getItem();
        this.getProtocolLabel().setDisable(fqt == null);
        this.getWacnField().setDisable(fqt == null);
        this.getSystemField().setDisable(fqt == null);
        this.getTalkgroupField().setDisable(fqt == null);
        if (fqt != null) {
            this.getProtocolLabel().setText(fqt.getProtocol().toString());
            this.updateTextFormatter();
        } else {
            this.getWacnField().setText(null);
            this.getSystemField().setText(null);
            this.getTalkgroupField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    private void updateTextFormatter() {
        IntegerFormat format;
        if (this.mWacnTextFormatter != null) {
            this.mWacnTextFormatter.valueProperty().removeListener((ChangeListener)this.mWacnValueChangeListener);
        }
        if (this.mSystemTextFormatter != null) {
            this.mSystemTextFormatter.valueProperty().removeListener((ChangeListener)this.mSystemValueChangeListener);
        }
        if (this.mTalkgroupTextFormatter != null) {
            this.mTalkgroupTextFormatter.valueProperty().removeListener((ChangeListener)this.mTalkgroupValueChangeListener);
        }
        if (!((format = this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(((P25FullyQualifiedTalkgroup)this.getItem()).getProtocol())) != IntegerFormat.DECIMAL || this.mTalkgroupTextFormatter != null && this.mTalkgroupTextFormatter instanceof IntegerFormatter)) {
            this.mWacnTextFormatter = new IntegerFormatter(0, 1048575);
            this.mSystemTextFormatter = new IntegerFormatter(0, 4095);
            this.mTalkgroupTextFormatter = new IntegerFormatter(0, 65535);
            this.mWacnField.setTooltip(new Tooltip("Format: 0 - 1048575"));
            this.mSystemField.setTooltip(new Tooltip("Format: 0 - 4095"));
            this.mTalkgroupField.setTooltip(new Tooltip("Format: 0 - 65535"));
        } else if (!(format != IntegerFormat.HEXADECIMAL || this.mTalkgroupTextFormatter != null && this.mTalkgroupTextFormatter instanceof HexFormatter)) {
            this.mWacnTextFormatter = new HexFormatter(0, 1048575);
            this.mSystemTextFormatter = new HexFormatter(0, 4095);
            this.mTalkgroupTextFormatter = new HexFormatter(0, 0xFFFFFF);
            this.mWacnField.setTooltip(new Tooltip("Format: 0 - FFFFF"));
            this.mSystemField.setTooltip(new Tooltip("Format: 0 - FFF"));
            this.mTalkgroupField.setTooltip(new Tooltip("Format: 0 - FFFF"));
        }
        this.mWacnField.setTextFormatter(this.mWacnTextFormatter);
        this.mSystemField.setTextFormatter(this.mSystemTextFormatter);
        this.mTalkgroupField.setTextFormatter(this.mTalkgroupTextFormatter);
        this.mWacnTextFormatter.setValue(this.getItem() != null ? Integer.valueOf(((P25FullyQualifiedTalkgroup)this.getItem()).getWacn()) : null);
        this.mSystemTextFormatter.setValue(this.getItem() != null ? Integer.valueOf(((P25FullyQualifiedTalkgroup)this.getItem()).getSystem()) : null);
        this.mTalkgroupTextFormatter.setValue(this.getItem() != null ? Integer.valueOf(((P25FullyQualifiedTalkgroup)this.getItem()).getValue()) : null);
        this.mWacnTextFormatter.valueProperty().addListener((ChangeListener)this.mWacnValueChangeListener);
        this.mSystemTextFormatter.valueProperty().addListener((ChangeListener)this.mSystemValueChangeListener);
        this.mTalkgroupTextFormatter.valueProperty().addListener((ChangeListener)this.mTalkgroupValueChangeListener);
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private Label getProtocolLabel() {
        if (this.mProtocolLabel == null) {
            this.mProtocolLabel = new Label();
        }
        return this.mProtocolLabel;
    }

    private TextField getWacnField() {
        if (this.mWacnField == null) {
            this.mWacnField = new TextField();
            this.mWacnField.setTextFormatter(this.mWacnTextFormatter);
        }
        return this.mWacnField;
    }

    private TextField getSystemField() {
        if (this.mSystemField == null) {
            this.mSystemField = new TextField();
            this.mSystemField.setTextFormatter(this.mSystemTextFormatter);
        }
        return this.mSystemField;
    }

    private TextField getTalkgroupField() {
        if (this.mTalkgroupField == null) {
            this.mTalkgroupField = new TextField();
            this.mTalkgroupField.setTextFormatter(this.mTalkgroupTextFormatter);
        }
        return this.mTalkgroupField;
    }

    public class WacnValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (P25FullyQualifiedTalkgroupEditor.this.getItem() != null) {
                ((P25FullyQualifiedTalkgroup)P25FullyQualifiedTalkgroupEditor.this.getItem()).setWacn(newValue != null ? newValue : 0);
                P25FullyQualifiedTalkgroupEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class SystemValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (P25FullyQualifiedTalkgroupEditor.this.getItem() != null) {
                ((P25FullyQualifiedTalkgroup)P25FullyQualifiedTalkgroupEditor.this.getItem()).setSystem(newValue != null ? newValue : 0);
                P25FullyQualifiedTalkgroupEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class TalkgroupValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (P25FullyQualifiedTalkgroupEditor.this.getItem() != null) {
                ((P25FullyQualifiedTalkgroup)P25FullyQualifiedTalkgroupEditor.this.getItem()).setValue(newValue != null ? newValue : 0);
                P25FullyQualifiedTalkgroupEditor.this.modifiedProperty().set(true);
            }
        }
    }
}

