/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.action;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasFactory;
import io.github.dsheirer.alias.action.AliasAction;
import io.github.dsheirer.alias.action.RecurringAction;
import io.github.dsheirer.alias.action.beep.BeepAction;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.action.ActionEditor;
import io.github.dsheirer.gui.playlist.alias.action.TestMessage;
import io.github.dsheirer.util.ThreadPool;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeepEditor
extends ActionEditor<BeepAction> {
    private static final Logger mLog = LoggerFactory.getLogger(BeepEditor.class);
    private static final String UNTIL_DISMISSED_LABEL = "second intervals (1-60)";
    private static final String DELAY_LABEL = "second delay (1-60)";
    private ComboBoxChangeListener mComboBoxChangeListener = new ComboBoxChangeListener();
    private PeriodChangeListener mPeriodChangeListener = new PeriodChangeListener();
    private ComboBox<RecurringAction.Interval> mIntervalComboBox;
    private TextField mPeriodTextField;
    private IntegerFormatter mPeriodFormatter;
    private Label mSecondsLabel;
    private Button mTestButton;

    public BeepEditor() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        int row = 0;
        Label intervalLabel = new Label("Beep");
        GridPane.setHalignment((Node)intervalLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)intervalLabel, (int)0, (int)row);
        gridPane.getChildren().add((Object)intervalLabel);
        GridPane.setConstraints(this.getIntervalComboBox(), (int)1, (int)row);
        gridPane.getChildren().add(this.getIntervalComboBox());
        GridPane.setConstraints((Node)this.getPeriodTextField(), (int)2, (int)row);
        gridPane.getChildren().add((Object)this.getPeriodTextField());
        GridPane.setHalignment((Node)this.getSecondsLabel(), (HPos)HPos.LEFT);
        GridPane.setConstraints((Node)this.getSecondsLabel(), (int)3, (int)row);
        GridPane.setHgrow((Node)this.getSecondsLabel(), (Priority)Priority.ALWAYS);
        gridPane.getChildren().add((Object)this.getSecondsLabel());
        GridPane.setConstraints((Node)this.getTestButton(), (int)4, (int)row);
        gridPane.getChildren().add((Object)this.getTestButton());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(BeepAction beepAction) {
        super.setItem(beepAction);
        this.mComboBoxChangeListener.disable();
        this.mPeriodChangeListener.disable();
        this.getIntervalComboBox().setDisable(beepAction == null);
        if (beepAction != null) {
            RecurringAction.Interval interval = beepAction.getInterval();
            this.getIntervalComboBox().getSelectionModel().select((Object)interval);
            this.getPeriodFormatter().setValue(beepAction.getPeriod());
        } else {
            this.getIntervalComboBox().getSelectionModel().select(null);
            this.getPeriodFormatter().setValue(null);
        }
        this.updatePeriodAndLabel();
        this.mComboBoxChangeListener.enable();
        this.mPeriodChangeListener.enable();
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private void test() {
        if (this.getItem() != null) {
            AliasAction action = AliasFactory.copyOf((AliasAction)this.getItem());
            TestMessage testMessage = new TestMessage();
            Alias testAlias = new Alias("Test Alias");
            ThreadPool.CACHED.submit(() -> {
                try {
                    action.execute(testAlias, testMessage);
                }
                catch (Exception e) {
                    mLog.error("Error testing beep action", (Throwable)e);
                }
            });
        }
    }

    private Button getTestButton() {
        if (this.mTestButton == null) {
            this.mTestButton = new Button("Test");
            this.mTestButton.setMaxWidth(Double.MAX_VALUE);
            this.mTestButton.setOnAction(event -> this.test());
        }
        return this.mTestButton;
    }

    private Label getSecondsLabel() {
        if (this.mSecondsLabel == null) {
            this.mSecondsLabel = new Label("second delay (1 - 60)");
            this.mSecondsLabel.setMaxWidth(Double.MAX_VALUE);
            this.mSecondsLabel.setVisible(false);
            this.mSecondsLabel.setAlignment(Pos.CENTER_LEFT);
        }
        return this.mSecondsLabel;
    }

    private ComboBox<RecurringAction.Interval> getIntervalComboBox() {
        if (this.mIntervalComboBox == null) {
            this.mIntervalComboBox = new ComboBox();
            this.mIntervalComboBox.setDisable(true);
            this.mIntervalComboBox.getItems().setAll((Object[])RecurringAction.Interval.values());
            this.mIntervalComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)this.mComboBoxChangeListener);
        }
        return this.mIntervalComboBox;
    }

    private TextField getPeriodTextField() {
        if (this.mPeriodTextField == null) {
            this.mPeriodTextField = new TextField();
            this.mPeriodTextField.setPrefWidth(40.0);
            this.mPeriodTextField.setVisible(false);
            this.mPeriodTextField.setTextFormatter((TextFormatter)this.getPeriodFormatter());
        }
        return this.mPeriodTextField;
    }

    private IntegerFormatter getPeriodFormatter() {
        if (this.mPeriodFormatter == null) {
            this.mPeriodFormatter = new IntegerFormatter(1, 60);
            this.mPeriodFormatter.valueProperty().addListener((ChangeListener)this.mPeriodChangeListener);
        }
        return this.mPeriodFormatter;
    }

    private void updatePeriodAndLabel() {
        RecurringAction.Interval selected = (RecurringAction.Interval)((Object)this.getIntervalComboBox().getSelectionModel().getSelectedItem());
        if (selected != null) {
            switch (selected) {
                case ONCE: {
                    this.getPeriodTextField().setVisible(false);
                    this.getSecondsLabel().setVisible(false);
                    break;
                }
                case DELAYED_RESET: {
                    this.getPeriodTextField().setVisible(true);
                    this.getSecondsLabel().setVisible(true);
                    this.getSecondsLabel().setText(DELAY_LABEL);
                    break;
                }
                case UNTIL_DISMISSED: {
                    this.getPeriodTextField().setVisible(true);
                    this.getSecondsLabel().setVisible(true);
                    this.getSecondsLabel().setText(UNTIL_DISMISSED_LABEL);
                }
            }
        } else {
            this.getPeriodTextField().setVisible(false);
            this.getSecondsLabel().setVisible(false);
        }
    }

    private class ComboBoxChangeListener
    implements ChangeListener<RecurringAction.Interval> {
        private boolean mEnabled = false;

        private ComboBoxChangeListener() {
        }

        public void changed(ObservableValue<? extends RecurringAction.Interval> observable, RecurringAction.Interval oldValue, RecurringAction.Interval newValue) {
            mLog.debug("I Changed - new value: " + String.valueOf((Object)newValue) + " not null:" + (BeepEditor.this.getItem() != null));
            if (this.mEnabled) {
                RecurringAction.Interval selected = (RecurringAction.Interval)((Object)BeepEditor.this.getIntervalComboBox().getSelectionModel().getSelectedItem());
                if (selected != null && BeepEditor.this.getItem() != null) {
                    mLog.debug("Setting interval to " + String.valueOf((Object)selected));
                    ((BeepAction)BeepEditor.this.getItem()).setInterval(selected);
                    BeepEditor.this.modifiedProperty().set(true);
                }
                BeepEditor.this.updatePeriodAndLabel();
            }
        }

        public void enable() {
            this.mEnabled = true;
        }

        public void disable() {
            this.mEnabled = false;
        }
    }

    private class PeriodChangeListener
    implements ChangeListener<Integer> {
        private boolean mEnabled = false;

        private PeriodChangeListener() {
        }

        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (this.mEnabled) {
                if (newValue != null) {
                    ((BeepAction)BeepEditor.this.getItem()).setPeriod(newValue);
                } else {
                    ((BeepAction)BeepEditor.this.getItem()).setPeriod(5);
                }
            }
        }

        public void enable() {
            this.mEnabled = true;
        }

        public void disable() {
            this.mEnabled = false;
        }
    }
}

