/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias;

import com.google.common.collect.Ordering;
import com.google.common.eventbus.Subscribe;
import impl.org.controlsfx.autocompletion.AutoCompletionTextFieldBinding;
import impl.org.controlsfx.autocompletion.SuggestionProvider;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasFactory;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.action.AliasAction;
import io.github.dsheirer.alias.action.AliasActionType;
import io.github.dsheirer.alias.action.beep.BeepAction;
import io.github.dsheirer.alias.action.clip.ClipAction;
import io.github.dsheirer.alias.action.script.ScriptAction;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.alias.id.dcs.Dcs;
import io.github.dsheirer.alias.id.esn.Esn;
import io.github.dsheirer.alias.id.lojack.LoJackFunctionAndID;
import io.github.dsheirer.alias.id.radio.P25FullyQualifiedRadio;
import io.github.dsheirer.alias.id.radio.Radio;
import io.github.dsheirer.alias.id.radio.RadioFormatter;
import io.github.dsheirer.alias.id.radio.RadioRange;
import io.github.dsheirer.alias.id.status.UnitStatusID;
import io.github.dsheirer.alias.id.status.UserStatusID;
import io.github.dsheirer.alias.id.talkgroup.P25FullyQualifiedTalkgroup;
import io.github.dsheirer.alias.id.talkgroup.Talkgroup;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupFormatter;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupRange;
import io.github.dsheirer.alias.id.tone.TonesID;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.gui.playlist.alias.ColorUtil;
import io.github.dsheirer.gui.playlist.alias.ViewAliasIdentifierRequest;
import io.github.dsheirer.gui.playlist.alias.action.ActionEditor;
import io.github.dsheirer.gui.playlist.alias.action.ActionEditorFactory;
import io.github.dsheirer.gui.playlist.alias.action.EmptyActionEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.EmptyIdentifierEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditorFactory;
import io.github.dsheirer.icon.Icon;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.protocol.Protocol;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasItemEditor
extends Editor<Alias> {
    private static final Logger mLog = LoggerFactory.getLogger(AliasItemEditor.class);
    private PlaylistManager mPlaylistManager;
    private UserPreferences mUserPreferences;
    private EditorModificationListener mEditorModificationListener = new EditorModificationListener();
    private IdentifierEditorModificationListener mIdentifierEditorModificationListener = new IdentifierEditorModificationListener();
    private ActionEditorModificationListener mActionEditorModificationListener = new ActionEditorModificationListener();
    private TextField mGroupField;
    private TextField mNameField;
    private GridPane mTextFieldPane;
    private Button mSaveButton;
    private Button mResetButton;
    private VBox mButtonBox;
    private ToggleSwitch mMonitorAudioToggleSwitch;
    private ComboBox<Integer> mMonitorPriorityComboBox;
    private ToggleSwitch mRecordAudioToggleSwitch;
    private ColorPicker mColorPicker;
    private ComboBox<Icon> mIconNodeComboBox;
    private SuggestionProvider<String> mGroupSuggestionProvider;
    private VBox mTitledPanesBox;
    private TitledPane mIdentifierPane;
    private TitledPane mStreamPane;
    private TitledPane mActionPane;
    private ListView<String> mAvailableStreamsView;
    private ListView<BroadcastChannel> mSelectedStreamsView;
    private ListView<AliasID> mIdentifiersList;
    private ListView<AliasAction> mActionsList;
    private Button mAddStreamButton;
    private Button mRemoveStreamButton;
    private MenuButton mAddIdentifierButton;
    private Button mDeleteIdentifierButton;
    private Button mShowOverlapButton;
    private MenuButton mAddActionButton;
    private Button mDeleteActionButton;
    private VBox mActionEditorBox;
    private VBox mIdentifierEditorBox;
    private Map<AliasIDType, IdentifierEditor> mIdentifierEditorMap = new HashMap<AliasIDType, IdentifierEditor>();
    private EmptyIdentifierEditor mEmptyIdentifierEditor = new EmptyIdentifierEditor();
    private IdentifierEditor mIdentifierEditor;
    private Map<AliasActionType, ActionEditor> mActionEditorMap = new HashMap<AliasActionType, ActionEditor>();
    private EmptyActionEditor mEmptyActionEditor = new EmptyActionEditor();
    private ActionEditor mActionEditor;

    public AliasItemEditor(PlaylistManager playlistManager, UserPreferences userPreferences) {
        this.mPlaylistManager = playlistManager;
        this.mUserPreferences = userPreferences;
        this.mPlaylistManager.getBroadcastModel().getConfiguredBroadcasts().addListener(c -> this.updateStreamViews());
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.setMaxWidth(Double.MAX_VALUE);
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{this.getTextFieldPane(), this.getTitledPanesBox()});
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToWidth(true);
        scrollPane.setContent((Node)vbox);
        HBox hbox = new HBox();
        hbox.setMaxWidth(Double.MAX_VALUE);
        hbox.setSpacing(10.0);
        HBox.setHgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getButtonBox(), (Priority)Priority.NEVER);
        hbox.getChildren().addAll((Object[])new Node[]{scrollPane, this.getButtonBox()});
        this.getChildren().add((Object)hbox);
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        AliasID selected;
        if (preferenceType == PreferenceType.TALKGROUP_FORMAT) {
            for (AliasID id : this.mIdentifiersList.getItems()) {
                id.valueProperty().setValue(null);
                id.updateValueProperty();
            }
        }
        if ((selected = (AliasID)this.getIdentifiersList().getSelectionModel().getSelectedItem()) != null) {
            this.getIdentifierEditor().setItem(selected);
        }
    }

    @Override
    public void setItem(Alias alias) {
        super.setItem(alias);
        this.refreshAutoCompleteBindings();
        boolean disable = alias == null;
        this.getGroupField().setDisable(disable);
        this.getNameField().setDisable(disable);
        this.getRecordAudioToggleSwitch().setDisable(disable);
        this.getColorPicker().setDisable(disable);
        this.getMonitorAudioToggleSwitch().setDisable(disable);
        this.getIconNodeComboBox().setDisable(disable);
        this.getIdentifiersList().setDisable(disable);
        this.getIdentifiersList().getItems().clear();
        this.getAddIdentifierButton().setDisable(disable);
        this.getActionsList().setDisable(disable);
        this.getActionsList().getItems().clear();
        this.getAddActionButton().setDisable(disable);
        this.updateStreamViews();
        if (alias != null) {
            Object copy;
            this.getGroupField().setText(alias.getGroup());
            this.getNameField().setText(alias.getName());
            this.getRecordAudioToggleSwitch().setSelected(alias.isRecordable());
            Icon icon = null;
            String iconName = alias.getIconName();
            if (iconName != null) {
                icon = this.mPlaylistManager.getIconModel().getIcon(iconName);
            }
            this.getIconNodeComboBox().getSelectionModel().select(icon);
            int monitorPriority = alias.getPlaybackPriority();
            boolean canMonitor = monitorPriority != -1;
            this.getMonitorAudioToggleSwitch().setSelected(canMonitor);
            if (canMonitor && monitorPriority != 100) {
                this.getMonitorPriorityComboBox().getSelectionModel().select(monitorPriority);
            } else {
                this.getMonitorPriorityComboBox().getSelectionModel().select(null);
            }
            Color color = ColorUtil.fromInteger(alias.getColor());
            this.getColorPicker().setValue((Object)color);
            for (AliasID aliasID : alias.getAliasIdentifiers()) {
                if (aliasID.isAudioIdentifier()) continue;
                copy = AliasFactory.copyOf(aliasID);
                if (copy != null) {
                    this.getIdentifiersList().getItems().add(copy);
                    continue;
                }
                this.getIdentifiersList().getItems().add((Object)aliasID);
            }
            for (AliasAction original : alias.getAliasActions()) {
                copy = AliasFactory.copyOf(original);
                if (copy != null) {
                    this.getActionsList().getItems().add(copy);
                    continue;
                }
                mLog.warn("Unable to create copy of alias action [" + String.valueOf((Object)original.getType()) + "] for alias [" + alias.getName() + "] - action will be lost if alias is saved");
            }
        } else {
            this.getGroupField().setText(null);
            this.getNameField().setText(null);
            this.getRecordAudioToggleSwitch().setSelected(false);
            this.getColorPicker().setValue((Object)Color.BLACK);
            this.getMonitorPriorityComboBox().getSelectionModel().select(null);
            this.getMonitorAudioToggleSwitch().setSelected(false);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
        if (this.modifiedProperty().get()) {
            Alias alias = (Alias)this.getItem();
            if (alias != null) {
                alias.setRecordable(this.getRecordAudioToggleSwitch().isSelected());
                alias.setColor(ColorUtil.toInteger((Color)this.getColorPicker().getValue()));
                Icon icon = (Icon)this.getIconNodeComboBox().getSelectionModel().getSelectedItem();
                alias.setIconName(icon != null ? icon.getName() : null);
                boolean canMonitor = this.getMonitorAudioToggleSwitch().isSelected();
                Integer priority = (Integer)this.getMonitorPriorityComboBox().getSelectionModel().getSelectedItem();
                if (canMonitor) {
                    if (priority == null) {
                        priority = 100;
                    }
                    alias.setCallPriority(priority);
                } else {
                    alias.setCallPriority(-1);
                }
                alias.removeAllBroadcastChannels();
                for (BroadcastChannel selected : this.getSelectedStreamsView().getItems()) {
                    alias.addAliasID(selected);
                }
                alias.removeNonAudioIdentifiers();
                for (AliasID aliasID : this.getIdentifiersList().getItems()) {
                    AliasID copy = AliasFactory.copyOf(aliasID);
                    copy.setOverlap(false);
                    alias.addAliasID(copy);
                }
                alias.removeAllActions();
                for (AliasAction aliasAction : this.getActionsList().getItems()) {
                    alias.addAliasAction(aliasAction);
                }
                try {
                    alias.setName(this.getNameField().getText());
                }
                catch (Exception e) {
                    mLog.error("Error while updating alias name.", (Throwable)e);
                }
                try {
                    alias.setGroup(this.getGroupField().getText());
                }
                catch (Exception e) {
                    mLog.error("Error while updating alias group value", (Throwable)e);
                }
            }
            AliasList aliasList = this.mPlaylistManager.getAliasModel().getAliasList(alias.getAliasListName());
            aliasList.updateAlias(alias);
            this.setItem(alias);
            this.modifiedProperty().set(false);
        }
    }

    @Override
    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
    }

    private VBox getTitledPanesBox() {
        if (this.mTitledPanesBox == null) {
            this.mTitledPanesBox = new VBox();
            this.mTitledPanesBox.setMaxWidth(Double.MAX_VALUE);
            this.mTitledPanesBox.getChildren().addAll((Object[])new Node[]{this.getIdentifierPane(), this.getStreamPane(), this.getActionPane()});
        }
        return this.mTitledPanesBox;
    }

    private TitledPane getIdentifierPane() {
        if (this.mIdentifierPane == null) {
            VBox buttonsBox = new VBox();
            buttonsBox.setSpacing(10.0);
            buttonsBox.getChildren().addAll((Object[])new Node[]{this.getAddIdentifierButton(), this.getDeleteIdentifierButton(), this.getShowOverlapButton()});
            HBox identifiersAndButtonsBox = new HBox();
            identifiersAndButtonsBox.setSpacing(10.0);
            HBox.setHgrow((Node)this.getIdentifierEditorBox(), (Priority)Priority.ALWAYS);
            identifiersAndButtonsBox.getChildren().addAll((Object[])new Node[]{this.getIdentifierEditorBox(), buttonsBox});
            this.mIdentifierPane = new TitledPane("Identifiers", (Node)identifiersAndButtonsBox);
        }
        return this.mIdentifierPane;
    }

    private VBox getIdentifierEditorBox() {
        if (this.mIdentifierEditorBox == null) {
            this.mIdentifierEditorBox = new VBox();
            this.mIdentifierEditorBox.setSpacing(10.0);
            this.mIdentifierEditorBox.getChildren().addAll((Object[])new Node[]{this.getIdentifiersList(), this.getIdentifierEditor()});
        }
        return this.mIdentifierEditorBox;
    }

    private Editor<AliasID> getIdentifierEditor() {
        if (this.mIdentifierEditor == null) {
            this.mIdentifierEditor = this.mEmptyIdentifierEditor;
        }
        return this.mIdentifierEditor;
    }

    private Editor<AliasAction> getActionEditor() {
        if (this.mActionEditor == null) {
            this.mActionEditor = this.mEmptyActionEditor;
        }
        return this.mActionEditor;
    }

    private void setAction(AliasAction aliasAction) {
        ActionEditor editor = null;
        if (aliasAction != null && (editor = this.mActionEditorMap.get((Object)aliasAction.getType())) == null) {
            editor = ActionEditorFactory.getEditor(aliasAction.getType(), this.mUserPreferences);
            this.mActionEditorMap.put(aliasAction.getType(), editor);
        }
        this.getDeleteActionButton().setDisable(aliasAction == null);
        if (editor == null) {
            editor = this.mEmptyActionEditor;
        }
        if (this.mActionEditor != null) {
            this.mActionEditor.modifiedProperty().removeListener((ChangeListener)this.mActionEditorModificationListener);
        }
        if (this.mActionEditor != editor) {
            this.getActionEditorBox().getChildren().remove((Object)this.mActionEditor);
            this.mActionEditor = editor;
            this.getActionEditorBox().getChildren().add((Object)this.mActionEditor);
        }
        this.mActionEditor.setItem(aliasAction);
        this.mActionEditor.modifiedProperty().addListener((ChangeListener)this.mActionEditorModificationListener);
    }

    private ListView<AliasAction> getActionsList() {
        if (this.mActionsList == null) {
            this.mActionsList = new ListView(FXCollections.observableArrayList(AliasAction.extractor()));
            this.mActionsList.setPrefHeight(75.0);
            this.mActionsList.setDisable(true);
            this.mActionsList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setAction((AliasAction)newValue));
        }
        return this.mActionsList;
    }

    private MenuButton getAddActionButton() {
        if (this.mAddActionButton == null) {
            this.mAddActionButton = new MenuButton("Add Action");
            this.mAddActionButton.setDisable(true);
            this.mAddActionButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddActionButton.getItems().addAll((Object[])new MenuItem[]{new AddAudioClipActionItem(), new AddBeepActionItem(), new AddScriptActionItem()});
        }
        return this.mAddActionButton;
    }

    private Button getDeleteActionButton() {
        if (this.mDeleteActionButton == null) {
            this.mDeleteActionButton = new Button("Delete Action");
            this.mDeleteActionButton.setDisable(true);
            this.mDeleteActionButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteActionButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    AliasAction selected = (AliasAction)AliasItemEditor.this.getActionsList().getSelectionModel().getSelectedItem();
                    if (selected != null) {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to delete the selected alias action?", new ButtonType[]{ButtonType.NO, ButtonType.YES});
                        alert.setTitle("Delete Alias Action");
                        alert.setHeaderText("Are you sure?");
                        alert.initOwner(AliasItemEditor.this.getDeleteActionButton().getScene().getWindow());
                        Optional result = alert.showAndWait();
                        if (result.get() == ButtonType.YES) {
                            AliasItemEditor.this.getActionsList().getItems().remove((Object)selected);
                            AliasItemEditor.this.modifiedProperty().set(true);
                        }
                    }
                }
            });
        }
        return this.mDeleteActionButton;
    }

    private void setIdentifier(AliasID aliasID) {
        IdentifierEditor editor = null;
        if (aliasID != null && (editor = this.mIdentifierEditorMap.get((Object)aliasID.getType())) == null) {
            editor = IdentifierEditorFactory.getEditor(aliasID.getType(), this.mUserPreferences);
            this.mIdentifierEditorMap.put(aliasID.getType(), editor);
        }
        this.getDeleteIdentifierButton().setDisable(aliasID == null);
        this.getShowOverlapButton().setVisible(aliasID != null && aliasID.overlapProperty().get());
        if (editor == null) {
            editor = this.mEmptyIdentifierEditor;
        }
        if (this.mIdentifierEditor != null) {
            this.mIdentifierEditor.modifiedProperty().removeListener((ChangeListener)this.mIdentifierEditorModificationListener);
        }
        if (this.mIdentifierEditor != editor) {
            this.getIdentifierEditorBox().getChildren().remove((Object)this.mIdentifierEditor);
            this.mIdentifierEditor = editor;
            this.getIdentifierEditorBox().getChildren().add((Object)this.mIdentifierEditor);
        }
        this.mIdentifierEditor.setItem(aliasID);
        this.mIdentifierEditor.modifiedProperty().addListener((ChangeListener)this.mIdentifierEditorModificationListener);
    }

    private ListView<AliasID> getIdentifiersList() {
        if (this.mIdentifiersList == null) {
            this.mIdentifiersList = new ListView(FXCollections.observableArrayList(AliasID.extractor()));
            this.mIdentifiersList.setDisable(true);
            this.mIdentifiersList.setPrefHeight(75.0);
            this.mIdentifiersList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setIdentifier((AliasID)newValue));
            this.mIdentifiersList.setCellFactory(param -> new AliasIdentifierCell());
        }
        return this.mIdentifiersList;
    }

    private Button getShowOverlapButton() {
        if (this.mShowOverlapButton == null) {
            this.mShowOverlapButton = new Button("Show Overlap");
            this.mShowOverlapButton.setMaxWidth(Double.MAX_VALUE);
            this.mShowOverlapButton.setVisible(false);
            this.mShowOverlapButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    AliasID selected = (AliasID)AliasItemEditor.this.getIdentifiersList().getSelectionModel().getSelectedItem();
                    if (selected != null) {
                        MyEventBus.getGlobalEventBus().post((Object)new ViewAliasIdentifierRequest(selected));
                    }
                }
            });
        }
        return this.mShowOverlapButton;
    }

    private MenuButton getAddIdentifierButton() {
        if (this.mAddIdentifierButton == null) {
            this.mAddIdentifierButton = new MenuButton("Add Identifier");
            this.mAddIdentifierButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddIdentifierButton.setDisable(true);
            ProtocolMenu amMenu = new ProtocolMenu(this, Protocol.AM);
            amMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.AM));
            amMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.AM));
            ProtocolMenu p25Menu = new ProtocolMenu(this, Protocol.APCO25);
            p25Menu.getItems().add((Object)new AddTalkgroupItem(Protocol.APCO25));
            p25Menu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.APCO25));
            p25Menu.getItems().add((Object)new AddP25FullyQualifiedTalkgroupItem());
            p25Menu.getItems().add((Object)new AddRadioIdItem(Protocol.APCO25));
            p25Menu.getItems().add((Object)new AddRadioIdRangeItem(Protocol.APCO25));
            p25Menu.getItems().add((Object)new AddP25FullyQualifiedRadioIdItem());
            p25Menu.getItems().add((Object)new SeparatorMenuItem());
            p25Menu.getItems().add((Object)new AddUserStatusItem());
            p25Menu.getItems().add((Object)new AddUnitStatusItem());
            p25Menu.getItems().add((Object)new SeparatorMenuItem());
            p25Menu.getItems().add((Object)new AddTonesItem("Audio Tones (Phase 2 Only)"));
            ProtocolMenu dmrMenu = new ProtocolMenu(this, Protocol.DMR);
            dmrMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.DMR));
            dmrMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.DMR));
            dmrMenu.getItems().add((Object)new AddRadioIdItem(Protocol.DMR));
            dmrMenu.getItems().add((Object)new AddRadioIdRangeItem(Protocol.DMR));
            ProtocolMenu fleetsyncMenu = new ProtocolMenu(this, Protocol.FLEETSYNC);
            fleetsyncMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.FLEETSYNC));
            fleetsyncMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.FLEETSYNC));
            ProtocolMenu ltrMenu = new ProtocolMenu(this, Protocol.LTR);
            ltrMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.LTR));
            ltrMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.LTR));
            ProtocolMenu mdcMenu = new ProtocolMenu(this, Protocol.MDC1200);
            mdcMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.MDC1200));
            mdcMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.MDC1200));
            ProtocolMenu mptMenu = new ProtocolMenu(this, Protocol.MPT1327);
            mptMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.MPT1327));
            mptMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.MPT1327));
            ProtocolMenu nbfmMenu = new ProtocolMenu(this, Protocol.NBFM);
            nbfmMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.NBFM));
            nbfmMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.NBFM));
            nbfmMenu.getItems().add((Object)new AddDcsItem());
            ProtocolMenu passportMenu = new ProtocolMenu(this, Protocol.PASSPORT);
            passportMenu.getItems().add((Object)new AddTalkgroupItem(Protocol.PASSPORT));
            passportMenu.getItems().add((Object)new AddTalkgroupRangeItem(Protocol.PASSPORT));
            passportMenu.getItems().add((Object)new AddRadioIdItem(Protocol.PASSPORT));
            passportMenu.getItems().add((Object)new AddRadioIdRangeItem(Protocol.PASSPORT));
            ProtocolMenu taitMenu = new ProtocolMenu(this, Protocol.TAIT1200);
            taitMenu.setDisable(true);
            ProtocolMenu lojackMenu = new ProtocolMenu(this, Protocol.LOJACK);
            lojackMenu.getItems().add((Object)new AddLojackItem());
            this.mAddIdentifierButton.getItems().addAll((Object[])new MenuItem[]{amMenu, p25Menu, dmrMenu, fleetsyncMenu, ltrMenu, mdcMenu, mptMenu, nbfmMenu, passportMenu, taitMenu, new SeparatorMenuItem(), lojackMenu});
        }
        return this.mAddIdentifierButton;
    }

    private Button getDeleteIdentifierButton() {
        if (this.mDeleteIdentifierButton == null) {
            this.mDeleteIdentifierButton = new Button("Delete Identifier");
            this.mDeleteIdentifierButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteIdentifierButton.setDisable(true);
            this.mDeleteIdentifierButton.setOnAction(event -> {
                AliasID selected = (AliasID)this.getIdentifiersList().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to delete the selected alias identifier?", new ButtonType[]{ButtonType.NO, ButtonType.YES});
                    alert.setTitle("Delete Alias Identifier");
                    alert.setHeaderText("Are you sure?");
                    alert.initOwner(this.getDeleteIdentifierButton().getScene().getWindow());
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.YES) {
                        this.getIdentifiersList().getItems().remove((Object)selected);
                        this.modifiedProperty().set(true);
                    }
                }
            });
        }
        return this.mDeleteIdentifierButton;
    }

    private TitledPane getStreamPane() {
        if (this.mStreamPane == null) {
            VBox buttonBox = new VBox();
            buttonBox.setMaxHeight(Double.MAX_VALUE);
            buttonBox.setAlignment(Pos.CENTER);
            buttonBox.setSpacing(5.0);
            buttonBox.getChildren().addAll((Object[])new Node[]{new Label(" "), this.getAddStreamButton(), this.getRemoveStreamButton()});
            VBox availableBox = new VBox();
            VBox.setVgrow(this.getAvailableStreamsView(), (Priority)Priority.ALWAYS);
            availableBox.getChildren().addAll((Object[])new Node[]{new Label("Available"), this.getAvailableStreamsView()});
            VBox selectedBox = new VBox();
            VBox.setVgrow(this.getSelectedStreamsView(), (Priority)Priority.ALWAYS);
            selectedBox.getChildren().addAll((Object[])new Node[]{new Label("Selected"), this.getSelectedStreamsView()});
            HBox hbox = new HBox();
            hbox.setSpacing(10.0);
            HBox.setHgrow((Node)availableBox, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)selectedBox, (Priority)Priority.ALWAYS);
            hbox.getChildren().addAll((Object[])new Node[]{availableBox, buttonBox, selectedBox});
            this.mStreamPane = new TitledPane("Streaming", (Node)hbox);
            this.mStreamPane.setExpanded(false);
        }
        return this.mStreamPane;
    }

    private void updateStreamViews() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AliasItemEditor.this.getAvailableStreamsView().getItems().clear();
                AliasItemEditor.this.getSelectedStreamsView().getItems().clear();
                AliasItemEditor.this.getAvailableStreamsView().setDisable(AliasItemEditor.this.getItem() == null);
                AliasItemEditor.this.getSelectedStreamsView().setDisable(AliasItemEditor.this.getItem() == null);
                if (AliasItemEditor.this.getItem() != null) {
                    List<String> availableStreams = AliasItemEditor.this.mPlaylistManager.getBroadcastModel().getBroadcastConfigurationNames();
                    Set<BroadcastChannel> selectedChannels = ((Alias)AliasItemEditor.this.getItem()).getBroadcastChannels();
                    for (BroadcastChannel channel : selectedChannels) {
                        if (!availableStreams.contains(channel.getChannelName())) continue;
                        availableStreams.remove(channel.getChannelName());
                    }
                    AliasItemEditor.this.getSelectedStreamsView().getItems().addAll(selectedChannels);
                    AliasItemEditor.this.getAvailableStreamsView().getItems().addAll(availableStreams);
                }
            }
        });
    }

    private ListView<String> getAvailableStreamsView() {
        if (this.mAvailableStreamsView == null) {
            this.mAvailableStreamsView = new ListView();
            this.mAvailableStreamsView.setDisable(true);
            this.mAvailableStreamsView.setPrefHeight(75.0);
        }
        return this.mAvailableStreamsView;
    }

    private ListView<BroadcastChannel> getSelectedStreamsView() {
        if (this.mSelectedStreamsView == null) {
            this.mSelectedStreamsView = new ListView();
            this.mSelectedStreamsView.setDisable(true);
            this.mSelectedStreamsView.setPrefHeight(75.0);
            this.mSelectedStreamsView.getItems().addListener(c -> {
                Object title = "Streaming";
                if (this.getSelectedStreamsView().getItems().size() > 0) {
                    title = (String)title + " (" + this.getSelectedStreamsView().getItems().size() + ")";
                }
                this.getStreamPane().setText((String)title);
            });
        }
        return this.mSelectedStreamsView;
    }

    private Button getAddStreamButton() {
        if (this.mAddStreamButton == null) {
            this.mAddStreamButton = new Button();
            this.mAddStreamButton.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.getAvailableStreamsView().getItems()).or((ObservableBooleanValue)Bindings.isNull((ObservableObjectValue)this.getAvailableStreamsView().getSelectionModel().selectedItemProperty())));
            this.mAddStreamButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddStreamButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_RIGHT));
            this.mAddStreamButton.setAlignment(Pos.CENTER);
            this.mAddStreamButton.setOnAction(event -> {
                String stream = (String)this.getAvailableStreamsView().getSelectionModel().getSelectedItem();
                if (stream != null) {
                    this.getAvailableStreamsView().getItems().remove((Object)stream);
                    this.getSelectedStreamsView().getItems().add((Object)new BroadcastChannel(stream));
                    this.modifiedProperty().set(true);
                }
            });
        }
        return this.mAddStreamButton;
    }

    private Button getRemoveStreamButton() {
        if (this.mRemoveStreamButton == null) {
            this.mRemoveStreamButton = new Button();
            this.mRemoveStreamButton.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.getSelectedStreamsView().getItems()).or((ObservableBooleanValue)Bindings.isNull((ObservableObjectValue)this.getSelectedStreamsView().getSelectionModel().selectedItemProperty())));
            this.mRemoveStreamButton.setMaxWidth(Double.MAX_VALUE);
            this.mRemoveStreamButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_LEFT));
            this.mRemoveStreamButton.setAlignment(Pos.CENTER);
            this.mRemoveStreamButton.setOnAction(event -> {
                BroadcastChannel broadcastChannel = (BroadcastChannel)this.getSelectedStreamsView().getSelectionModel().getSelectedItem();
                if (broadcastChannel != null) {
                    this.getSelectedStreamsView().getItems().remove((Object)broadcastChannel);
                    this.getAvailableStreamsView().getItems().add((Object)broadcastChannel.getChannelName());
                    this.modifiedProperty().set(true);
                }
            });
        }
        return this.mRemoveStreamButton;
    }

    private TitledPane getActionPane() {
        if (this.mActionPane == null) {
            VBox buttonsBox = new VBox();
            buttonsBox.setSpacing(10.0);
            buttonsBox.getChildren().addAll((Object[])new Node[]{this.getAddActionButton(), this.getDeleteActionButton()});
            HBox hbox = new HBox();
            hbox.setSpacing(10.0);
            HBox.setHgrow((Node)this.getActionEditorBox(), (Priority)Priority.ALWAYS);
            hbox.getChildren().addAll((Object[])new Node[]{this.getActionEditorBox(), buttonsBox});
            this.mActionPane = new TitledPane("Actions", (Node)hbox);
            this.mActionPane.setExpanded(false);
        }
        return this.mActionPane;
    }

    private VBox getActionEditorBox() {
        if (this.mActionEditorBox == null) {
            this.mActionEditorBox = new VBox();
            this.mActionEditorBox.setSpacing(10.0);
            this.mActionEditorBox.getChildren().addAll((Object[])new Node[]{this.getActionsList(), this.getActionEditor()});
        }
        return this.mActionEditorBox;
    }

    private GridPane getTextFieldPane() {
        if (this.mTextFieldPane == null) {
            this.mTextFieldPane = new GridPane();
            this.mTextFieldPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mTextFieldPane.setVgap(10.0);
            this.mTextFieldPane.setHgap(10.0);
            int row = 0;
            Label nameLabel = new Label("Alias");
            GridPane.setHalignment((Node)nameLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)nameLabel, (int)0, (int)row);
            this.mTextFieldPane.getChildren().add((Object)nameLabel);
            GridPane.setConstraints((Node)this.getNameField(), (int)1, (int)row);
            GridPane.setHgrow((Node)this.getNameField(), (Priority)Priority.ALWAYS);
            this.mTextFieldPane.getChildren().add((Object)this.getNameField());
            Label monitorAudioLabel = new Label("Listen");
            GridPane.setHalignment((Node)monitorAudioLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)monitorAudioLabel, (int)2, (int)row);
            this.mTextFieldPane.getChildren().add((Object)monitorAudioLabel);
            GridPane.setConstraints((Node)this.getMonitorAudioToggleSwitch(), (int)3, (int)row);
            this.mTextFieldPane.getChildren().add((Object)this.getMonitorAudioToggleSwitch());
            Label monitorPriorityLabel = new Label("Priority");
            GridPane.setHalignment((Node)monitorPriorityLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)monitorPriorityLabel, (int)4, (int)row);
            this.mTextFieldPane.getChildren().add((Object)monitorPriorityLabel);
            GridPane.setConstraints(this.getMonitorPriorityComboBox(), (int)5, (int)row);
            this.mTextFieldPane.getChildren().add(this.getMonitorPriorityComboBox());
            Label colorLabel = new Label("Color");
            GridPane.setHalignment((Node)colorLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)colorLabel, (int)6, (int)row);
            this.mTextFieldPane.getChildren().add((Object)colorLabel);
            GridPane.setConstraints((Node)this.getColorPicker(), (int)7, (int)row);
            this.mTextFieldPane.getChildren().add((Object)this.getColorPicker());
            Label groupLabel = new Label("Group");
            GridPane.setHalignment((Node)groupLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)groupLabel, (int)0, (int)(++row));
            this.mTextFieldPane.getChildren().add((Object)groupLabel);
            GridPane.setConstraints((Node)this.getGroupField(), (int)1, (int)row);
            GridPane.setHgrow((Node)this.getGroupField(), (Priority)Priority.ALWAYS);
            this.mTextFieldPane.getChildren().add((Object)this.getGroupField());
            Label recordAudioLabel = new Label("Record");
            GridPane.setHalignment((Node)recordAudioLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)recordAudioLabel, (int)2, (int)row);
            this.mTextFieldPane.getChildren().add((Object)recordAudioLabel);
            GridPane.setConstraints((Node)this.getRecordAudioToggleSwitch(), (int)3, (int)row);
            this.mTextFieldPane.getChildren().add((Object)this.getRecordAudioToggleSwitch());
            Label iconLabel = new Label("Icon");
            GridPane.setHalignment((Node)iconLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)iconLabel, (int)4, (int)row);
            this.mTextFieldPane.getChildren().add((Object)iconLabel);
            GridPane.setConstraints(this.getIconNodeComboBox(), (int)5, (int)row, (int)3, (int)1);
            this.mTextFieldPane.getChildren().add(this.getIconNodeComboBox());
        }
        return this.mTextFieldPane;
    }

    private ToggleSwitch getMonitorAudioToggleSwitch() {
        if (this.mMonitorAudioToggleSwitch == null) {
            this.mMonitorAudioToggleSwitch = new ToggleSwitch();
            this.mMonitorAudioToggleSwitch.setDisable(true);
            this.mMonitorAudioToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mMonitorAudioToggleSwitch;
    }

    private ComboBox<Integer> getMonitorPriorityComboBox() {
        if (this.mMonitorPriorityComboBox == null) {
            this.mMonitorPriorityComboBox = new ComboBox();
            this.mMonitorPriorityComboBox.getItems().add(null);
            for (int x = 1; x < 100; ++x) {
                this.mMonitorPriorityComboBox.getItems().add((Object)x);
            }
            this.mMonitorPriorityComboBox.disableProperty().bind((ObservableValue)this.getMonitorAudioToggleSwitch().selectedProperty().not());
            this.mMonitorPriorityComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mMonitorPriorityComboBox;
    }

    private ToggleSwitch getRecordAudioToggleSwitch() {
        if (this.mRecordAudioToggleSwitch == null) {
            this.mRecordAudioToggleSwitch = new ToggleSwitch();
            this.mRecordAudioToggleSwitch.setDisable(true);
            this.mRecordAudioToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordAudioToggleSwitch;
    }

    private ColorPicker getColorPicker() {
        if (this.mColorPicker == null) {
            this.mColorPicker = new ColorPicker(Color.BLACK);
            this.mColorPicker.setDisable(true);
            this.mColorPicker.setEditable(true);
            this.mColorPicker.setStyle("-fx-color-rect-width: 60px; -fx-color-label-visible: false;");
            this.mColorPicker.setOnAction(event -> this.modifiedProperty().set(true));
        }
        return this.mColorPicker;
    }

    private ComboBox<Icon> getIconNodeComboBox() {
        if (this.mIconNodeComboBox == null) {
            this.mIconNodeComboBox = new ComboBox();
            this.mIconNodeComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mIconNodeComboBox.setDisable(true);
            this.mIconNodeComboBox.setItems((ObservableList)new SortedList(this.mPlaylistManager.getIconModel().iconsProperty(), (Comparator)Ordering.natural()));
            this.mIconNodeComboBox.setCellFactory((Callback)new IconCellFactory(this));
            this.mIconNodeComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mIconNodeComboBox;
    }

    private void refreshAutoCompleteBindings() {
        this.getGroupSuggestionProvider().clearSuggestions();
        this.getGroupSuggestionProvider().addPossibleSuggestions(this.mPlaylistManager.getAliasModel().getGroupNames());
    }

    private SuggestionProvider<String> getGroupSuggestionProvider() {
        if (this.mGroupSuggestionProvider == null) {
            this.mGroupSuggestionProvider = SuggestionProvider.create(this.mPlaylistManager.getAliasModel().getGroupNames());
        }
        return this.mGroupSuggestionProvider;
    }

    protected TextField getGroupField() {
        if (this.mGroupField == null) {
            this.mGroupField = new TextField();
            this.mGroupField.setDisable(true);
            this.mGroupField.setMaxWidth(Double.MAX_VALUE);
            this.mGroupField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
            new AutoCompletionTextFieldBinding(this.mGroupField, this.getGroupSuggestionProvider());
        }
        return this.mGroupField;
    }

    protected TextField getNameField() {
        if (this.mNameField == null) {
            this.mNameField = new TextField();
            this.mNameField.setDisable(true);
            this.mNameField.setMaxWidth(Double.MAX_VALUE);
            this.mNameField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mNameField;
    }

    private VBox getButtonBox() {
        if (this.mButtonBox == null) {
            this.mButtonBox = new VBox();
            this.mButtonBox.setSpacing(10.0);
            this.mButtonBox.setPadding(new Insets(10.0, 10.0, 10.0, 0.0));
            this.mButtonBox.getChildren().addAll((Object[])new Node[]{this.getSaveButton(), this.getResetButton()});
        }
        return this.mButtonBox;
    }

    private Button getSaveButton() {
        if (this.mSaveButton == null) {
            this.mSaveButton = new Button(" Save ");
            this.mSaveButton.setTextAlignment(TextAlignment.CENTER);
            this.mSaveButton.setMaxWidth(Double.MAX_VALUE);
            this.mSaveButton.disableProperty().bind((ObservableValue)this.modifiedProperty().not());
            this.mSaveButton.setOnAction(event -> this.save());
        }
        return this.mSaveButton;
    }

    private Button getResetButton() {
        if (this.mResetButton == null) {
            this.mResetButton = new Button("Reset");
            this.mResetButton.setTextAlignment(TextAlignment.CENTER);
            this.mResetButton.setMaxWidth(Double.MAX_VALUE);
            this.mResetButton.disableProperty().bind((ObservableValue)this.modifiedProperty().not());
            this.mResetButton.setOnAction(event -> {
                this.modifiedProperty().set(false);
                this.setItem((Alias)this.getItem());
            });
        }
        return this.mResetButton;
    }

    public class EditorModificationListener
    implements ChangeListener<String> {
        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            AliasItemEditor.this.modifiedProperty().set(true);
        }
    }

    public class IdentifierEditorModificationListener
    implements ChangeListener<Boolean> {
        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                AliasItemEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class ActionEditorModificationListener
    implements ChangeListener<Boolean> {
        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                AliasItemEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class AddAudioClipActionItem
    extends MenuItem {
        public AddAudioClipActionItem() {
            super("Audio Clip");
            this.setOnAction(event -> {
                if (AliasItemEditor.this.getItem() != null) {
                    ClipAction clipAction = new ClipAction();
                    AliasItemEditor.this.getActionsList().getItems().add((Object)clipAction);
                    AliasItemEditor.this.getActionsList().getSelectionModel().select((Object)clipAction);
                    AliasItemEditor.this.getActionsList().scrollTo((Object)clipAction);
                    AliasItemEditor.this.modifiedProperty().set(true);
                }
            });
        }
    }

    public class AddBeepActionItem
    extends MenuItem {
        public AddBeepActionItem() {
            super("Beep");
            this.setOnAction(event -> {
                if (AliasItemEditor.this.getItem() != null) {
                    BeepAction beepAction = new BeepAction();
                    AliasItemEditor.this.getActionsList().getItems().add((Object)beepAction);
                    AliasItemEditor.this.getActionsList().getSelectionModel().select((Object)beepAction);
                    AliasItemEditor.this.getActionsList().scrollTo((Object)beepAction);
                    AliasItemEditor.this.modifiedProperty().set(true);
                }
            });
        }
    }

    public class AddScriptActionItem
    extends MenuItem {
        public AddScriptActionItem() {
            super("Script");
            this.setOnAction(event -> {
                if (AliasItemEditor.this.getItem() != null) {
                    ScriptAction scriptAction = new ScriptAction();
                    AliasItemEditor.this.getActionsList().getItems().add((Object)scriptAction);
                    AliasItemEditor.this.getActionsList().getSelectionModel().select((Object)scriptAction);
                    AliasItemEditor.this.getActionsList().scrollTo((Object)scriptAction);
                    AliasItemEditor.this.modifiedProperty().set(true);
                }
            });
        }
    }

    public class ProtocolMenu
    extends Menu {
        public ProtocolMenu(AliasItemEditor this$0, Protocol protocol) {
            super(protocol.toString());
        }
    }

    public class AddTalkgroupItem
    extends MenuItem {
        private Protocol mProtocol;

        public AddTalkgroupItem(Protocol protocol) {
            super("Talkgroup");
            this.mProtocol = protocol;
            this.setOnAction(event -> {
                Talkgroup talkgroup = new Talkgroup();
                talkgroup.setProtocol(this.mProtocol);
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)talkgroup);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)talkgroup);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)talkgroup);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddTalkgroupRangeItem
    extends MenuItem {
        private Protocol mProtocol;

        public AddTalkgroupRangeItem(Protocol protocol) {
            super("Talkgroup Range");
            this.mProtocol = protocol;
            this.setOnAction(event -> {
                TalkgroupRange talkgroupRange = new TalkgroupRange();
                talkgroupRange.setProtocol(this.mProtocol);
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)talkgroupRange);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)talkgroupRange);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)talkgroupRange);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddP25FullyQualifiedTalkgroupItem
    extends MenuItem {
        public AddP25FullyQualifiedTalkgroupItem() {
            super("Fully Qualified Talkgroup");
            this.setOnAction(event -> {
                P25FullyQualifiedTalkgroup talkgroup = new P25FullyQualifiedTalkgroup();
                talkgroup.setProtocol(Protocol.APCO25);
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)talkgroup);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)talkgroup);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)talkgroup);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddRadioIdItem
    extends MenuItem {
        private Protocol mProtocol;

        public AddRadioIdItem(Protocol protocol) {
            super("Radio ID");
            this.mProtocol = protocol;
            this.setOnAction(event -> {
                Radio radioId = new Radio();
                radioId.setProtocol(this.mProtocol);
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)radioId);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)radioId);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)radioId);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddRadioIdRangeItem
    extends MenuItem {
        private Protocol mProtocol;

        public AddRadioIdRangeItem(Protocol protocol) {
            super("Radio ID Range");
            this.mProtocol = protocol;
            this.setOnAction(event -> {
                RadioRange radioRange = new RadioRange();
                radioRange.setProtocol(this.mProtocol);
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)radioRange);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)radioRange);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)radioRange);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddP25FullyQualifiedRadioIdItem
    extends MenuItem {
        public AddP25FullyQualifiedRadioIdItem() {
            super("Fully Qualified Radio ID");
            this.setOnAction(event -> {
                P25FullyQualifiedRadio radioId = new P25FullyQualifiedRadio();
                radioId.setProtocol(Protocol.APCO25);
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)radioId);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)radioId);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)radioId);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddUserStatusItem
    extends MenuItem {
        public AddUserStatusItem() {
            super("User Status");
            this.setOnAction(event -> {
                UserStatusID userStatus = new UserStatusID();
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)userStatus);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)userStatus);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)userStatus);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddUnitStatusItem
    extends MenuItem {
        public AddUnitStatusItem() {
            super("Unit Status");
            this.setOnAction(event -> {
                UnitStatusID unitStatus = new UnitStatusID();
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)unitStatus);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)unitStatus);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)unitStatus);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddTonesItem
    extends MenuItem {
        public AddTonesItem(String label) {
            super(label);
            this.setOnAction(event -> {
                TonesID tonesId = new TonesID();
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)tonesId);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)tonesId);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)tonesId);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddDcsItem
    extends MenuItem {
        public AddDcsItem() {
            super("Digital Coded Squelch (DCS)");
            this.setOnAction(event -> {
                Dcs dcs = new Dcs();
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)dcs);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)dcs);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)dcs);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class AddLojackItem
    extends MenuItem {
        public AddLojackItem() {
            super("LoJack Function/ID");
            this.setOnAction(event -> {
                LoJackFunctionAndID lojack = new LoJackFunctionAndID();
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)lojack);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)lojack);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)lojack);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }

    public class IconCellFactory
    implements Callback<ListView<Icon>, ListCell<Icon>> {
        public IconCellFactory(AliasItemEditor this$0) {
        }

        public ListCell<Icon> call(ListView<Icon> param) {
            final Label iconLabel = new Label();
            final Label textLabel = new Label();
            final GridPane gridPane = new GridPane();
            gridPane.setHgap(5.0);
            GridPane.setHalignment((Node)iconLabel, (HPos)HPos.RIGHT);
            gridPane.getColumnConstraints().add((Object)new ColumnConstraints(50.0));
            gridPane.add((Node)iconLabel, 0, 0);
            gridPane.add((Node)textLabel, 1, 0);
            ListCell<Icon> cell = new ListCell<Icon>(this){

                protected void updateItem(Icon item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else {
                        textLabel.setText(item.getName());
                        iconLabel.setGraphic((Node)new ImageView(item.getFxImage()));
                        this.setGraphic((Node)gridPane);
                    }
                }
            };
            return cell;
        }
    }

    public class AliasIdentifierCell
    extends ListCell<AliasID> {
        protected void updateItem(AliasID item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                if (item instanceof P25FullyQualifiedTalkgroup) {
                    P25FullyQualifiedTalkgroup fqt = (P25FullyQualifiedTalkgroup)item;
                    StringBuilder sb = new StringBuilder();
                    sb.append("APCO-25 Fully Qualified Talkgroup:").append(fqt.getWacn());
                    sb.append(".").append(fqt.getSystem());
                    sb.append(".").append(fqt.getValue());
                    if (fqt.overlapProperty().get()) {
                        sb.append(" - Error: Overlap");
                    }
                    if (!fqt.isValid()) {
                        sb.append(" **NOT VALID**");
                    }
                    this.setText(sb.toString());
                } else if (item instanceof Talkgroup) {
                    Talkgroup talkgroup = (Talkgroup)item;
                    Protocol protocol = talkgroup.getProtocol();
                    IntegerFormat integerFormat = AliasItemEditor.this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(protocol);
                    String formatted = TalkgroupFormatter.format(protocol, talkgroup.getValue(), integerFormat);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Talkgroup:").append(formatted);
                    sb.append(" Protocol:").append((Object)talkgroup.getProtocol());
                    if (talkgroup.overlapProperty().get()) {
                        sb.append(" - Error: Overlap");
                    }
                    if (!talkgroup.isValid()) {
                        sb.append(" **NOT VALID**");
                    }
                    this.setText(sb.toString());
                } else if (item instanceof TalkgroupRange) {
                    TalkgroupRange talkgroupRange = (TalkgroupRange)item;
                    Protocol protocol = talkgroupRange.getProtocol();
                    IntegerFormat integerFormat = AliasItemEditor.this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(protocol);
                    String formattedMin = TalkgroupFormatter.format(protocol, talkgroupRange.getMinTalkgroup(), integerFormat);
                    String formattedMax = TalkgroupFormatter.format(protocol, talkgroupRange.getMaxTalkgroup(), integerFormat);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Talkgroup Range:").append(formattedMin).append(" to ").append(formattedMax);
                    sb.append(" Protocol:").append((Object)talkgroupRange.getProtocol());
                    if (talkgroupRange.overlapProperty().get()) {
                        sb.append(" - Error: Overlap");
                    }
                    if (!talkgroupRange.isValid()) {
                        sb.append(" **NOT VALID**");
                    }
                    this.setText(sb.toString());
                } else if (item instanceof P25FullyQualifiedRadio) {
                    P25FullyQualifiedRadio fqr = (P25FullyQualifiedRadio)item;
                    StringBuilder sb = new StringBuilder();
                    sb.append("APCO-25 Fully Qualified Radio ID:").append(fqr.getWacn());
                    sb.append(".").append(fqr.getSystem());
                    sb.append(".").append(fqr.getValue());
                    if (fqr.overlapProperty().get()) {
                        sb.append(" - Error: Overlap");
                    }
                    if (!fqr.isValid()) {
                        sb.append(" **NOT VALID**");
                    }
                    this.setText(sb.toString());
                } else if (item instanceof Radio) {
                    Radio radio = (Radio)item;
                    Protocol protocol = radio.getProtocol();
                    IntegerFormat integerFormat = AliasItemEditor.this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(protocol);
                    String formatted = RadioFormatter.format(protocol, radio.getValue(), integerFormat);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Radio ID:").append(formatted);
                    sb.append(" Protocol:").append((Object)radio.getProtocol());
                    if (radio.overlapProperty().get()) {
                        sb.append(" - Error: Overlap");
                    }
                    if (!radio.isValid()) {
                        sb.append(" **NOT VALID**");
                    }
                    this.setText(sb.toString());
                } else if (item instanceof RadioRange) {
                    RadioRange radioRange = (RadioRange)item;
                    Protocol protocol = radioRange.getProtocol();
                    IntegerFormat integerFormat = AliasItemEditor.this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(protocol);
                    String formattedMin = TalkgroupFormatter.format(protocol, radioRange.getMinRadio(), integerFormat);
                    String formattedMax = TalkgroupFormatter.format(protocol, radioRange.getMaxRadio(), integerFormat);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Radio ID Range:").append(formattedMin).append(" to ").append(formattedMax);
                    sb.append(" Protocol:").append((Object)radioRange.getProtocol());
                    if (radioRange.overlapProperty().get()) {
                        sb.append(" - Error: Overlap");
                    }
                    if (!radioRange.isValid()) {
                        sb.append(" **NOT VALID**");
                    }
                    this.setText(sb.toString());
                } else {
                    this.setText(item.toString());
                }
            } else {
                this.setText(null);
            }
        }
    }

    public class AddEsnItem
    extends MenuItem {
        public AddEsnItem() {
            super("ESN");
            this.setOnAction(event -> {
                Esn esn = new Esn();
                AliasItemEditor.this.getIdentifiersList().getItems().add((Object)esn);
                AliasItemEditor.this.getIdentifiersList().getSelectionModel().select((Object)esn);
                AliasItemEditor.this.getIdentifiersList().scrollTo((Object)esn);
                AliasItemEditor.this.modifiedProperty().set(true);
            });
        }
    }
}

