/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias;

import com.google.common.collect.Ordering;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.gui.playlist.alias.ColorUtil;
import io.github.dsheirer.icon.Icon;
import io.github.dsheirer.playlist.PlaylistManager;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.controlsfx.control.ToggleSwitch;

public class AliasBulkEditor
extends Editor<List<Alias>> {
    private PlaylistManager mPlaylistManager;
    private Label mEditingLabel;
    private ColorPicker mColorPicker;
    private Button mApplyColorButton;
    private Button mResetColorButton;
    private ComboBox<Icon> mIconNodeComboBox;
    private Button mApplyIconButton;
    private ToggleSwitch mMonitorAudioToggleSwitch;
    private ComboBox<Integer> mMonitorPriorityComboBox;
    private Button mApplyMonitorButton;
    private ToggleSwitch mRecordToggleSwitch;
    private Button mApplyRecordButton;
    private BooleanProperty mChangeInProgressProperty;
    private ReadOnlyBooleanProperty mChangeInProgressROProperty;

    public AliasBulkEditor(PlaylistManager playlistManager) {
        this.mPlaylistManager = playlistManager;
        this.mChangeInProgressProperty = new SimpleBooleanProperty();
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        int row = 0;
        Label editorLabel = new Label("Multiple Alias Editor");
        GridPane.setConstraints((Node)editorLabel, (int)0, (int)row, (int)3, (int)1);
        gridPane.getChildren().add((Object)editorLabel);
        GridPane.setConstraints((Node)this.getEditingLabel(), (int)3, (int)row, (int)3, (int)1);
        GridPane.setHalignment((Node)this.getEditingLabel(), (HPos)HPos.RIGHT);
        gridPane.getChildren().add((Object)this.getEditingLabel());
        Separator separator = new Separator();
        separator.setMaxWidth(Double.MAX_VALUE);
        GridPane.setConstraints((Node)separator, (int)0, (int)(++row), (int)6, (int)1);
        gridPane.getChildren().add((Object)separator);
        Label colorLabel = new Label("Color");
        GridPane.setHalignment((Node)colorLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)colorLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)colorLabel);
        GridPane.setConstraints((Node)this.getColorPicker(), (int)1, (int)row, (int)3, (int)1);
        gridPane.getChildren().add((Object)this.getColorPicker());
        GridPane.setConstraints((Node)this.getApplyColorButton(), (int)4, (int)row);
        gridPane.getChildren().add((Object)this.getApplyColorButton());
        GridPane.setConstraints((Node)this.getResetColorButton(), (int)5, (int)row);
        gridPane.getChildren().add((Object)this.getResetColorButton());
        Label iconLabel = new Label("Icon");
        GridPane.setHalignment((Node)iconLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)iconLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)iconLabel);
        GridPane.setConstraints(this.getIconNodeComboBox(), (int)1, (int)row, (int)3, (int)1);
        gridPane.getChildren().add(this.getIconNodeComboBox());
        GridPane.setConstraints((Node)this.getApplyIconButton(), (int)4, (int)row);
        gridPane.getChildren().add((Object)this.getApplyIconButton());
        Label listenLabel = new Label("Listen");
        GridPane.setHalignment((Node)listenLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)listenLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)listenLabel);
        GridPane.setConstraints((Node)this.getMonitorAudioToggleSwitch(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getMonitorAudioToggleSwitch());
        Label priorityLabel = new Label("Priority");
        GridPane.setHalignment((Node)priorityLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)priorityLabel, (int)2, (int)row);
        gridPane.getChildren().add((Object)priorityLabel);
        GridPane.setConstraints(this.getMonitorPriorityComboBox(), (int)3, (int)row);
        gridPane.getChildren().add(this.getMonitorPriorityComboBox());
        GridPane.setConstraints((Node)this.getApplyMonitorButton(), (int)4, (int)row);
        gridPane.getChildren().add((Object)this.getApplyMonitorButton());
        Label recordLabel = new Label("Record");
        GridPane.setHalignment((Node)recordLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)recordLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)recordLabel);
        GridPane.setConstraints((Node)this.getRecordToggleSwitch(), (int)1, (int)row);
        gridPane.getChildren().add((Object)this.getRecordToggleSwitch());
        GridPane.setConstraints((Node)this.getApplyRecordButton(), (int)4, (int)row);
        gridPane.getChildren().add((Object)this.getApplyRecordButton());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public List<Alias> getItem() {
        return (List)super.getItem();
    }

    @Override
    public void setItem(List<Alias> item) {
        super.setItem(item);
        this.getEditingLabel().setText("Editing " + item.size() + " Aliases");
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    public ReadOnlyBooleanProperty changeInProgressProperty() {
        if (this.mChangeInProgressROProperty == null) {
            this.mChangeInProgressROProperty = BooleanProperty.readOnlyBooleanProperty((ReadOnlyProperty)this.mChangeInProgressProperty);
        }
        return this.mChangeInProgressROProperty;
    }

    private void startChange() {
        this.mChangeInProgressProperty.set(true);
    }

    private void endChange() {
        this.mChangeInProgressProperty.set(false);
    }

    private Label getEditingLabel() {
        if (this.mEditingLabel == null) {
            this.mEditingLabel = new Label("Editing 0 Aliases");
        }
        return this.mEditingLabel;
    }

    private ColorPicker getColorPicker() {
        if (this.mColorPicker == null) {
            this.mColorPicker = new ColorPicker(Color.BLACK);
            this.mColorPicker.setEditable(true);
            this.mColorPicker.setStyle("-fx-color-rect-width: 60px; -fx-color-label-visible: false;");
        }
        return this.mColorPicker;
    }

    private Button getApplyColorButton() {
        if (this.mApplyColorButton == null) {
            this.mApplyColorButton = new Button("Apply");
            this.mApplyColorButton.setOnAction(event -> {
                this.startChange();
                int colorValue = ColorUtil.toInteger((Color)this.getColorPicker().getValue());
                Iterator iterator = this.getItem().iterator();
                while (iterator.hasNext()) {
                    Alias alias = (Alias)iterator.next();
                    alias.setColor(colorValue);
                }
                this.endChange();
            });
        }
        return this.mApplyColorButton;
    }

    private Button getResetColorButton() {
        if (this.mResetColorButton == null) {
            this.mResetColorButton = new Button("Reset Color");
            this.mResetColorButton.setOnAction(event -> {
                this.startChange();
                Iterator iterator = this.getItem().iterator();
                while (iterator.hasNext()) {
                    Alias alias = (Alias)iterator.next();
                    alias.setColor(0);
                }
                this.endChange();
            });
        }
        return this.mResetColorButton;
    }

    private ComboBox<Icon> getIconNodeComboBox() {
        if (this.mIconNodeComboBox == null) {
            this.mIconNodeComboBox = new ComboBox();
            this.mIconNodeComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mIconNodeComboBox.setItems((ObservableList)new SortedList(this.mPlaylistManager.getIconModel().iconsProperty(), (Comparator)Ordering.natural()));
            this.mIconNodeComboBox.setCellFactory((Callback)new IconCellFactory(this));
            this.mIconNodeComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.getApplyIconButton().setDisable(newValue == null));
        }
        return this.mIconNodeComboBox;
    }

    private Button getApplyIconButton() {
        if (this.mApplyIconButton == null) {
            this.mApplyIconButton = new Button("Apply");
            this.mApplyIconButton.setDisable(true);
            this.mApplyIconButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    AliasBulkEditor.this.startChange();
                    Icon icon = (Icon)AliasBulkEditor.this.getIconNodeComboBox().getSelectionModel().getSelectedItem();
                    if (icon != null) {
                        Iterator iterator = AliasBulkEditor.this.getItem().iterator();
                        while (iterator.hasNext()) {
                            Alias alias = (Alias)iterator.next();
                            alias.setIconName(icon.getName());
                        }
                    }
                    AliasBulkEditor.this.endChange();
                }
            });
        }
        return this.mApplyIconButton;
    }

    private ToggleSwitch getMonitorAudioToggleSwitch() {
        if (this.mMonitorAudioToggleSwitch == null) {
            this.mMonitorAudioToggleSwitch = new ToggleSwitch();
            this.mMonitorAudioToggleSwitch.setSelected(true);
            this.mMonitorAudioToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mMonitorAudioToggleSwitch;
    }

    private ToggleSwitch getRecordToggleSwitch() {
        if (this.mRecordToggleSwitch == null) {
            this.mRecordToggleSwitch = new ToggleSwitch();
            this.mRecordToggleSwitch.setSelected(false);
            this.mRecordToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordToggleSwitch;
    }

    private ComboBox<Integer> getMonitorPriorityComboBox() {
        if (this.mMonitorPriorityComboBox == null) {
            this.mMonitorPriorityComboBox = new ComboBox();
            this.mMonitorPriorityComboBox.getItems().add(null);
            for (int x = 1; x < 100; ++x) {
                this.mMonitorPriorityComboBox.getItems().add((Object)x);
            }
            this.mMonitorPriorityComboBox.disableProperty().bind((ObservableValue)this.getMonitorAudioToggleSwitch().selectedProperty().not());
            this.mMonitorPriorityComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mMonitorPriorityComboBox;
    }

    private Button getApplyMonitorButton() {
        if (this.mApplyMonitorButton == null) {
            this.mApplyMonitorButton = new Button("Apply");
            this.mApplyMonitorButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    AliasBulkEditor.this.startChange();
                    boolean canMonitor = AliasBulkEditor.this.getMonitorAudioToggleSwitch().isSelected();
                    Integer priority = (Integer)AliasBulkEditor.this.getMonitorPriorityComboBox().getSelectionModel().getSelectedItem();
                    if (canMonitor) {
                        if (priority == null) {
                            priority = 100;
                        }
                    } else {
                        priority = -1;
                    }
                    Integer pri = priority;
                    Iterator iterator = AliasBulkEditor.this.getItem().iterator();
                    while (iterator.hasNext()) {
                        Alias alias = (Alias)iterator.next();
                        alias.setCallPriority(pri);
                    }
                    AliasBulkEditor.this.endChange();
                }
            });
        }
        return this.mApplyMonitorButton;
    }

    private Button getApplyRecordButton() {
        if (this.mApplyRecordButton == null) {
            this.mApplyRecordButton = new Button("Apply");
            this.mApplyRecordButton.setOnAction(event -> {
                this.startChange();
                boolean record = this.getRecordToggleSwitch().isSelected();
                Iterator iterator = this.getItem().iterator();
                while (iterator.hasNext()) {
                    Alias alias = (Alias)iterator.next();
                    alias.setRecordable(record);
                }
                this.endChange();
            });
        }
        return this.mApplyRecordButton;
    }

    public class IconCellFactory
    implements Callback<ListView<Icon>, ListCell<Icon>> {
        public IconCellFactory(AliasBulkEditor this$0) {
        }

        public ListCell<Icon> call(ListView<Icon> param) {
            final Label iconLabel = new Label();
            final Label textLabel = new Label();
            final GridPane gridPane = new GridPane();
            gridPane.setHgap(5.0);
            GridPane.setHalignment((Node)iconLabel, (HPos)HPos.RIGHT);
            gridPane.getColumnConstraints().add((Object)new ColumnConstraints(50.0));
            gridPane.add((Node)iconLabel, 0, 0);
            gridPane.add((Node)textLabel, 1, 0);
            ListCell<Icon> cell = new ListCell<Icon>(this){

                protected void updateItem(Icon item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else {
                        textLabel.setText(item.getName());
                        iconLabel.setGraphic((Node)new ImageView(item.getFxImage()));
                        this.setGraphic((Node)gridPane);
                    }
                }
            };
            return cell;
        }
    }
}

