/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist;

import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.icon.ViewIconManagerRequest;
import io.github.dsheirer.gui.playlist.PlaylistEditorRequest;
import io.github.dsheirer.gui.playlist.alias.AliasEditor;
import io.github.dsheirer.gui.playlist.alias.AliasTabRequest;
import io.github.dsheirer.gui.playlist.channel.ChannelEditor;
import io.github.dsheirer.gui.playlist.channel.ChannelTabRequest;
import io.github.dsheirer.gui.playlist.manager.PlaylistManagerEditor;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceEditor;
import io.github.dsheirer.gui.playlist.streaming.StreamingEditor;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.ViewUserPreferenceEditorRequest;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.util.ThreadPool;
import io.github.dsheirer.util.TimeStamp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.imageio.ImageIO;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistEditor
extends BorderPane {
    private static final Logger mLog = LoggerFactory.getLogger(PlaylistEditor.class);
    private PlaylistManager mPlaylistManager;
    private TunerManager mTunerManager;
    private UserPreferences mUserPreferences;
    private MenuBar mMenuBar;
    private TabPane mTabPane;
    private Tab mPlaylistsTab;
    private Tab mChannelsTab;
    private Tab mAliasesTab;
    private Tab mRadioReferenceTab;
    private Tab mStreamingTab;
    private AliasEditor mAliasEditor;
    private ChannelEditor mChannelEditor;

    public PlaylistEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences) {
        this.mPlaylistManager = playlistManager;
        this.mTunerManager = tunerManager;
        this.mUserPreferences = userPreferences;
        Platform.runLater(() -> {
            this.setTop((Node)this.getMenuBar());
            this.setCenter((Node)this.getTabPane());
        });
    }

    public void process(PlaylistEditorRequest request) {
        switch (request.getTabName()) {
            case ALIAS: {
                if (!(request instanceof AliasTabRequest)) break;
                this.getTabPane().getSelectionModel().select((Object)this.getAliasesTab());
                this.getAliasEditor().process((AliasTabRequest)request);
                break;
            }
            case CHANNEL: {
                if (!(request instanceof ChannelTabRequest)) break;
                this.getTabPane().getSelectionModel().select((Object)this.getChannelsTab());
                this.getChannelEditor().process((ChannelTabRequest)request);
                break;
            }
            case PLAYLIST: {
                break;
            }
            default: {
                mLog.warn("Unrecognized playlist editor request: " + String.valueOf(request.getClass()));
            }
        }
    }

    private MenuBar getMenuBar() {
        if (this.mMenuBar == null) {
            this.mMenuBar = new MenuBar();
            Menu fileMenu = new Menu("_File");
            fileMenu.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.ALT_ANY}));
            MenuItem closeItem = new MenuItem("_Close");
            closeItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.ALT_ANY}));
            closeItem.setOnAction(event -> this.getMenuBar().getParent().getScene().getWindow().hide());
            fileMenu.getItems().add((Object)closeItem);
            this.mMenuBar.getMenus().add((Object)fileMenu);
            Menu viewMenu = new Menu("_View");
            viewMenu.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.ALT_ANY}));
            MenuItem iconManagerItem = new MenuItem("_Icon Manager");
            iconManagerItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.ALT_ANY}));
            iconManagerItem.setOnAction(event -> MyEventBus.getGlobalEventBus().post((Object)new ViewIconManagerRequest()));
            viewMenu.getItems().add((Object)iconManagerItem);
            MenuItem userPreferenceItem = new MenuItem("_User Preferences");
            userPreferenceItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{KeyCombination.ALT_ANY}));
            userPreferenceItem.setOnAction(event -> MyEventBus.getGlobalEventBus().post((Object)new ViewUserPreferenceEditorRequest(PreferenceEditorType.TALKGROUP_FORMAT)));
            viewMenu.getItems().add((Object)userPreferenceItem);
            this.mMenuBar.getMenus().add((Object)viewMenu);
            Menu screenShot = new Menu("_Screenshot");
            IconNode cameraNode = new IconNode((IconCode)FontAwesome.CAMERA);
            cameraNode.setFill((Paint)Color.DARKGRAY);
            screenShot.setGraphic((Node)cameraNode);
            MenuItem menuItem = new MenuItem();
            screenShot.getItems().add((Object)menuItem);
            screenShot.setOnShowing(event -> screenShot.hide());
            screenShot.setOnShown(event -> menuItem.fire());
            menuItem.setOnAction(event -> {
                WritableImage image = this.getMenuBar().getScene().snapshot(null);
                BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)image, null);
                String filename = TimeStamp.getTimeStamp("_") + "_screen_capture.png";
                Path captureFile = this.mUserPreferences.getDirectoryPreference().getDirectoryScreenCapture().resolve(filename);
                ThreadPool.CACHED.submit(() -> {
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "png", captureFile.toFile());
                    }
                    catch (IOException e) {
                        mLog.error("Couldn't write screen capture to file [" + captureFile.toString() + "]", (Throwable)e);
                    }
                });
            });
            this.mMenuBar.getMenus().add((Object)screenShot);
        }
        return this.mMenuBar;
    }

    private TabPane getTabPane() {
        if (this.mTabPane == null) {
            this.mTabPane = new TabPane();
            this.mTabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            this.mTabPane.getTabs().addAll((Object[])new Tab[]{this.getPlaylistsTab(), this.getChannelsTab(), this.getAliasesTab(), this.getStreamingTab(), this.getRadioReferenceTab()});
        }
        return this.mTabPane;
    }

    private Tab getAliasesTab() {
        if (this.mAliasesTab == null) {
            this.mAliasesTab = new Tab("Aliases");
            this.mAliasesTab.setContent((Node)this.getAliasEditor());
        }
        return this.mAliasesTab;
    }

    private AliasEditor getAliasEditor() {
        if (this.mAliasEditor == null) {
            this.mAliasEditor = new AliasEditor(this.mPlaylistManager, this.mUserPreferences);
        }
        return this.mAliasEditor;
    }

    private Tab getChannelsTab() {
        if (this.mChannelsTab == null) {
            this.mChannelsTab = new Tab("Channels");
            this.mChannelsTab.setContent((Node)this.getChannelEditor());
        }
        return this.mChannelsTab;
    }

    private ChannelEditor getChannelEditor() {
        if (this.mChannelEditor == null) {
            this.mChannelEditor = new ChannelEditor(this.mPlaylistManager, this.mTunerManager, this.mUserPreferences);
        }
        return this.mChannelEditor;
    }

    private Tab getPlaylistsTab() {
        if (this.mPlaylistsTab == null) {
            this.mPlaylistsTab = new Tab("Playlists");
            this.mPlaylistsTab.setContent((Node)new PlaylistManagerEditor(this.mPlaylistManager, this.mUserPreferences));
        }
        return this.mPlaylistsTab;
    }

    private Tab getRadioReferenceTab() {
        if (this.mRadioReferenceTab == null) {
            this.mRadioReferenceTab = new Tab("Radio Reference");
            this.mRadioReferenceTab.setContent((Node)new RadioReferenceEditor(this.mUserPreferences, this.mPlaylistManager));
        }
        return this.mRadioReferenceTab;
    }

    private Tab getStreamingTab() {
        if (this.mStreamingTab == null) {
            this.mStreamingTab = new Tab("Streaming");
            this.mStreamingTab.setContent((Node)new StreamingEditor(this.mPlaylistManager));
        }
        return this.mStreamingTab;
    }
}

