/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.decoder;

import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.gui.instrument.decoder.AbstractAFSK1200Pane;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.lj1200.LJ1200DecoderInstrumented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LJ1200Pane
extends AbstractAFSK1200Pane {
    private static final Logger mLog = LoggerFactory.getLogger(LJ1200Pane.class);
    private LJ1200DecoderInstrumented mDecoder;

    public LJ1200Pane() {
        super(DecoderType.LJ_1200);
    }

    @Override
    protected LJ1200DecoderInstrumented getDecoder() {
        if (this.mDecoder == null) {
            this.mDecoder = new LJ1200DecoderInstrumented();
            this.mDecoder.getTowerMessageFramer().setSyncDetectListener(new ISyncDetectListener(this){

                @Override
                public void syncDetected(int bitErrors) {
                    mLog.debug("Tower Sync Detected!");
                }

                @Override
                public void syncLost(int bitsProcessed) {
                }
            });
            this.mDecoder.getTransponderMessageFramer().setSyncDetectListener(new ISyncDetectListener(this){

                @Override
                public void syncDetected(int bitErrors) {
                    mLog.debug("Transponder Sync Detected!");
                }

                @Override
                public void syncLost(int bitsProcessed) {
                }
            });
        }
        return this.mDecoder;
    }
}

