/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.module.decode.ltrnet.LTRNetDecoderInstrumented;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCrossingErrorDetectorChart
extends LineChart {
    private static final Logger mLog = LoggerFactory.getLogger(ZeroCrossingErrorDetectorChart.class);
    private ObservableList<XYChart.Data<Number, Number>> mCurrentSamples = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mCurrentSampleSeries = new XYChart.Series("Samples", this.mCurrentSamples);
    private ObservableList<XYChart.Data<Number, Number>> mPreviousSamples = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mPreviousSampleSeries = new XYChart.Series("Samples", this.mPreviousSamples);
    private ObservableList<XYChart.Data<Number, Number>> mIdeal = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mIdealSeries = new XYChart.Series("Ideal", this.mIdeal);
    private ObservableList<XYChart.Data<Number, Number>> mDetected = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mDetectedSeries = new XYChart.Series("Detected", this.mDetected);
    private LTRNetDecoderInstrumented mLTRNetDecoderInstrumented;

    public ZeroCrossingErrorDetectorChart(LTRNetDecoderInstrumented decoder, int length) {
        super((Axis)new NumberAxis("Samples", 0.0, (double)length, 5.0), (Axis)new NumberAxis("Value", -1.0, 1.0, 0.25));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{this.mCurrentSampleSeries, this.mPreviousSampleSeries, this.mIdealSeries, this.mDetectedSeries});
        this.setData(observableList);
        this.mLTRNetDecoderInstrumented = decoder;
        decoder.bufferCount.addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                ZeroCrossingErrorDetectorChart.this.updateBuffer();
            }
        });
        for (int x = 0; x < length; ++x) {
            XYChart.Data sample = new XYChart.Data((Object)x, (Object)Float.valueOf(0.0f));
            this.mCurrentSamples.add((Object)sample);
            XYChart.Data sample2 = new XYChart.Data((Object)x, (Object)Float.valueOf(0.0f));
            this.mPreviousSamples.add((Object)sample2);
        }
        XYChart.Data ideal1 = new XYChart.Data((Object)5, (Object)Float.valueOf(-0.1f));
        this.mIdeal.add((Object)ideal1);
        XYChart.Data ideal2 = new XYChart.Data((Object)5, (Object)Float.valueOf(-0.9f));
        this.mIdeal.add((Object)ideal2);
        XYChart.Data detected1 = new XYChart.Data((Object)5, (Object)Float.valueOf(-0.25f));
        this.mDetected.add((Object)detected1);
        XYChart.Data detected2 = new XYChart.Data((Object)5, (Object)Float.valueOf(-0.75f));
        this.mDetected.add((Object)detected2);
    }

    private void updateBuffer() {
    }

    public class ErrorChangeListener
    implements ChangeListener {
        public ErrorChangeListener(ZeroCrossingErrorDetectorChart this$0) {
        }

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
        }
    }
}

