/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolChart
extends ScatterChart
implements Listener<Complex> {
    private static final Logger mLog = LoggerFactory.getLogger(SymbolChart.class);
    private ObservableList<XYChart.Data> mCurrentPoints = FXCollections.observableArrayList();
    private int mDataPointer;
    private int mHistory;

    public SymbolChart(int history) {
        super((Axis)new NumberAxis("I", -1.1, 1.1, 0.2), (Axis)new NumberAxis("Q", -1.1, 1.1, 0.2));
        this.mHistory = history;
        for (int x = 0; x < this.mHistory; ++x) {
            this.mCurrentPoints.add((Object)new XYChart.Data((Object)0.0, (Object)0.0));
        }
        ObservableList data = FXCollections.observableArrayList();
        data.add((Object)new XYChart.Series("Constellation", this.mCurrentPoints));
        this.setData(data);
    }

    @Override
    public void receive(Complex complex) {
        XYChart.Data current = (XYChart.Data)this.mCurrentPoints.get(this.mDataPointer);
        current.setXValue((Object)Float.valueOf(complex.inphase()));
        current.setYValue((Object)Float.valueOf(complex.quadrature()));
        ++this.mDataPointer;
        if (this.mDataPointer >= this.mHistory) {
            this.mDataPointer = 0;
        }
    }
}

