/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.gui.instrument.chart.DoubleLineChart;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;

public class SamplesPerSymbolChart
extends DoubleLineChart {
    private double mFractionalSamplesPerSymbol;
    private double mPreviousSamplesPerSymbol;

    public SamplesPerSymbolChart(int length, double samplesPerSymbol) {
        super("Samples Per Symbol", -1.0, 1.0, 0.1, length);
        this.setSamplesPerSymbol(samplesPerSymbol);
    }

    public void setSamplesPerSymbol(double samplesPerSymbol) {
        this.mFractionalSamplesPerSymbol = samplesPerSymbol - (double)((int)samplesPerSymbol);
        this.mPreviousSamplesPerSymbol = samplesPerSymbol;
        ObservableList seriesList = this.getData();
        ((XYChart.Series)seriesList.get(0)).setName("Samples Per Symbol:" + samplesPerSymbol);
    }

    @Override
    public void receive(Double samplesPerSymbol) {
        double delta;
        for (delta = samplesPerSymbol - this.mPreviousSamplesPerSymbol - this.mFractionalSamplesPerSymbol; delta < -1.0 + this.mFractionalSamplesPerSymbol; delta += 1.0) {
        }
        while (delta > 1.0) {
            delta -= 1.0;
        }
        super.receive(delta);
        this.mPreviousSamplesPerSymbol = samplesPerSymbol;
    }
}

