/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument;

import io.github.dsheirer.gui.instrument.PlaybackController;
import io.github.dsheirer.gui.instrument.decoder.AbstractDecoderPane;
import io.github.dsheirer.gui.instrument.decoder.DecoderPaneFactory;
import io.github.dsheirer.gui.instrument.decoder.RealDecoderPane;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import java.io.File;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;

public class ViewerDesktop
extends BorderPane {
    private PlaybackController mPlaybackController;
    private AbstractDecoderPane mDecoderPane = DecoderPaneFactory.getDefaultPane();

    public ViewerDesktop() {
        this.setBottom((Node)this.getPlaybackController());
        this.setCenter((Node)this.getDecoderPane());
    }

    public void load(File file) {
        this.close();
        this.getPlaybackController().load(file);
    }

    public void setDecoder(DecoderType decoderType) {
        this.setDecoderPane(DecoderPaneFactory.getDecoderPane(decoderType));
    }

    public void setP25Phase1Decoder(P25P1Decoder.Modulation modulation) {
        this.setDecoderPane(DecoderPaneFactory.getP25P1DecoderPane(modulation));
    }

    private void setDecoderPane(AbstractDecoderPane decoderPane) {
        if (this.getDecoderPane() instanceof RealDecoderPane) {
            this.getPlaybackController().removeRealListener(this.getDecoderPane());
        } else {
            this.getPlaybackController().removeComplexListener(this.getDecoderPane());
        }
        this.getChildren().remove((Object)this.getDecoderPane());
        this.mDecoderPane = decoderPane;
        this.setCenter((Node)this.getDecoderPane());
        if (this.getDecoderPane() instanceof RealDecoderPane) {
            this.getPlaybackController().addRealListener(this.getDecoderPane());
        } else {
            this.getPlaybackController().addComplexListener(this.getDecoderPane());
        }
        this.getPlaybackController().setSampleRateListener(this.getDecoderPane());
    }

    public AbstractDecoderPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = DecoderPaneFactory.getDefaultPane();
        }
        return this.mDecoderPane;
    }

    public void close() {
        this.getPlaybackController().close();
    }

    private PlaybackController getPlaybackController() {
        if (this.mPlaybackController == null) {
            this.mPlaybackController = new PlaybackController();
        }
        return this.mPlaybackController;
    }
}

