/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.gui.instrument.decoder.AbstractDecoderPane;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.IControllableFileSource;
import io.github.dsheirer.source.IFrameLocationListener;
import io.github.dsheirer.source.wave.ComplexWaveSource;
import io.github.dsheirer.source.wave.RealWaveSource;
import java.io.File;
import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javax.sound.sampled.UnsupportedAudioFileException;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaybackController
extends HBox
implements IFrameLocationListener {
    private static final Logger mLog = LoggerFactory.getLogger(PlaybackController.class);
    private Button mRewindButton;
    private TextField mPlaybackPositionText;
    private Button mPlay1Button;
    private Button mPlay10Button;
    private Button mPlay30Button;
    private Button mPlay100Button;
    private Button mPlay1000Button;
    private Button mPlay2000Button;
    private HBox mControlsBox;
    private Label mFileLabel;
    private EventHandler<ActionEvent> mPlayEventHandler;
    private AbstractDecoderPane mSampleRateListener;
    private IControllableFileSource mControllableFileSource;
    private Broadcaster<float[]> mRealBufferBroadcaster = new Broadcaster();
    private Broadcaster<INativeBuffer> mNativeBufferBroadcaster = new Broadcaster();

    public PlaybackController() {
        super(10.0);
        this.getChildren().addAll((Object[])new Node[]{this.getControlsBox(), this.getFileLabel()});
        this.disableControls();
    }

    public void setSampleRateListener(AbstractDecoderPane decoderPane) {
        this.mSampleRateListener = decoderPane;
        if (this.mSampleRateListener != null && this.mControllableFileSource != null) {
            this.mSampleRateListener.setSampleRate(this.mControllableFileSource.getSampleRate());
        }
    }

    public void load(File file) {
        if (file != null && file.isFile()) {
            if (ComplexWaveSource.supports(file)) {
                try {
                    this.mControllableFileSource = new ComplexWaveSource(file);
                    this.mControllableFileSource.setListener(this);
                    ((ComplexWaveSource)this.mControllableFileSource).setListener(this.mNativeBufferBroadcaster);
                    this.mControllableFileSource.open();
                    if (this.mSampleRateListener != null) {
                        this.mSampleRateListener.setSampleRate(this.mControllableFileSource.getSampleRate());
                    }
                }
                catch (UnsupportedAudioFileException e) {
                    mLog.error("Unsupported Audio File Type [" + (file != null ? file.getAbsolutePath() : "null") + "]");
                    Alert alert = new Alert(Alert.AlertType.ERROR, "The file type is unsupported.", new ButtonType[]{ButtonType.OK});
                    alert.show();
                    return;
                }
                catch (IOException ioe) {
                    mLog.error("Error opening file [" + (file != null ? file.getAbsolutePath() : "null") + "]", (Throwable)ioe);
                    Alert alert = new Alert(Alert.AlertType.ERROR, "There was an error opening the file", new ButtonType[]{ButtonType.OK});
                    alert.show();
                    return;
                }
                this.enableControls();
            } else if (RealWaveSource.supports(file)) {
                try {
                    this.mControllableFileSource = new RealWaveSource(file);
                    this.mControllableFileSource.setListener(this);
                    ((RealWaveSource)this.mControllableFileSource).setListener(this.mRealBufferBroadcaster);
                    this.mControllableFileSource.open();
                    if (this.mSampleRateListener != null) {
                        this.mSampleRateListener.setSampleRate(this.mControllableFileSource.getSampleRate());
                    }
                }
                catch (UnsupportedAudioFileException e) {
                    mLog.error("Unsupported Audio File Type [" + (file != null ? file.getAbsolutePath() : "null") + "]");
                    Alert alert = new Alert(Alert.AlertType.ERROR, "The file type is unsupported.", new ButtonType[]{ButtonType.OK});
                    alert.show();
                    return;
                }
                catch (IOException ioe) {
                    mLog.error("Error opening file [" + (file != null ? file.getAbsolutePath() : "null") + "]", (Throwable)ioe);
                    Alert alert = new Alert(Alert.AlertType.ERROR, "There was an error opening the file", new ButtonType[]{ButtonType.OK});
                    alert.show();
                    return;
                }
                this.enableControls();
            }
            this.getFileLabel().setText(file.getName());
        }
    }

    public void close() {
        if (this.mControllableFileSource != null) {
            try {
                this.mControllableFileSource.close();
            }
            catch (IOException ioe) {
                mLog.error("Error closing file", (Throwable)ioe);
            }
        }
        this.disableControls();
    }

    public void addRealListener(Listener<float[]> listener) {
        this.mRealBufferBroadcaster.addListener(listener);
    }

    public void removeRealListener(Listener<float[]> listener) {
        this.mRealBufferBroadcaster.removeListener(listener);
    }

    public void addComplexListener(Listener<INativeBuffer> listener) {
        this.mNativeBufferBroadcaster.addListener(listener);
    }

    public void removeComplexListener(Listener<INativeBuffer> listener) {
        this.mNativeBufferBroadcaster.removeListener(listener);
    }

    private void disableControls() {
        this.getRewindButton().setDisable(true);
        this.getPlaybackPositionText().setDisable(true);
        this.getPlay1Button().setDisable(true);
        this.getPlay10Button().setDisable(true);
        this.getPlay30Button().setDisable(true);
        this.getPlay100Button().setDisable(true);
        this.getPlay1000Button().setDisable(true);
        this.getPlay2000Button().setDisable(true);
    }

    private void enableControls() {
        this.getRewindButton().setDisable(false);
        this.getPlaybackPositionText().setDisable(false);
        this.getPlay1Button().setDisable(false);
        this.getPlay10Button().setDisable(false);
        this.getPlay30Button().setDisable(false);
        this.getPlay100Button().setDisable(false);
        this.getPlay1000Button().setDisable(false);
        this.getPlay2000Button().setDisable(false);
    }

    private HBox getControlsBox() {
        if (this.mControlsBox == null) {
            this.mControlsBox = new HBox();
            this.mControlsBox.getChildren().addAll((Object[])new Node[]{this.getRewindButton(), this.getPlaybackPositionText(), this.getPlay1Button(), this.getPlay10Button(), this.getPlay30Button(), this.getPlay100Button(), this.getPlay1000Button(), this.getPlay2000Button()});
        }
        return this.mControlsBox;
    }

    private Button getRewindButton() {
        if (this.mRewindButton == null) {
            this.mRewindButton = new Button();
            IconNode iconNode = new IconNode((IconCode)FontAwesome.FAST_BACKWARD);
            iconNode.setIconSize((Number)10);
            this.mRewindButton.setGraphic((Node)iconNode);
        }
        return this.mRewindButton;
    }

    private Button getPlay1Button() {
        if (this.mPlay1Button == null) {
            this.mPlay1Button = new Button("1");
            this.mPlay1Button.setUserData((Object)1);
            this.mPlay1Button.setOnAction(this.getPlaybackEventHandler());
            IconNode iconNode = new IconNode((IconCode)FontAwesome.PLAY);
            iconNode.setIconSize((Number)10);
            this.mPlay1Button.setGraphic((Node)iconNode);
        }
        return this.mPlay1Button;
    }

    private Button getPlay10Button() {
        if (this.mPlay10Button == null) {
            this.mPlay10Button = new Button("10");
            this.mPlay10Button.setUserData((Object)10);
            this.mPlay10Button.setOnAction(this.getPlaybackEventHandler());
            IconNode iconNode = new IconNode((IconCode)FontAwesome.FAST_FORWARD);
            iconNode.setIconSize((Number)10);
            this.mPlay10Button.setGraphic((Node)iconNode);
        }
        return this.mPlay10Button;
    }

    private Button getPlay30Button() {
        if (this.mPlay30Button == null) {
            this.mPlay30Button = new Button("30");
            this.mPlay30Button.setUserData((Object)30);
            this.mPlay30Button.setOnAction(this.getPlaybackEventHandler());
            IconNode iconNode = new IconNode((IconCode)FontAwesome.FAST_FORWARD);
            iconNode.setIconSize((Number)10);
            this.mPlay30Button.setGraphic((Node)iconNode);
        }
        return this.mPlay30Button;
    }

    private Button getPlay100Button() {
        if (this.mPlay100Button == null) {
            this.mPlay100Button = new Button("100");
            this.mPlay100Button.setUserData((Object)100);
            this.mPlay100Button.setOnAction(this.getPlaybackEventHandler());
            IconNode iconNode = new IconNode((IconCode)FontAwesome.FAST_FORWARD);
            iconNode.setIconSize((Number)10);
            this.mPlay100Button.setGraphic((Node)iconNode);
        }
        return this.mPlay100Button;
    }

    private Button getPlay1000Button() {
        if (this.mPlay1000Button == null) {
            this.mPlay1000Button = new Button("1000");
            this.mPlay1000Button.setUserData((Object)1000);
            this.mPlay1000Button.setOnAction(this.getPlaybackEventHandler());
            IconNode iconNode = new IconNode((IconCode)FontAwesome.FAST_FORWARD);
            iconNode.setIconSize((Number)10);
            this.mPlay1000Button.setGraphic((Node)iconNode);
        }
        return this.mPlay1000Button;
    }

    private Button getPlay2000Button() {
        if (this.mPlay2000Button == null) {
            this.mPlay2000Button = new Button("2000");
            this.mPlay2000Button.setUserData((Object)2000);
            this.mPlay2000Button.setOnAction(this.getPlaybackEventHandler());
            IconNode iconNode = new IconNode((IconCode)FontAwesome.FAST_FORWARD);
            iconNode.setIconSize((Number)10);
            this.mPlay2000Button.setGraphic((Node)iconNode);
        }
        return this.mPlay2000Button;
    }

    private EventHandler<ActionEvent> getPlaybackEventHandler() {
        if (this.mPlayEventHandler == null) {
            this.mPlayEventHandler = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    int count = (Integer)((Button)event.getSource()).getUserData();
                    if (PlaybackController.this.mControllableFileSource != null) {
                        try {
                            PlaybackController.this.mControllableFileSource.next(count, true);
                        }
                        catch (IOException ioe) {
                            mLog.error("Error while playing samples");
                        }
                    }
                }
            };
        }
        return this.mPlayEventHandler;
    }

    private TextField getPlaybackPositionText() {
        if (this.mPlaybackPositionText == null) {
            this.mPlaybackPositionText = new TextField("0");
            this.mPlaybackPositionText.setAlignment(Pos.CENTER);
            this.mPlaybackPositionText.setPrefWidth(80.0);
        }
        return this.mPlaybackPositionText;
    }

    private Label getFileLabel() {
        if (this.mFileLabel == null) {
            this.mFileLabel = new Label();
        }
        return this.mFileLabel;
    }

    @Override
    public void frameLocationUpdated(int location) {
        this.getPlaybackPositionText().setText(String.valueOf(location));
    }

    @Override
    public void frameLocationReset() {
        mLog.info("Frame location reset ... ignoring?");
    }
}

