/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixIdentFormatter
extends TextFormatter<Integer> {
    private static final Logger mLog = LoggerFactory.getLogger(PrefixIdentFormatter.class);

    public PrefixIdentFormatter(int minimum, int maximum) {
        super((StringConverter)new PrefixIdentIntegerStringConverter(), null, (UnaryOperator)new PrefixIdentFilter(minimum, maximum));
    }

    public static class PrefixIdentIntegerStringConverter
    extends StringConverter<Integer> {
        private static final Pattern PREFIX_IDENT_PATTERN = Pattern.compile("(\\d{0,3})(?:-(\\d{0,4}))?");
        private static final int PREFIX_MASK = 1040384;
        private static final int IDENT_MASK = 8191;

        public String toString(Integer value) {
            if (value == null) {
                return "";
            }
            int prefix = (value & 0xFE000) >> 13;
            int ident = value & 0x1FFF;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%03d", prefix));
            sb.append("-");
            sb.append(String.format("%04d", ident));
            return sb.toString();
        }

        public Integer fromString(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            Matcher m = PREFIX_IDENT_PATTERN.matcher(value);
            if (m.matches()) {
                int a = 0;
                int b = 0;
                try {
                    a = Integer.parseInt(m.group(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    b = Integer.parseInt(m.group(2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int talkgroup = (a << 13) + b;
                return talkgroup;
            }
            return null;
        }

        public static boolean isValid(String value) {
            if (value == null || value.isEmpty()) {
                return true;
            }
            Matcher m = PREFIX_IDENT_PATTERN.matcher(value);
            if (m.matches()) {
                String rawIdent;
                String rawPrefix = m.group(1);
                if (rawPrefix != null && !rawPrefix.isEmpty()) {
                    try {
                        int prefix = Integer.parseInt(rawPrefix);
                        if (prefix < 0 || prefix > 127) {
                            return false;
                        }
                    }
                    catch (Exception prefix) {
                        // empty catch block
                    }
                }
                if ((rawIdent = m.group(2)) != null && !rawIdent.isEmpty()) {
                    try {
                        int ident = Integer.parseInt(rawIdent);
                        if (ident < 0 || ident > 8191) {
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static class PrefixIdentFilter
    implements UnaryOperator<TextFormatter.Change> {
        private int mMinimum;
        private int mMaximum;

        public PrefixIdentFilter(int minimum, int maximum) {
            this.mMinimum = minimum;
            this.mMaximum = maximum;
        }

        private boolean isValid(Integer value) {
            return value != null && this.mMinimum <= value && value <= this.mMaximum;
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            String updatedText = change.getControlNewText();
            if (updatedText == null || updatedText.isEmpty()) {
                return change;
            }
            if (PrefixIdentIntegerStringConverter.isValid(updatedText)) {
                return change;
            }
            return null;
        }
    }
}

