/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import io.github.dsheirer.gui.playlist.alias.AliasItemEditor;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerFormatter
extends TextFormatter<Integer> {
    private static final Logger mLog = LoggerFactory.getLogger(AliasItemEditor.class);

    public IntegerFormatter(int minimum, int maximum) {
        super((StringConverter)new IntegerStringConverter(), null, (UnaryOperator)new IntegerFilter(minimum, maximum));
    }

    public static class IntegerFilter
    implements UnaryOperator<TextFormatter.Change> {
        private String DECIMAL_REGEX = "\\-?[0-9].*";
        private int mMinimum;
        private int mMaximum;

        public IntegerFilter(int minimum, int maximum) {
            this.mMinimum = minimum;
            this.mMaximum = maximum;
        }

        private boolean isValid(String value) {
            if (value == null || value.isEmpty()) {
                return true;
            }
            try {
                int parsed = Integer.parseInt(value);
                return this.mMinimum <= parsed && parsed <= this.mMaximum;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            if (change.getText() != null) {
                String updatedText = change.getControlNewText();
                if (updatedText == null || updatedText.isEmpty()) {
                    return change;
                }
                if (!updatedText.matches(this.DECIMAL_REGEX) || !this.isValid(updatedText)) {
                    return null;
                }
            }
            return change;
        }
    }
}

