/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.filter.FilterSet;
import io.github.dsheirer.filter.IFilter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import net.miginfocom.swing.MigLayout;

public class FilterEditorPanel<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTree mTree;
    private DefaultTreeModel mModel;
    private FilterSet<T> mFilterSet;

    public FilterEditorPanel(FilterSet<T> filterSet) {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.mFilterSet = filterSet;
        this.init();
    }

    private void init() {
        DefaultMutableTreeNode root2 = new DefaultMutableTreeNode(this.mFilterSet);
        this.mModel = new DefaultTreeModel(root2);
        this.addFilterSet(this.mFilterSet, root2);
        this.mTree = new JTree(this.mModel);
        this.mTree.setShowsRootHandles(true);
        this.mTree.getSelectionModel().setSelectionMode(1);
        this.mTree.setCellRenderer(new EditorTreeCellRenderer());
        this.mTree.setCellEditor(new FilterTreeCellEditor());
        this.mTree.setEditable(true);
        this.add(this.mTree);
    }

    public void updateFilterSet(FilterSet<T> filterSet) {
        this.remove(this.mTree);
        this.mFilterSet = filterSet;
        this.init();
        this.revalidate();
    }

    private void addFilterSet(FilterSet<T> filterSet, DefaultMutableTreeNode parent) {
        List<IFilter<T>> filters = filterSet.getFilters();
        for (IFilter<T> filter : filters) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(filter);
            this.mModel.insertNodeInto(childNode, parent, parent.getChildCount());
            if (filter instanceof FilterSet) {
                FilterSet childFilterSet = (FilterSet)filter;
                this.addFilterSet(childFilterSet, childNode);
                continue;
            }
            if (!(filter instanceof Filter)) continue;
            Filter childFilter = (Filter)filter;
            this.addFilter(childFilter, childNode);
        }
    }

    private void addFilter(Filter filter, DefaultMutableTreeNode parent) {
        List elements = filter.getFilterElements();
        elements.sort(Comparator.comparing(FilterElement::getName));
        for (FilterElement element : elements) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(element);
            this.mModel.insertNodeInto(child, parent, parent.getChildCount());
        }
    }

    private DefaultMutableTreeNode getRoot() {
        Object object = this.mTree.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode root2 = (DefaultMutableTreeNode)object;
            return root2;
        }
        return null;
    }

    private void setFilterEnabled(DefaultTreeModel model, DefaultMutableTreeNode node, boolean enabled) {
        Object obj = node.getUserObject();
        if (obj instanceof FilterElement) {
            FilterElement filterElement = (FilterElement)obj;
            filterElement.setEnabled(enabled);
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)child;
            this.setFilterEnabled(model, childNode, enabled);
        }
        model.nodeChanged(node);
    }

    private DefaultMutableTreeNode findFilterElementNode(DefaultMutableTreeNode node, FilterElement<?> element) {
        if (node != null) {
            FilterElement selfFilterElement;
            Object object = node.getUserObject();
            if (object instanceof FilterElement && (selfFilterElement = (FilterElement)object).equals(element)) {
                return node;
            }
            for (int x = 0; x < node.getChildCount(); ++x) {
                DefaultMutableTreeNode child;
                DefaultMutableTreeNode found;
                TreeNode treeNode = node.getChildAt(x);
                if (!(treeNode instanceof DefaultMutableTreeNode) || (found = this.findFilterElementNode(child = (DefaultMutableTreeNode)treeNode, element)) == null) continue;
                return found;
            }
        }
        return null;
    }

    private void updateParentage(DefaultMutableTreeNode node) {
        this.mModel.nodeChanged(node);
        for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            this.mModel.nodeChanged(parent);
        }
    }

    private DefaultMutableTreeNode findFilterNode(DefaultMutableTreeNode node, IFilter<?> filter) {
        if (node != null) {
            IFilter selfFilter;
            Object object = node.getUserObject();
            if (object instanceof IFilter && (selfFilter = (IFilter)object).equals(filter)) {
                return node;
            }
            for (int x = 0; x < node.getChildCount(); ++x) {
                DefaultMutableTreeNode child;
                DefaultMutableTreeNode found;
                TreeNode treeNode = node.getChildAt(x);
                if (!(treeNode instanceof DefaultMutableTreeNode) || (found = this.findFilterNode(child = (DefaultMutableTreeNode)treeNode, filter)) == null) continue;
                return found;
            }
        } else {
            System.out.println("Can't evaluate - node is null");
        }
        return null;
    }

    public class EditorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object treeNode, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (treeNode instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)treeNode).getUserObject();
                JCheckBox checkBox = null;
                if (userObject instanceof IFilter) {
                    IFilter filter = (IFilter)userObject;
                    checkBox = new FilterCheckBox(filter);
                    checkBox.setSelected(filter.isEnabled());
                } else if (userObject instanceof FilterElement) {
                    FilterElement element = (FilterElement)userObject;
                    checkBox = new FilterElementCheckBox(element);
                    checkBox.setSelected(element.isEnabled());
                }
                if (checkBox != null) {
                    if (selected) {
                        checkBox.setForeground(this.getTextSelectionColor());
                        checkBox.setBackground(this.getBackgroundSelectionColor());
                    } else {
                        checkBox.setForeground(this.getTextNonSelectionColor());
                        checkBox.setBackground(this.getBackgroundNonSelectionColor());
                    }
                    return checkBox;
                }
            }
            return super.getTreeCellRendererComponent(tree, treeNode, selected, expanded, leaf, row, hasFocus);
        }
    }

    public class FilterTreeCellEditor
    implements TreeCellEditor {
        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object node, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode mutableTreeNode = (DefaultMutableTreeNode)node;
                Object userObject = mutableTreeNode.getUserObject();
                if (userObject instanceof IFilter) {
                    IFilter filter = (IFilter)userObject;
                    return new FilterCheckBox(filter);
                }
                if (userObject instanceof FilterElement) {
                    FilterElement filterElement = (FilterElement)userObject;
                    return new FilterElementCheckBox(filterElement);
                }
            }
            return new JLabel(node.toString());
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }
    }

    public class FilterElementCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 1L;
        private FilterElement<?> mFilter;

        public FilterElementCheckBox(FilterElement<?> filter) {
            super(filter.getName());
            this.mFilter = filter;
            this.setSelected(this.mFilter.isEnabled());
            this.addItemListener(arg0 -> {
                this.mFilter.setEnabled(this.isSelected());
                DefaultMutableTreeNode self = FilterEditorPanel.this.findFilterElementNode(FilterEditorPanel.this.getRoot(), this.mFilter);
                if (self != null) {
                    FilterEditorPanel.this.updateParentage(self);
                }
            });
        }
    }

    public class FilterCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 1L;
        private IFilter<?> mFilter;

        public FilterCheckBox(IFilter<?> filter) {
            this.mFilter = filter;
            this.setSelected(this.mFilter.isEnabled());
            this.addItemListener(e -> {
                DefaultMutableTreeNode selfNode = FilterEditorPanel.this.findFilterNode(FilterEditorPanel.this.getRoot(), this.mFilter);
                if (selfNode != null) {
                    FilterEditorPanel.this.setFilterEnabled(FilterEditorPanel.this.mModel, selfNode, this.isSelected());
                    this.updateLabel();
                    FilterEditorPanel.this.updateParentage(selfNode);
                }
            });
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            this.updateLabel();
        }

        public void updateLabel() {
            this.setText(this.mFilter.getName() + " (" + this.mFilter.getEnabledCount() + "/" + this.mFilter.getElementCount() + ")");
        }
    }
}

