/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;

public class Hamming17 {
    private static int[] CHECKSUMS = new int[]{27, 31, 29, 28, 14, 7, 17, 26, 13, 20, 10, 5};

    public static int checkAndCorrect(BinaryMessage frame, int startIndex) {
        int syndrome = Hamming17.getSyndrome(frame, startIndex);
        switch (syndrome) {
            case 0: {
                return 0;
            }
            case 1: {
                frame.flip(startIndex + 16);
                return 1;
            }
            case 2: {
                frame.flip(startIndex + 15);
                return 1;
            }
            case 3: {
                frame.flip(startIndex + 11);
                return 1;
            }
            case 4: {
                frame.flip(startIndex + 14);
                return 1;
            }
            case 5: {
                frame.flip(startIndex + 10);
                return 1;
            }
            case 6: {
                frame.flip(startIndex + 9);
                return 1;
            }
            case 7: {
                frame.flip(startIndex + 8);
                return 1;
            }
            case 8: {
                frame.flip(startIndex + 13);
                return 1;
            }
            case 9: {
                frame.flip(startIndex + 7);
                return 1;
            }
            case 10: {
                frame.flip(startIndex + 6);
                return 1;
            }
            case 11: {
                frame.flip(startIndex + 5);
                return 1;
            }
            case 12: {
                frame.flip(startIndex + 4);
                return 1;
            }
            case 13: {
                frame.flip(startIndex + 3);
                return 1;
            }
            case 14: {
                frame.flip(startIndex + 2);
                return 1;
            }
            case 15: {
                frame.flip(startIndex + 1);
                return 1;
            }
            case 16: {
                frame.flip(startIndex + 12);
                return 1;
            }
            case 17: {
                frame.flip(startIndex);
                return 1;
            }
        }
        return 2;
    }

    private static int calculateChecksum(BinaryMessage frame, int startIndex) {
        int calculated = 0;
        int i = frame.nextSetBit(startIndex);
        while (i >= startIndex && i < startIndex + 12) {
            calculated ^= CHECKSUMS[i - startIndex];
            i = frame.nextSetBit(i + 1);
        }
        return calculated;
    }

    private static int getSyndrome(BinaryMessage frame, int startIndex) {
        int calculated = Hamming17.calculateChecksum(frame, startIndex);
        int checksum = frame.getInt(startIndex + 12, startIndex + 16);
        return checksum ^ calculated;
    }
}

