/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.Golay24;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRCP25 {
    private static final Logger mLog = LoggerFactory.getLogger(CRCP25.class);
    public static final int[] CCITT_80_CHECKSUMS = new int[]{7115, 36325, 50930, 27497, 46516, 21194, 8565, 37050, 16461, 40998, 22531, 44033, 54784, 25360, 14744, 5340, 638, 2351, 33943, 49739, 57637, 61586, 28761, 47148, 21510, 8723, 37129, 51332, 27730, 15929, 40732, 18334, 11231, 38383, 51959, 58747, 62141, 63838, 29887, 47711, 56623, 61079, 63307, 64421, 64978, 30457, 47996, 21934, 8903, 37219, 51377, 58456, 31292, 13582, 4759, 35147, 50341, 57938, 31033, 48284, 22110, 9023, 37279, 51407, 58471, 62003, 63769, 64652, 30294, 13115, 39325, 52430, 28279, 46907, 56221, 60878, 32503, 49019, 57277, 61406, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    public static final int[] CRC9_CHECKSUMS = new int[]{487, 499, 505, 508, 210, 69, 290, 189, 350, 131, 321, 416, 252, 82, 5, 258, 173, 342, 135, 323, 417, 464, 196, 78, 11, 261, 386, 237, 374, 151, 331, 421, 466, 197, 354, 157, 334, 139, 325, 418, 253, 382, 147, 329, 420, 254, 83, 297, 404, 230, 95, 303, 407, 459, 485, 498, 213, 362, 153, 332, 138, 105, 308, 182, 119, 315, 413, 462, 203, 357, 434, 245, 378, 145, 328, 136, 104, 24, 32, 60, 50, 53, 282, 161, 336, 132, 110, 27, 269, 390, 239, 375, 443, 477, 494, 219, 365, 438, 247, 379, 445, 478, 195, 353, 432, 244, 86, 7, 259, 385, 448, 204, 74, 9, 260, 174, 123, 317, 414, 227, 369, 440, 240, 84, 6, 47, 279, 395, 453, 482, 221, 366, 155, 333, 422};
    public static final long[] PDU1_CHECKSUMS = new long[]{2264902348L, 1092574141L, 2693770718L, 1378310196L, 728965825L, 2511966560L, 1220298347L, 2757632821L, 3526300058L, 1802962454L, 937102800L, 428673075L, 2361820185L, 3328393740L, 1632710621L, 2963838958L, 1513407788L, 796585037L, 2545776166L, 1237202376L, 650089535L, 2472528415L, 3383747855L, 3839357575L, 4067162435L, 4181064865L, 4238016080L, 2083385843L, 3189176569L, 3742071932L, 1843736805L, 3069352050L, 1494860514L, 787247018L, 353810702L, 149672540L, 102066165L, 2198516730L, 1139136294L, 596796744L, 329890943L, 2312429119L, 3303698207L, 3799332751L, 4047150023L, 4171058659L, 4233012977L, 4263990136L, 2104698727L, 3199833011L, 3747400153L, 4021183724L, 1974975661L, 3134971478L, 1594712560L, 770063907L, 2532515601L, 3413741448L, 1742489887L, 3018728591L, 3656847943L, 3975907619L, 4135437457L, 4215202376L, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L};
    public static final long[] PDU2_CHECKSUMS = new long[]{2636323161L, 3465645228L, 1697138829L, 2996053062L, 1529519352L, 804634791L, 2549801043L, 3422384169L, 3858675732L, 1889522385L, 3092244840L, 1581742703L, 2938354999L, 3616661147L, 3955814221L, 4125390758L, 2022880520L, 1042928735L, 2668948015L, 3481957655L, 3888462475L, 4091714885L, 4193341090L, 2123901322L, 1026333214L, 485934036L, 203157297L, 2249062296L, 1097233687L, 2696100491L, 3495533893L, 3895250594L, 1987504522L, 962329118L, 516781012L, 218511153L, 2256739224L, 1092682519L, 2693824907L, 3494396101L, 3894681698L, 1987223274L, 962183598L, 516713996L, 218544605L, 2256755950L, 1092690092L, 586161805L, 2440564550L, 1255967096L, 655280743L, 2475124019L, 3385045657L, 3840006476L, 1880121981L, 3087544638L, 1583650372L, 760399353L, 2527683324L, 1228160933L, 2761564114L, 1345159474L, 712396354L, 391883258L, 164452902L, 109454280L, 19111743L, 2157039519L, 3226003407L, 3760485351L, 4027726323L, 4161346809L, 4228157052L, 2086848997L, 3190908146L, 1568160930L, 752652426L, 336512670L, 141028756L, 106133521L, 2200550408L, 1140084959L, 2717526127L, 3506246711L, 3900607003L, 4097787149L, 4196377222L, 2138005400L, 1037508887L, 2666238091L, 3480602693L, 3887784994L, 1908276426L, 985559230L, 524269188L, 234837401L, 2264902348L, 1092574141L, 2693770718L, 1378310196L, 728965825L, 2511966560L, 1220298347L, 2757632821L, 3526300058L, 1802962454L, 937102800L, 428673075L, 2361820185L, 3328393740L, 1632710621L, 2963838958L, 1513407788L, 796585037L, 2545776166L, 1237202376L, 650089535L, 2472528415L, 3383747855L, 3839357575L, 4067162435L, 4181064865L, 4238016080L, 2083385843L, 3189176569L, 3742071932L, 1843736805L, 3069352050L, 1494860514L, 787247018L, 353810702L, 149672540L, 102066165L, 2198516730L, 1139136294L, 596796744L, 329890943L, 2312429119L, 3303698207L, 3799332751L, 4047150023L, 4171058659L, 4233012977L, 4263990136L, 2104698727L, 3199833011L, 3747400153L, 4021183724L, 1974975661L, 3134971478L, 1594712560L, 770063907L, 2532515601L, 3413741448L, 1742489887L, 3018728591L, 3656847943L, 3975907619L, 4135437457L, 4215202376L, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L};
    public static final long[] PDU3_CHECKSUMS = new long[]{2858394736L, 1464818915L, 2879893105L, 3587430200L, 1753834823L, 3024401059L, 3659684177L, 3977325736L, 1961367695L, 3128167495L, 3711567395L, 4003267345L, 4149117320L, 2043137567L, 3169052431L, 3732009863L, 4013488579L, 4154227937L, 4224597616L, 2139591139L, 3217279217L, 3756123256L, 1838185703L, 3066576499L, 3680771897L, 3987869596L, 1958316309L, 3126641802L, 1599007902L, 768080020L, 344158865L, 2319563080L, 1195397759L, 2745182527L, 3520074911L, 3907521103L, 4101244199L, 4198105747L, 4246536521L, 4270751908L, 2099760777L, 3197364036L, 1563000185L, 2928983740L, 1428869509L, 2861918402L, 1462385338L, 703959942L, 379209496L, 153988439L, 2224477867L, 3259722581L, 3777344938L, 1928483854L, 991536348L, 535583925L, 2415275610L, 1167825398L, 548225568L, 305541067L, 2300254181L, 3297610738L, 1613122338L, 846441290L, 458840958L, 265036644L, 92708713L, 2193838004L, 1124149505L, 2709558400L, 1386267803L, 2840617549L, 3567792422L, 1748276808L, 914015743L, 2604491519L, 3449729407L, 3872348351L, 4083657823L, 4189312559L, 4242139927L, 4268553611L, 4281760453L, 4288363874L, 2108493930L, 1018562286L, 473664940L, 209537037L, 2252252166L, 1098898648L, 585064631L, 2440015963L, 3367491629L, 3831229462L, 1884125392L, 977679027L, 2636323161L, 3465645228L, 1697138829L, 2996053062L, 1529519352L, 804634791L, 2549801043L, 3422384169L, 3858675732L, 1889522385L, 3092244840L, 1581742703L, 2938354999L, 3616661147L, 3955814221L, 4125390758L, 2022880520L, 1042928735L, 2668948015L, 3481957655L, 3888462475L, 4091714885L, 4193341090L, 2123901322L, 1026333214L, 485934036L, 203157297L, 2249062296L, 1097233687L, 2696100491L, 3495533893L, 3895250594L, 1987504522L, 962329118L, 516781012L, 218511153L, 2256739224L, 1092682519L, 2693824907L, 3494396101L, 3894681698L, 1987223274L, 962183598L, 516713996L, 218544605L, 2256755950L, 1092690092L, 586161805L, 2440564550L, 1255967096L, 655280743L, 2475124019L, 3385045657L, 3840006476L, 1880121981L, 3087544638L, 1583650372L, 760399353L, 2527683324L, 1228160933L, 2761564114L, 1345159474L, 712396354L, 391883258L, 164452902L, 109454280L, 19111743L, 2157039519L, 3226003407L, 3760485351L, 4027726323L, 4161346809L, 4228157052L, 2086848997L, 3190908146L, 1568160930L, 752652426L, 336512670L, 141028756L, 106133521L, 2200550408L, 1140084959L, 2717526127L, 3506246711L, 3900607003L, 4097787149L, 4196377222L, 2138005400L, 1037508887L, 2666238091L, 3480602693L, 3887784994L, 1908276426L, 985559230L, 524269188L, 234837401L, 2264902348L, 1092574141L, 2693770718L, 1378310196L, 728965825L, 2511966560L, 1220298347L, 2757632821L, 3526300058L, 1802962454L, 937102800L, 428673075L, 2361820185L, 3328393740L, 1632710621L, 2963838958L, 1513407788L, 796585037L, 2545776166L, 1237202376L, 650089535L, 2472528415L, 3383747855L, 3839357575L, 4067162435L, 4181064865L, 4238016080L, 2083385843L, 3189176569L, 3742071932L, 1843736805L, 3069352050L, 1494860514L, 787247018L, 353810702L, 149672540L, 102066165L, 2198516730L, 1139136294L, 596796744L, 329890943L, 2312429119L, 3303698207L, 3799332751L, 4047150023L, 4171058659L, 4233012977L, 4263990136L, 2104698727L, 3199833011L, 3747400153L, 4021183724L, 1974975661L, 3134971478L, 1594712560L, 770063907L, 2532515601L, 3413741448L, 1742489887L, 3018728591L, 3656847943L, 3975907619L, 4135437457L, 4215202376L, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L};

    public static BinaryMessage correctPDU1(BinaryMessage message) {
        return CRCP25.correctPDU(message, PDU1_CHECKSUMS, 224);
    }

    public static BinaryMessage correctPDU2(BinaryMessage message) {
        return CRCP25.correctPDU(message, PDU2_CHECKSUMS, 320);
    }

    public static BinaryMessage correctPDU3(BinaryMessage message) {
        return CRCP25.correctPDU(message, PDU3_CHECKSUMS, 416);
    }

    public static BinaryMessage correctPDU(BinaryMessage message, long[] checksums, int crcStart) {
        long calculated = 0L;
        int messageStart = 160;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < crcStart) {
            calculated ^= checksums[i - messageStart];
            i = message.nextSetBit(i + 1);
        }
        long checksum = CRCP25.getLongChecksum(message, crcStart, 32);
        long error = calculated ^ checksum;
        if (error == 0L || error == 0xFFFFFFFFL) {
            message.setCRC(CRC.PASSED);
            return message;
        }
        int errorLocation = CRCP25.getBitError(error, checksums);
        if (errorLocation >= 0) {
            message.flip(errorLocation + messageStart);
            message.setCRC(CRC.CORRECTED);
            return message;
        }
        message.setCRC(CRC.FAILED_CRC);
        return message;
    }

    public static BinaryMessage correctCCITT80(BinaryMessage message, int messageStart, int crcStart) {
        int calculated = 0;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < crcStart) {
            calculated ^= CCITT_80_CHECKSUMS[i - messageStart];
            i = message.nextSetBit(i + 1);
        }
        int checksum = CRCP25.getIntChecksum(message, crcStart, 16);
        int residual = calculated ^ checksum;
        if (residual == 0 || residual == 65535) {
            message.setCRC(CRC.PASSED);
            return message;
        }
        int errorLocation = CRCP25.getBitError(residual, CCITT_80_CHECKSUMS);
        if (errorLocation >= 0) {
            message.flip(errorLocation + messageStart);
            message.setCRC(CRC.CORRECTED);
            return message;
        }
        message.setCRC(CRC.FAILED_CRC);
        return message;
    }

    public static int correctCCITT80(CorrectedBinaryMessage message, int messageStart, int crcStart) {
        int calculated = 65535;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < crcStart) {
            calculated ^= CCITT_80_CHECKSUMS[i - messageStart];
            i = message.nextSetBit(i + 1);
        }
        int checksum = CRCP25.getIntChecksum(message, crcStart, 16);
        int residual = calculated ^ checksum;
        if (residual == 0 || residual == 65535) {
            return 0;
        }
        int errorLocation = CRCP25.getBitError(residual, CCITT_80_CHECKSUMS);
        if (errorLocation >= 0) {
            message.flip(errorLocation + messageStart);
            message.incrementCorrectedBitCount(1);
            return 1;
        }
        message.incrementCorrectedBitCount(2);
        return 2;
    }

    public static CRC checkCRC9(BinaryMessage message, int messageStart) {
        int calculated = 0;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < messageStart + 144) {
            if (i < messageStart + 7) {
                calculated ^= CRC9_CHECKSUMS[i - messageStart];
            } else if (i > messageStart + 15) {
                calculated ^= CRC9_CHECKSUMS[i - messageStart - 9];
            }
            i = message.nextSetBit(i + 1);
        }
        int checksum = message.getInt(messageStart + 7, messageStart + 15);
        int residual = calculated ^ checksum;
        if (residual == 0 || residual == 511) {
            return CRC.PASSED;
        }
        return CRC.FAILED_CRC;
    }

    public static boolean correctGalois24(CorrectedBinaryMessage tdulc) {
        boolean passes = true;
        for (int x = 64; x < tdulc.size() && passes; x += 24) {
            int errors = Golay24.checkAndCorrect(tdulc, x);
            passes = errors < 2;
        }
        return passes;
    }

    public static long getLongChecksum(BinaryMessage message, int crcStart, int crcLength) {
        return message.getLong(crcStart, crcStart + crcLength - 1);
    }

    public static int getIntChecksum(BinaryMessage message, int crcStart, int crcLength) {
        return message.getInt(crcStart, crcStart + crcLength - 1);
    }

    public static int getBitError(long checksumError, long[] checksums) {
        for (int x = 0; x < checksums.length; ++x) {
            if (checksums[x] != checksumError) continue;
            return x;
        }
        return -1;
    }

    public static int getBitError(int checksumError, int[] checksums) {
        for (int x = 0; x < checksums.length; ++x) {
            if (checksums[x] != checksumError) continue;
            return x;
        }
        return -1;
    }

    public static void main(String[] args) {
        String raw = "000000001000001100000001010001111011000100001010010001111100000000000101000000000000000001000000000000110000000000000001101010101010101010101010";
        BinaryMessage message = BinaryMessage.load(raw);
        mLog.debug("MSG:" + message.toString());
        CRC results = CRCP25.checkCRC9(message, 0);
        mLog.debug("COR:" + message.toString());
        mLog.debug("Results: " + results.getDisplayText());
    }
}

