/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRCDMR {
    private static final Logger mLog = LoggerFactory.getLogger(CRCDMR.class);
    public static final int[] CCITT_80_CHECKSUMS = new int[]{58420, 29210, 14605, 38038, 19019, 44341, 56970, 28485, 49074, 24537, 43004, 21502, 10751, 40175, 50791, 60195, 64897, 63184, 31592, 15796, 7898, 3949, 36774, 18387, 44025, 56812, 28406, 14203, 37805, 49606, 24803, 47201, 54304, 27152, 13576, 6788, 3394, 1697, 35648, 17824, 8912, 4456, 2228, 1114, 557, 35078, 17539, 43601, 56632, 28316, 14158, 7079, 34243, 51953, 60776, 30388, 15194, 7597, 34502, 17251, 43425, 56512, 28256, 14128, 7064, 3532, 1766, 883, 35241, 52420, 26210, 13105, 37256, 18628, 9314, 4657, 33032, 16516, 8258, 4129, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    public static final int[] CRC9_CHECKSUMS = new int[]{487, 499, 505, 508, 210, 69, 290, 189, 350, 131, 321, 416, 252, 82, 5, 258, 173, 342, 135, 323, 417, 464, 196, 78, 11, 261, 386, 237, 374, 151, 331, 421, 466, 197, 354, 157, 334, 139, 325, 418, 253, 382, 147, 329, 420, 254, 83, 297, 404, 230, 95, 303, 407, 459, 485, 498, 213, 362, 153, 332, 138, 105, 308, 182, 119, 315, 413, 462, 203, 357, 434, 245, 378, 145, 328, 136, 104, 24, 32, 60, 50, 53, 282, 161, 336, 132, 110, 27, 269, 390, 239, 375, 443, 477, 494, 219, 365, 438, 247, 379, 445, 478, 195, 353, 432, 244, 86, 7, 259, 385, 448, 204, 74, 9, 260, 174, 123, 317, 414, 227, 369, 440, 240, 84, 6, 47, 279, 395, 453, 482, 221, 366, 155, 333, 422};

    public static BinaryMessage correctCCITT80(BinaryMessage message, int messageStart, int crcStart) {
        int calculated = 0;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < crcStart) {
            calculated ^= CCITT_80_CHECKSUMS[i - messageStart];
            i = message.nextSetBit(i + 1);
        }
        int checksum = CRCDMR.getIntChecksum(message, crcStart, 16);
        int residual = calculated ^ checksum;
        if (residual == 0 || residual == 65535) {
            message.setCRC(CRC.PASSED);
            return message;
        }
        int errorLocation = CRCDMR.getBitError(residual, CCITT_80_CHECKSUMS);
        if (errorLocation >= 0) {
            message.flip(errorLocation + messageStart);
            message.setCRC(CRC.CORRECTED);
            return message;
        }
        message.setCRC(CRC.FAILED_CRC);
        return message;
    }

    public static int calculate(BinaryMessage message, int start, int length, long[] checksums) {
        int calculated = 0;
        int i = message.nextSetBit(start);
        while (i >= start && i < length) {
            calculated = (int)((long)calculated ^ checksums[i - start]);
            i = message.nextSetBit(i + 1);
        }
        return calculated;
    }

    public static int correctCCITT80(CorrectedBinaryMessage message, int messageStart, int crcStart, int mask) {
        int calculated = mask;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < crcStart) {
            calculated ^= CCITT_80_CHECKSUMS[i - messageStart];
            i = message.nextSetBit(i + 1);
        }
        int checksum = CRCDMR.getIntChecksum(message, crcStart, 16);
        int residual = calculated ^ checksum;
        if (residual == 0 || residual == 65535) {
            return 0;
        }
        int errorLocation = CRCDMR.getBitError(residual, CCITT_80_CHECKSUMS);
        if (errorLocation >= 0) {
            message.flip(errorLocation + messageStart);
            message.incrementCorrectedBitCount(1);
            return 1;
        }
        message.incrementCorrectedBitCount(2);
        return 2;
    }

    public static int calculateResidual(CorrectedBinaryMessage message, int messageStart, int crcStart) {
        int calculated = 0;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < crcStart) {
            calculated ^= CCITT_80_CHECKSUMS[i - messageStart];
            i = message.nextSetBit(i + 1);
        }
        int checksum = CRCDMR.getIntChecksum(message, crcStart, 16);
        return calculated ^ checksum;
    }

    public static CRC checkCRC9(BinaryMessage message, int messageStart) {
        int calculated = 0;
        int i = message.nextSetBit(messageStart);
        while (i >= messageStart && i < messageStart + 144) {
            if (i < messageStart + 7) {
                calculated ^= CRC9_CHECKSUMS[i - messageStart];
            } else if (i > messageStart + 15) {
                calculated ^= CRC9_CHECKSUMS[i - messageStart - 9];
            }
            i = message.nextSetBit(i + 1);
        }
        int checksum = message.getInt(messageStart + 7, messageStart + 15);
        int residual = calculated ^ checksum;
        if (residual == 0 || residual == 511) {
            return CRC.PASSED;
        }
        return CRC.FAILED_CRC;
    }

    public static long getLongChecksum(BinaryMessage message, int crcStart, int crcLength) {
        return message.getLong(crcStart, crcStart + crcLength - 1);
    }

    public static int getIntChecksum(BinaryMessage message, int crcStart, int crcLength) {
        return message.getInt(crcStart, crcStart + crcLength - 1);
    }

    public static int getBitError(long checksumError, long[] checksums) {
        for (int x = 0; x < checksums.length; ++x) {
            if (checksums[x] != checksumError) continue;
            return x;
        }
        return -1;
    }

    public static int getBitError(int checksumError, int[] checksums) {
        for (int x = 0; x < checksums.length; ++x) {
            if (checksums[x] != checksumError) continue;
            return x;
        }
        return -1;
    }

    public static int crc8(BinaryMessage bits, int len) {
        int i;
        int crc = 0;
        int K = 8;
        boolean[] poly = new boolean[]{true, false, false, false, false, false, true, true, true};
        boolean[] buf = new boolean[256];
        if (len + 8 > 256) {
            return 0;
        }
        for (i = 0; i < len; ++i) {
            buf[i] = bits.get(i);
        }
        for (i = 0; i < len; ++i) {
            if (!buf[i]) continue;
            for (int j = 0; j < 9; ++j) {
                int n = i + j;
                buf[n] = buf[n] ^ poly[j];
            }
        }
        for (i = 0; i < 8; ++i) {
            crc = (crc << 1) + (buf[len + i] ? 1 : 0);
        }
        return crc;
    }
}

